/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotLocaleResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotLocaleResponse.Builder, DescribeBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotLocaleResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeBotLocaleResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeBotLocaleResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeName").getter(getter(DescribeBotLocaleResponse::localeName)).setter(setter(Builder::localeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeBotLocaleResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(DescribeBotLocaleResponse::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(DescribeBotLocaleResponse::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final SdkField<Integer> INTENTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("intentsCount").getter(getter(DescribeBotLocaleResponse::intentsCount))
            .setter(setter(Builder::intentsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentsCount").build()).build();

    private static final SdkField<Integer> SLOT_TYPES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("slotTypesCount").getter(getter(DescribeBotLocaleResponse::slotTypesCount))
            .setter(setter(Builder::slotTypesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypesCount").build()).build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(DescribeBotLocaleResponse::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeBotLocaleResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotLocaleResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeBotLocaleResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<Instant> LAST_BUILD_SUBMITTED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastBuildSubmittedDateTime")
            .getter(getter(DescribeBotLocaleResponse::lastBuildSubmittedDateTime))
            .setter(setter(Builder::lastBuildSubmittedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastBuildSubmittedDateTime").build())
            .build();

    private static final SdkField<List<BotLocaleHistoryEvent>> BOT_LOCALE_HISTORY_EVENTS_FIELD = SdkField
            .<List<BotLocaleHistoryEvent>> builder(MarshallingType.LIST)
            .memberName("botLocaleHistoryEvents")
            .getter(getter(DescribeBotLocaleResponse::botLocaleHistoryEvents))
            .setter(setter(Builder::botLocaleHistoryEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleHistoryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotLocaleHistoryEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotLocaleHistoryEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, LOCALE_NAME_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD,
            VOICE_SETTINGS_FIELD, INTENTS_COUNT_FIELD, SLOT_TYPES_COUNT_FIELD, BOT_LOCALE_STATUS_FIELD, FAILURE_REASONS_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LAST_BUILD_SUBMITTED_DATE_TIME_FIELD,
            BOT_LOCALE_HISTORY_EVENTS_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String localeName;

    private final String description;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private final Integer intentsCount;

    private final Integer slotTypesCount;

    private final String botLocaleStatus;

    private final List<String> failureReasons;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final Instant lastBuildSubmittedDateTime;

    private final List<BotLocaleHistoryEvent> botLocaleHistoryEvents;

    private DescribeBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.localeName = builder.localeName;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
        this.intentsCount = builder.intentsCount;
        this.slotTypesCount = builder.slotTypesCount;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.lastBuildSubmittedDateTime = builder.lastBuildSubmittedDateTime;
        this.botLocaleHistoryEvents = builder.botLocaleHistoryEvents;
    }

    /**
     * <p>
     * The identifier of the bot associated with the locale.
     * </p>
     * 
     * @return The identifier of the bot associated with the locale.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with the locale.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with the locale.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The unique identifier of the described locale.
     * </p>
     * 
     * @return The unique identifier of the described locale.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The name of the locale.
     * </p>
     * 
     * @return The name of the locale.
     */
    public final String localeName() {
        return localeName;
    }

    /**
     * <p>
     * The description of the locale.
     * </p>
     * 
     * @return The description of the locale.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
     * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     * </p>
     * 
     * @return The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
     *         <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
     * </p>
     * 
     * @return The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    /**
     * <p>
     * The number of intents defined for the locale.
     * </p>
     * 
     * @return The number of intents defined for the locale.
     */
    public final Integer intentsCount() {
        return intentsCount;
    }

    /**
     * <p>
     * The number of slot types defined for the locale.
     * </p>
     * 
     * @return The number of slot types defined for the locale.
     */
    public final Integer slotTypesCount() {
        return slotTypesCount;
    }

    /**
     * <p>
     * The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the
     * <code>failureReasons</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in
     *         the <code>failureReasons</code> field.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the
     * <code>failureReasons</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in
     *         the <code>failureReasons</code> field.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the
     *         bot.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * The date and time that the locale was created.
     * </p>
     * 
     * @return The date and time that the locale was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time that the locale was last updated.
     * </p>
     * 
     * @return The date and time that the locale was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The date and time that the locale was last submitted for building.
     * </p>
     * 
     * @return The date and time that the locale was last submitted for building.
     */
    public final Instant lastBuildSubmittedDateTime() {
        return lastBuildSubmittedDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotLocaleHistoryEvents property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotLocaleHistoryEvents() {
        return botLocaleHistoryEvents != null && !(botLocaleHistoryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotLocaleHistoryEvents} method.
     * </p>
     * 
     * @return History of changes, such as when a locale is used in an alias, that have taken place for the locale.
     */
    public final List<BotLocaleHistoryEvent> botLocaleHistoryEvents() {
        return botLocaleHistoryEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(localeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(intentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypesCount());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastBuildSubmittedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotLocaleHistoryEvents() ? botLocaleHistoryEvents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotLocaleResponse)) {
            return false;
        }
        DescribeBotLocaleResponse other = (DescribeBotLocaleResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(localeName(), other.localeName())
                && Objects.equals(description(), other.description())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings()) && Objects.equals(intentsCount(), other.intentsCount())
                && Objects.equals(slotTypesCount(), other.slotTypesCount())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(lastBuildSubmittedDateTime(), other.lastBuildSubmittedDateTime())
                && hasBotLocaleHistoryEvents() == other.hasBotLocaleHistoryEvents()
                && Objects.equals(botLocaleHistoryEvents(), other.botLocaleHistoryEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotLocaleResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("LocaleName", localeName()).add("Description", description())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold()).add("VoiceSettings", voiceSettings())
                .add("IntentsCount", intentsCount()).add("SlotTypesCount", slotTypesCount())
                .add("BotLocaleStatus", botLocaleStatusAsString())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("LastBuildSubmittedDateTime", lastBuildSubmittedDateTime())
                .add("BotLocaleHistoryEvents", hasBotLocaleHistoryEvents() ? botLocaleHistoryEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "localeName":
            return Optional.ofNullable(clazz.cast(localeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        case "intentsCount":
            return Optional.ofNullable(clazz.cast(intentsCount()));
        case "slotTypesCount":
            return Optional.ofNullable(clazz.cast(slotTypesCount()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "lastBuildSubmittedDateTime":
            return Optional.ofNullable(clazz.cast(lastBuildSubmittedDateTime()));
        case "botLocaleHistoryEvents":
            return Optional.ofNullable(clazz.cast(botLocaleHistoryEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotLocaleResponse, T> g) {
        return obj -> g.apply((DescribeBotLocaleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBotLocaleResponse> {
        /**
         * <p>
         * The identifier of the bot associated with the locale.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the version of the bot associated with the locale.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the version of the bot associated with the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The unique identifier of the described locale.
         * </p>
         * 
         * @param localeId
         *        The unique identifier of the described locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The name of the locale.
         * </p>
         * 
         * @param localeName
         *        The name of the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeName(String localeName);

        /**
         * <p>
         * The description of the locale.
         * </p>
         * 
         * @param description
         *        The description of the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
         * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * </p>
         * 
         * @param nluIntentConfidenceThreshold
         *        The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
         *        <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
         * </p>
         * 
         * @param voiceSettings
         *        The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * <p>
         * The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
         * </p>
         * This is a convenience that creates an instance of the {@link VoiceSettings.Builder} avoiding the need to
         * create one manually via {@link VoiceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }

        /**
         * <p>
         * The number of intents defined for the locale.
         * </p>
         * 
         * @param intentsCount
         *        The number of intents defined for the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentsCount(Integer intentsCount);

        /**
         * <p>
         * The number of slot types defined for the locale.
         * </p>
         * 
         * @param slotTypesCount
         *        The number of slot types defined for the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypesCount(Integer slotTypesCount);

        /**
         * <p>
         * The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the
         * <code>failureReasons</code> field.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in
         *        the <code>failureReasons</code> field.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the
         * <code>failureReasons</code> field.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in
         *        the <code>failureReasons</code> field.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);

        /**
         * <p>
         * if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.
         * </p>
         * 
         * @param failureReasons
         *        if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the
         *        bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.
         * </p>
         * 
         * @param failureReasons
         *        if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the
         *        bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * The date and time that the locale was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the locale was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time that the locale was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the locale was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The date and time that the locale was last submitted for building.
         * </p>
         * 
         * @param lastBuildSubmittedDateTime
         *        The date and time that the locale was last submitted for building.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime);

        /**
         * <p>
         * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         * </p>
         * 
         * @param botLocaleHistoryEvents
         *        History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleHistoryEvents(Collection<BotLocaleHistoryEvent> botLocaleHistoryEvents);

        /**
         * <p>
         * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         * </p>
         * 
         * @param botLocaleHistoryEvents
         *        History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleHistoryEvents(BotLocaleHistoryEvent... botLocaleHistoryEvents);

        /**
         * <p>
         * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotLocaleHistoryEvent>.Builder} avoiding
         * the need to create one manually via {@link List<BotLocaleHistoryEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotLocaleHistoryEvent>.Builder#build()} is called
         * immediately and its result is passed to {@link #botLocaleHistoryEvents(List<BotLocaleHistoryEvent>)}.
         * 
         * @param botLocaleHistoryEvents
         *        a consumer that will call methods on {@link List<BotLocaleHistoryEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botLocaleHistoryEvents(List<BotLocaleHistoryEvent>)
         */
        Builder botLocaleHistoryEvents(Consumer<BotLocaleHistoryEvent.Builder>... botLocaleHistoryEvents);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String localeName;

        private String description;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private Integer intentsCount;

        private Integer slotTypesCount;

        private String botLocaleStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private Instant lastBuildSubmittedDateTime;

        private List<BotLocaleHistoryEvent> botLocaleHistoryEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotLocaleResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            localeName(model.localeName);
            description(model.description);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
            intentsCount(model.intentsCount);
            slotTypesCount(model.slotTypesCount);
            botLocaleStatus(model.botLocaleStatus);
            failureReasons(model.failureReasons);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            lastBuildSubmittedDateTime(model.lastBuildSubmittedDateTime);
            botLocaleHistoryEvents(model.botLocaleHistoryEvents);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getLocaleName() {
            return localeName;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        @Override
        @Transient
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        @Transient
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final Integer getIntentsCount() {
            return intentsCount;
        }

        public final void setIntentsCount(Integer intentsCount) {
            this.intentsCount = intentsCount;
        }

        @Override
        @Transient
        public final Builder intentsCount(Integer intentsCount) {
            this.intentsCount = intentsCount;
            return this;
        }

        public final Integer getSlotTypesCount() {
            return slotTypesCount;
        }

        public final void setSlotTypesCount(Integer slotTypesCount) {
            this.slotTypesCount = slotTypesCount;
        }

        @Override
        @Transient
        public final Builder slotTypesCount(Integer slotTypesCount) {
            this.slotTypesCount = slotTypesCount;
            return this;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        @Transient
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        @Transient
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Instant getLastBuildSubmittedDateTime() {
            return lastBuildSubmittedDateTime;
        }

        public final void setLastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
        }

        @Override
        @Transient
        public final Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
            return this;
        }

        public final List<BotLocaleHistoryEvent.Builder> getBotLocaleHistoryEvents() {
            List<BotLocaleHistoryEvent.Builder> result = BotLocaleHistoryEventsListCopier
                    .copyToBuilder(this.botLocaleHistoryEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotLocaleHistoryEvents(Collection<BotLocaleHistoryEvent.BuilderImpl> botLocaleHistoryEvents) {
            this.botLocaleHistoryEvents = BotLocaleHistoryEventsListCopier.copyFromBuilder(botLocaleHistoryEvents);
        }

        @Override
        @Transient
        public final Builder botLocaleHistoryEvents(Collection<BotLocaleHistoryEvent> botLocaleHistoryEvents) {
            this.botLocaleHistoryEvents = BotLocaleHistoryEventsListCopier.copy(botLocaleHistoryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botLocaleHistoryEvents(BotLocaleHistoryEvent... botLocaleHistoryEvents) {
            botLocaleHistoryEvents(Arrays.asList(botLocaleHistoryEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botLocaleHistoryEvents(Consumer<BotLocaleHistoryEvent.Builder>... botLocaleHistoryEvents) {
            botLocaleHistoryEvents(Stream.of(botLocaleHistoryEvents)
                    .map(c -> BotLocaleHistoryEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeBotLocaleResponse build() {
            return new DescribeBotLocaleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
