/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotAliasesResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotAliasesResponse.Builder, ListBotAliasesResponse> {
    private static final SdkField<List<BotAliasSummary>> BOT_ALIAS_SUMMARIES_FIELD = SdkField
            .<List<BotAliasSummary>> builder(MarshallingType.LIST)
            .memberName("botAliasSummaries")
            .getter(getter(ListBotAliasesResponse::botAliasSummaries))
            .setter(setter(Builder::botAliasSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotAliasSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotAliasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotAliasesResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD, BOT_ID_FIELD));

    private final List<BotAliasSummary> botAliasSummaries;

    private final String nextToken;

    private final String botId;

    private ListBotAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasSummaries = builder.botAliasSummaries;
        this.nextToken = builder.nextToken;
        this.botId = builder.botId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotAliasSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBotAliasSummaries() {
        return botAliasSummaries != null && !(botAliasSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available,
     * the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotAliasSummaries} method.
     * </p>
     * 
     * @return Summary information for the bot aliases that meet the filter criteria specified in the request. The
     *         length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
     *         more aliases available, the <code>nextToken</code> field contains a token to get the next page of
     *         results.
     */
    public final List<BotAliasSummary> botAliasSummaries() {
        return botAliasSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListBotAliases</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to
     *         get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the bot associated with the aliases.
     * </p>
     * 
     * @return The identifier of the bot associated with the aliases.
     */
    public final String botId() {
        return botId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasSummaries() ? botAliasSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotAliasesResponse)) {
            return false;
        }
        ListBotAliasesResponse other = (ListBotAliasesResponse) obj;
        return hasBotAliasSummaries() == other.hasBotAliasSummaries()
                && Objects.equals(botAliasSummaries(), other.botAliasSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(botId(), other.botId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotAliasesResponse")
                .add("BotAliasSummaries", hasBotAliasSummaries() ? botAliasSummaries() : null).add("NextToken", nextToken())
                .add("BotId", botId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasSummaries":
            return Optional.ofNullable(clazz.cast(botAliasSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotAliasesResponse, T> g) {
        return obj -> g.apply((ListBotAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotAliasesResponse> {
        /**
         * <p>
         * Summary information for the bot aliases that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botAliasSummaries
         *        Summary information for the bot aliases that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more aliases available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasSummaries(Collection<BotAliasSummary> botAliasSummaries);

        /**
         * <p>
         * Summary information for the bot aliases that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botAliasSummaries
         *        Summary information for the bot aliases that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more aliases available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasSummaries(BotAliasSummary... botAliasSummaries);

        /**
         * <p>
         * Summary information for the bot aliases that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotAliasSummary>.Builder} avoiding the need
         * to create one manually via {@link List<BotAliasSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotAliasSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #botAliasSummaries(List<BotAliasSummary>)}.
         * 
         * @param botAliasSummaries
         *        a consumer that will call methods on {@link List<BotAliasSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliasSummaries(List<BotAliasSummary>)
         */
        Builder botAliasSummaries(Consumer<BotAliasSummary.Builder>... botAliasSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents
         * as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the bot associated with the aliases.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<BotAliasSummary> botAliasSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String botId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotAliasesResponse model) {
            super(model);
            botAliasSummaries(model.botAliasSummaries);
            nextToken(model.nextToken);
            botId(model.botId);
        }

        public final List<BotAliasSummary.Builder> getBotAliasSummaries() {
            List<BotAliasSummary.Builder> result = BotAliasSummaryListCopier.copyToBuilder(this.botAliasSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotAliasSummaries(Collection<BotAliasSummary.BuilderImpl> botAliasSummaries) {
            this.botAliasSummaries = BotAliasSummaryListCopier.copyFromBuilder(botAliasSummaries);
        }

        @Override
        @Transient
        public final Builder botAliasSummaries(Collection<BotAliasSummary> botAliasSummaries) {
            this.botAliasSummaries = BotAliasSummaryListCopier.copy(botAliasSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botAliasSummaries(BotAliasSummary... botAliasSummaries) {
            botAliasSummaries(Arrays.asList(botAliasSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botAliasSummaries(Consumer<BotAliasSummary.Builder>... botAliasSummaries) {
            botAliasSummaries(Stream.of(botAliasSummaries).map(c -> BotAliasSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        @Override
        public ListBotAliasesResponse build() {
            return new ListBotAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
