/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterancesListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotValueElicitationSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotValueElicitationSetting> {
    private static final SdkField<SlotDefaultValueSpecification> DEFAULT_VALUE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValueSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::defaultValueSpecification)).setter(SlotValueElicitationSetting.setter(Builder::defaultValueSpecification)).constructor(SlotDefaultValueSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueSpecification").build()}).build();
    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotConstraint").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::slotConstraintAsString)).setter(SlotValueElicitationSetting.setter(Builder::slotConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()}).build();
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::promptSpecification)).setter(SlotValueElicitationSetting.setter(Builder::promptSpecification)).constructor(PromptSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build()}).build();
    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::sampleUtterances)).setter(SlotValueElicitationSetting.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleUtterance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WaitAndContinueSpecification> WAIT_AND_CONTINUE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("waitAndContinueSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::waitAndContinueSpecification)).setter(SlotValueElicitationSetting.setter(Builder::waitAndContinueSpecification)).constructor(WaitAndContinueSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitAndContinueSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_SPECIFICATION_FIELD, SLOT_CONSTRAINT_FIELD, PROMPT_SPECIFICATION_FIELD, SAMPLE_UTTERANCES_FIELD, WAIT_AND_CONTINUE_SPECIFICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final SlotDefaultValueSpecification defaultValueSpecification;
    private final String slotConstraint;
    private final PromptSpecification promptSpecification;
    private final List<SampleUtterance> sampleUtterances;
    private final WaitAndContinueSpecification waitAndContinueSpecification;

    private SlotValueElicitationSetting(BuilderImpl builder) {
        this.defaultValueSpecification = builder.defaultValueSpecification;
        this.slotConstraint = builder.slotConstraint;
        this.promptSpecification = builder.promptSpecification;
        this.sampleUtterances = builder.sampleUtterances;
        this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
    }

    public final SlotDefaultValueSpecification defaultValueSpecification() {
        return this.defaultValueSpecification;
    }

    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(this.slotConstraint);
    }

    public final String slotConstraintAsString() {
        return this.slotConstraint;
    }

    public final PromptSpecification promptSpecification() {
        return this.promptSpecification;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<SampleUtterance> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final WaitAndContinueSpecification waitAndContinueSpecification() {
        return this.waitAndContinueSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waitAndContinueSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueElicitationSetting)) {
            return false;
        }
        SlotValueElicitationSetting other = (SlotValueElicitationSetting)obj;
        return Objects.equals(this.defaultValueSpecification(), other.defaultValueSpecification()) && Objects.equals(this.slotConstraintAsString(), other.slotConstraintAsString()) && Objects.equals(this.promptSpecification(), other.promptSpecification()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.waitAndContinueSpecification(), other.waitAndContinueSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"SlotValueElicitationSetting").add("DefaultValueSpecification", (Object)this.defaultValueSpecification()).add("SlotConstraint", (Object)this.slotConstraintAsString()).add("PromptSpecification", (Object)this.promptSpecification()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("WaitAndContinueSpecification", (Object)this.waitAndContinueSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultValueSpecification": {
                return Optional.ofNullable(clazz.cast(this.defaultValueSpecification()));
            }
            case "slotConstraint": {
                return Optional.ofNullable(clazz.cast(this.slotConstraintAsString()));
            }
            case "promptSpecification": {
                return Optional.ofNullable(clazz.cast(this.promptSpecification()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "waitAndContinueSpecification": {
                return Optional.ofNullable(clazz.cast(this.waitAndContinueSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotValueElicitationSetting, T> g) {
        return obj -> g.apply((SlotValueElicitationSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SlotDefaultValueSpecification defaultValueSpecification;
        private String slotConstraint;
        private PromptSpecification promptSpecification;
        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private WaitAndContinueSpecification waitAndContinueSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueElicitationSetting model) {
            this.defaultValueSpecification(model.defaultValueSpecification);
            this.slotConstraint(model.slotConstraint);
            this.promptSpecification(model.promptSpecification);
            this.sampleUtterances(model.sampleUtterances);
            this.waitAndContinueSpecification(model.waitAndContinueSpecification);
        }

        public final SlotDefaultValueSpecification.Builder getDefaultValueSpecification() {
            return this.defaultValueSpecification != null ? this.defaultValueSpecification.toBuilder() : null;
        }

        public final void setDefaultValueSpecification(SlotDefaultValueSpecification.BuilderImpl defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification != null ? defaultValueSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification;
            return this;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        @Transient
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        @Transient
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return this.promptSpecification != null ? this.promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        @Transient
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... sampleUtterances) {
            this.sampleUtterances(Stream.of(sampleUtterances).map(c -> (SampleUtterance)((SampleUtterance.Builder)SampleUtterance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WaitAndContinueSpecification.Builder getWaitAndContinueSpecification() {
            return this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.toBuilder() : null;
        }

        public final void setWaitAndContinueSpecification(WaitAndContinueSpecification.BuilderImpl waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification != null ? waitAndContinueSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification;
            return this;
        }

        public SlotValueElicitationSetting build() {
            return new SlotValueElicitationSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotValueElicitationSetting> {
        public Builder defaultValueSpecification(SlotDefaultValueSpecification var1);

        default public Builder defaultValueSpecification(Consumer<SlotDefaultValueSpecification.Builder> defaultValueSpecification) {
            return this.defaultValueSpecification((SlotDefaultValueSpecification)((SlotDefaultValueSpecification.Builder)SlotDefaultValueSpecification.builder().applyMutation(defaultValueSpecification)).build());
        }

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder promptSpecification(PromptSpecification var1);

        default public Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return this.promptSpecification((PromptSpecification)((PromptSpecification.Builder)PromptSpecification.builder().applyMutation(promptSpecification)).build());
        }

        public Builder sampleUtterances(Collection<SampleUtterance> var1);

        public Builder sampleUtterances(SampleUtterance ... var1);

        public Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... var1);

        public Builder waitAndContinueSpecification(WaitAndContinueSpecification var1);

        default public Builder waitAndContinueSpecification(Consumer<WaitAndContinueSpecification.Builder> waitAndContinueSpecification) {
            return this.waitAndContinueSpecification((WaitAndContinueSpecification)((WaitAndContinueSpecification.Builder)WaitAndContinueSpecification.builder().applyMutation(waitAndContinueSpecification)).build());
        }
    }
}

