/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about bot aliases returned from the <a>ListBotAliases</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotAliasSummary implements SdkPojo, Serializable, ToCopyableBuilder<BotAliasSummary.Builder, BotAliasSummary> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(BotAliasSummary::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasName").getter(getter(BotAliasSummary::botAliasName)).setter(setter(Builder::botAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BotAliasSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BotAliasSummary::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> BOT_ALIAS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasStatus").getter(getter(BotAliasSummary::botAliasStatusAsString))
            .setter(setter(Builder::botAliasStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BotAliasSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BotAliasSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_STATUS_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botAliasId;

    private final String botAliasName;

    private final String description;

    private final String botVersion;

    private final String botAliasStatus;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private BotAliasSummary(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasStatus = builder.botAliasStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier assigned to the bot alias. You can use this ID to get detailed information about the alias
     * using the <a>DescribeBotAlias</a> operation.
     * </p>
     * 
     * @return The unique identifier assigned to the bot alias. You can use this ID to get detailed information about
     *         the alias using the <a>DescribeBotAlias</a> operation.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public final String botAliasName() {
        return botAliasName;
    }

    /**
     * <p>
     * The description of the bot alias.
     * </p>
     * 
     * @return The description of the bot alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot that the bot alias references.
     * </p>
     * 
     * @return The version of the bot that the bot alias references.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
     * @see BotAliasStatus
     */
    public final BotAliasStatus botAliasStatus() {
        return BotAliasStatus.fromValue(botAliasStatus);
    }

    /**
     * <p>
     * The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
     * @see BotAliasStatus
     */
    public final String botAliasStatusAsString() {
        return botAliasStatus;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot alias was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot alias was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot alias was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot alias was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasSummary)) {
            return false;
        }
        BotAliasSummary other = (BotAliasSummary) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botAliasName(), other.botAliasName())
                && Objects.equals(description(), other.description()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(botAliasStatusAsString(), other.botAliasStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotAliasSummary").add("BotAliasId", botAliasId()).add("BotAliasName", botAliasName())
                .add("Description", description()).add("BotVersion", botVersion())
                .add("BotAliasStatus", botAliasStatusAsString()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botAliasName":
            return Optional.ofNullable(clazz.cast(botAliasName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botAliasStatus":
            return Optional.ofNullable(clazz.cast(botAliasStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotAliasSummary, T> g) {
        return obj -> g.apply((BotAliasSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotAliasSummary> {
        /**
         * <p>
         * The unique identifier assigned to the bot alias. You can use this ID to get detailed information about the
         * alias using the <a>DescribeBotAlias</a> operation.
         * </p>
         * 
         * @param botAliasId
         *        The unique identifier assigned to the bot alias. You can use this ID to get detailed information about
         *        the alias using the <a>DescribeBotAlias</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param botAliasName
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasName(String botAliasName);

        /**
         * <p>
         * The description of the bot alias.
         * </p>
         * 
         * @param description
         *        The description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot that the bot alias references.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that the bot alias references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
         * </p>
         * 
         * @param botAliasStatus
         *        The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for
         *        use.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(String botAliasStatus);

        /**
         * <p>
         * The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.
         * </p>
         * 
         * @param botAliasStatus
         *        The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for
         *        use.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(BotAliasStatus botAliasStatus);

        /**
         * <p>
         * A timestamp of the date and time that the bot alias was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the bot alias was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the bot alias was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String botAliasId;

        private String botAliasName;

        private String description;

        private String botVersion;

        private String botAliasStatus;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasSummary model) {
            botAliasId(model.botAliasId);
            botAliasName(model.botAliasName);
            description(model.description);
            botVersion(model.botVersion);
            botAliasStatus(model.botAliasStatus);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        @Transient
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasName() {
            return botAliasName;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        @Override
        @Transient
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getBotAliasStatus() {
            return botAliasStatus;
        }

        public final void setBotAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
        }

        @Override
        @Transient
        public final Builder botAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder botAliasStatus(BotAliasStatus botAliasStatus) {
            this.botAliasStatus(botAliasStatus == null ? null : botAliasStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public BotAliasSummary build() {
            return new BotAliasSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
