/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeImportResponse.Builder, DescribeImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(DescribeImportResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ImportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(DescribeImportResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ImportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> IMPORTED_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedResourceId").getter(getter(DescribeImportResponse::importedResourceId))
            .setter(setter(Builder::importedResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceId").build())
            .build();

    private static final SdkField<String> IMPORTED_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedResourceName").getter(getter(DescribeImportResponse::importedResourceName))
            .setter(setter(Builder::importedResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceName").build())
            .build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(DescribeImportResponse::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(DescribeImportResponse::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeImportResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeImportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeImportResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, IMPORTED_RESOURCE_ID_FIELD, IMPORTED_RESOURCE_NAME_FIELD, MERGE_STRATEGY_FIELD,
            IMPORT_STATUS_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private final String importId;

    private final ImportResourceSpecification resourceSpecification;

    private final String importedResourceId;

    private final String importedResourceName;

    private final String mergeStrategy;

    private final String importStatus;

    private final List<String> failureReasons;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.importedResourceId = builder.importedResourceId;
        this.importedResourceName = builder.importedResourceName;
        this.mergeStrategy = builder.mergeStrategy;
        this.importStatus = builder.importStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the described import.
     * </p>
     * 
     * @return The unique identifier of the described import.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * The specifications of the imported bot or bot locale.
     * </p>
     * 
     * @return The specifications of the imported bot or bot locale.
     */
    public final ImportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The unique identifier that Amazon Lex assigned to the resource created by the import.
     * </p>
     * 
     * @return The unique identifier that Amazon Lex assigned to the resource created by the import.
     */
    public final String importedResourceId() {
        return importedResourceId;
    }

    /**
     * <p>
     * The name of the imported resource.
     * </p>
     * 
     * @return The name of the imported resource.
     */
    public final String importedResourceName() {
        return importedResourceName;
    }

    /**
     * <p>
     * The strategy used when there was a name conflict between the imported resource and an existing resource. When the
     * merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when there was a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The strategy used when there was a name conflict between the imported resource and an existing resource. When the
     * merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when there was a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The status of the import process. When the status is <code>Completed</code> the resource is imported and ready
     * for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import process. When the status is <code>Completed</code> the resource is imported and
     *         ready for use.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import process. When the status is <code>Completed</code> the resource is imported and ready
     * for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import process. When the status is <code>Completed</code> the resource is imported and
     *         ready for use.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the
     * failture.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the
     *         failture.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * The date and time that the import was created.
     * </p>
     * 
     * @return The date and time that the import was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time that the import was last updated.
     * </p>
     * 
     * @return The date and time that the import was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(importedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(importedResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportResponse)) {
            return false;
        }
        DescribeImportResponse other = (DescribeImportResponse) obj;
        return Objects.equals(importId(), other.importId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(importedResourceId(), other.importedResourceId())
                && Objects.equals(importedResourceName(), other.importedResourceName())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImportResponse").add("ImportId", importId())
                .add("ResourceSpecification", resourceSpecification()).add("ImportedResourceId", importedResourceId())
                .add("ImportedResourceName", importedResourceName()).add("MergeStrategy", mergeStrategyAsString())
                .add("ImportStatus", importStatusAsString()).add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "importedResourceId":
            return Optional.ofNullable(clazz.cast(importedResourceId()));
        case "importedResourceName":
            return Optional.ofNullable(clazz.cast(importedResourceName()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportResponse, T> g) {
        return obj -> g.apply((DescribeImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImportResponse> {
        /**
         * <p>
         * The unique identifier of the described import.
         * </p>
         * 
         * @param importId
         *        The unique identifier of the described import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The specifications of the imported bot or bot locale.
         * </p>
         * 
         * @param resourceSpecification
         *        The specifications of the imported bot or bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ImportResourceSpecification resourceSpecification);

        /**
         * <p>
         * The specifications of the imported bot or bot locale.
         * </p>
         * This is a convenience that creates an instance of the {@link ImportResourceSpecification.Builder} avoiding
         * the need to create one manually via {@link ImportResourceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ImportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ImportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ImportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ImportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The unique identifier that Amazon Lex assigned to the resource created by the import.
         * </p>
         * 
         * @param importedResourceId
         *        The unique identifier that Amazon Lex assigned to the resource created by the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedResourceId(String importedResourceId);

        /**
         * <p>
         * The name of the imported resource.
         * </p>
         * 
         * @param importedResourceName
         *        The name of the imported resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedResourceName(String importedResourceName);

        /**
         * <p>
         * The strategy used when there was a name conflict between the imported resource and an existing resource. When
         * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used when there was a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The strategy used when there was a name conflict between the imported resource and an existing resource. When
         * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used when there was a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The status of the import process. When the status is <code>Completed</code> the resource is imported and
         * ready for use.
         * </p>
         * 
         * @param importStatus
         *        The status of the import process. When the status is <code>Completed</code> the resource is imported
         *        and ready for use.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import process. When the status is <code>Completed</code> the resource is imported and
         * ready for use.
         * </p>
         * 
         * @param importStatus
         *        The status of the import process. When the status is <code>Completed</code> the resource is imported
         *        and ready for use.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the
         * failture.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for
         *        the failture.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the
         * failture.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for
         *        the failture.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * The date and time that the import was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the import was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time that the import was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the import was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String importId;

        private ImportResourceSpecification resourceSpecification;

        private String importedResourceId;

        private String importedResourceName;

        private String mergeStrategy;

        private String importStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportResponse model) {
            super(model);
            importId(model.importId);
            resourceSpecification(model.resourceSpecification);
            importedResourceId(model.importedResourceId);
            importedResourceName(model.importedResourceName);
            mergeStrategy(model.mergeStrategy);
            importStatus(model.importStatus);
            failureReasons(model.failureReasons);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        @Transient
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getImportedResourceId() {
            return importedResourceId;
        }

        public final void setImportedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
        }

        @Override
        @Transient
        public final Builder importedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
            return this;
        }

        public final String getImportedResourceName() {
            return importedResourceName;
        }

        public final void setImportedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
        }

        @Override
        @Transient
        public final Builder importedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
            return this;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        @Transient
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        @Transient
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        @Transient
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeImportResponse build() {
            return new DescribeImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
