/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Lambda function that verifies requests to a bot or fulfilles the user's request to a bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaCodeHook implements SdkPojo, Serializable, ToCopyableBuilder<LambdaCodeHook.Builder, LambdaCodeHook> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaARN").getter(getter(LambdaCodeHook::lambdaARN)).setter(setter(Builder::lambdaARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaARN").build()).build();

    private static final SdkField<String> CODE_HOOK_INTERFACE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeHookInterfaceVersion").getter(getter(LambdaCodeHook::codeHookInterfaceVersion))
            .setter(setter(Builder::codeHookInterfaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHookInterfaceVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD,
            CODE_HOOK_INTERFACE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lambdaARN;

    private final String codeHookInterfaceVersion;

    private LambdaCodeHook(BuilderImpl builder) {
        this.lambdaARN = builder.lambdaARN;
        this.codeHookInterfaceVersion = builder.codeHookInterfaceVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public final String lambdaARN() {
        return lambdaARN;
    }

    /**
     * <p>
     * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
     * </p>
     * 
     * @return The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
     */
    public final String codeHookInterfaceVersion() {
        return codeHookInterfaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(codeHookInterfaceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaCodeHook)) {
            return false;
        }
        LambdaCodeHook other = (LambdaCodeHook) obj;
        return Objects.equals(lambdaARN(), other.lambdaARN())
                && Objects.equals(codeHookInterfaceVersion(), other.codeHookInterfaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaCodeHook").add("LambdaARN", lambdaARN())
                .add("CodeHookInterfaceVersion", codeHookInterfaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaARN":
            return Optional.ofNullable(clazz.cast(lambdaARN()));
        case "codeHookInterfaceVersion":
            return Optional.ofNullable(clazz.cast(codeHookInterfaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaCodeHook, T> g) {
        return obj -> g.apply((LambdaCodeHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaCodeHook> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param lambdaARN
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaARN(String lambdaARN);

        /**
         * <p>
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         * </p>
         * 
         * @param codeHookInterfaceVersion
         *        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHookInterfaceVersion(String codeHookInterfaceVersion);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaARN;

        private String codeHookInterfaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaCodeHook model) {
            lambdaARN(model.lambdaARN);
            codeHookInterfaceVersion(model.codeHookInterfaceVersion);
        }

        public final String getLambdaARN() {
            return lambdaARN;
        }

        public final void setLambdaARN(String lambdaARN) {
            this.lambdaARN = lambdaARN;
        }

        @Override
        @Transient
        public final Builder lambdaARN(String lambdaARN) {
            this.lambdaARN = lambdaARN;
            return this;
        }

        public final String getCodeHookInterfaceVersion() {
            return codeHookInterfaceVersion;
        }

        public final void setCodeHookInterfaceVersion(String codeHookInterfaceVersion) {
            this.codeHookInterfaceVersion = codeHookInterfaceVersion;
        }

        @Override
        @Transient
        public final Builder codeHookInterfaceVersion(String codeHookInterfaceVersion) {
            this.codeHookInterfaceVersion = codeHookInterfaceVersion;
            return this;
        }

        @Override
        public LambdaCodeHook build() {
            return new LambdaCodeHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
