/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExportRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateExportRequest.Builder, CreateExportRequest> {
    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ExportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(CreateExportRequest::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ExportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(CreateExportRequest::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePassword").getter(getter(CreateExportRequest::filePassword)).setter(setter(Builder::filePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SPECIFICATION_FIELD,
            FILE_FORMAT_FIELD, FILE_PASSWORD_FIELD));

    private final ExportResourceSpecification resourceSpecification;

    private final String fileFormat;

    private final String filePassword;

    private CreateExportRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.filePassword = builder.filePassword;
    }

    /**
     * <p>
     * Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource
     * to export.
     * </p>
     * 
     * @return Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of
     *         resource to export.
     */
    public final ExportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The file format of the bot or bot locale definition files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format of the bot or bot locale definition files.
     * @see ImportExportFileFormat
     */
    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The file format of the bot or bot locale definition files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format of the bot or bot locale definition files.
     * @see ImportExportFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the
     * archive to protect the data in transit between Amazon Lex and your local computer.
     * </p>
     * 
     * @return An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt
     *         the archive to protect the data in transit between Amazon Lex and your local computer.
     */
    public final String filePassword() {
        return filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportRequest)) {
            return false;
        }
        CreateExportRequest other = (CreateExportRequest) obj;
        return Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(filePassword(), other.filePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExportRequest").add("ResourceSpecification", resourceSpecification())
                .add("FileFormat", fileFormatAsString())
                .add("FilePassword", filePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "filePassword":
            return Optional.ofNullable(clazz.cast(filePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExportRequest, T> g) {
        return obj -> g.apply((CreateExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateExportRequest> {
        /**
         * <p>
         * Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of
         * resource to export.
         * </p>
         * 
         * @param resourceSpecification
         *        Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type
         *        of resource to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ExportResourceSpecification resourceSpecification);

        /**
         * <p>
         * Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of
         * resource to export.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportResourceSpecification.Builder} avoiding
         * the need to create one manually via {@link ExportResourceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ExportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ExportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ExportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ExportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The file format of the bot or bot locale definition files.
         * </p>
         * 
         * @param fileFormat
         *        The file format of the bot or bot locale definition files.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The file format of the bot or bot locale definition files.
         * </p>
         * 
         * @param fileFormat
         *        The file format of the bot or bot locale definition files.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(ImportExportFileFormat fileFormat);

        /**
         * <p>
         * An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the
         * archive to protect the data in transit between Amazon Lex and your local computer.
         * </p>
         * 
         * @param filePassword
         *        An password to use to encrypt the exported archive. Using a password is optional, but you should
         *        encrypt the archive to protect the data in transit between Amazon Lex and your local computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePassword(String filePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private ExportResourceSpecification resourceSpecification;

        private String fileFormat;

        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportRequest model) {
            super(model);
            resourceSpecification(model.resourceSpecification);
            fileFormat(model.fileFormat);
            filePassword(model.filePassword);
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Transient
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getFilePassword() {
            return filePassword;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        @Transient
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportRequest build() {
            return new CreateExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
