/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;

public class ListImportsIterable
implements SdkIterable<ListImportsResponse> {
    private final LexModelsV2Client client;
    private final ListImportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportsIterable(LexModelsV2Client client, ListImportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public Iterator<ListImportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImportsResponseFetcher
    implements SyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportsResponse nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsIterable.this.client.listImports(ListImportsIterable.this.firstRequest);
            }
            return ListImportsIterable.this.client.listImports((ListImportsRequest)((Object)ListImportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

