/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSlotTypeResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateSlotTypeResponse.Builder, CreateSlotTypeResponse> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(CreateSlotTypeResponse::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeName").getter(getter(CreateSlotTypeResponse::slotTypeName))
            .setter(setter(Builder::slotTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSlotTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SlotTypeValue>> SLOT_TYPE_VALUES_FIELD = SdkField
            .<List<SlotTypeValue>> builder(MarshallingType.LIST)
            .memberName("slotTypeValues")
            .getter(getter(CreateSlotTypeResponse::slotTypeValues))
            .setter(setter(Builder::slotTypeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SlotValueSelectionSetting> VALUE_SELECTION_SETTING_FIELD = SdkField
            .<SlotValueSelectionSetting> builder(MarshallingType.SDK_POJO).memberName("valueSelectionSetting")
            .getter(getter(CreateSlotTypeResponse::valueSelectionSetting)).setter(setter(Builder::valueSelectionSetting))
            .constructor(SlotValueSelectionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionSetting").build())
            .build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(CreateSlotTypeResponse::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateSlotTypeResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateSlotTypeResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateSlotTypeResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateSlotTypeResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD,
            SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_VALUES_FIELD, VALUE_SELECTION_SETTING_FIELD,
            PARENT_SLOT_TYPE_SIGNATURE_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, CREATION_DATE_TIME_FIELD));

    private final String slotTypeId;

    private final String slotTypeName;

    private final String description;

    private final List<SlotTypeValue> slotTypeValues;

    private final SlotValueSelectionSetting valueSelectionSetting;

    private final String parentSlotTypeSignature;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Instant creationDateTime;

    private CreateSlotTypeResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.slotTypeValues = builder.slotTypeValues;
        this.valueSelectionSetting = builder.valueSelectionSetting;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The unique identifier assigned to the slot type. Use this to identify the slot type in the
     * <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.
     * </p>
     * 
     * @return The unique identifier assigned to the slot type. Use this to identify the slot type in the
     *         <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * The name specified for the slot type.
     * </p>
     * 
     * @return The name specified for the slot type.
     */
    public final String slotTypeName() {
        return slotTypeName;
    }

    /**
     * <p>
     * The description specified for the slot type.
     * </p>
     * 
     * @return The description specified for the slot type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotTypeValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlotTypeValues() {
        return slotTypeValues != null && !(slotTypeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values that the slot type can assume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotTypeValues} method.
     * </p>
     * 
     * @return The list of values that the slot type can assume.
     */
    public final List<SlotTypeValue> slotTypeValues() {
        return slotTypeValues;
    }

    /**
     * <p>
     * The strategy that Amazon Lex uses to select a value from the list of possible values.
     * </p>
     * 
     * @return The strategy that Amazon Lex uses to select a value from the list of possible values.
     */
    public final SlotValueSelectionSetting valueSelectionSetting() {
        return valueSelectionSetting;
    }

    /**
     * <p>
     * The signature of the base slot type specified for the slot type.
     * </p>
     * 
     * @return The signature of the base slot type specified for the slot type.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * <p>
     * The identifier for the bot associated with the slot type.
     * </p>
     * 
     * @return The identifier for the bot associated with the slot type.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the slot type.
     * </p>
     * 
     * @return The version of the bot associated with the slot type.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The specified language and local specified for the slot type.
     * </p>
     * 
     * @return The specified language and local specified for the slot type.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the slot type was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the slot type was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeValues() ? slotTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlotTypeResponse)) {
            return false;
        }
        CreateSlotTypeResponse other = (CreateSlotTypeResponse) obj;
        return Objects.equals(slotTypeId(), other.slotTypeId()) && Objects.equals(slotTypeName(), other.slotTypeName())
                && Objects.equals(description(), other.description()) && hasSlotTypeValues() == other.hasSlotTypeValues()
                && Objects.equals(slotTypeValues(), other.slotTypeValues())
                && Objects.equals(valueSelectionSetting(), other.valueSelectionSetting())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSlotTypeResponse").add("SlotTypeId", slotTypeId()).add("SlotTypeName", slotTypeName())
                .add("Description", description()).add("SlotTypeValues", hasSlotTypeValues() ? slotTypeValues() : null)
                .add("ValueSelectionSetting", valueSelectionSetting()).add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId())
                .add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "slotTypeName":
            return Optional.ofNullable(clazz.cast(slotTypeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeValues":
            return Optional.ofNullable(clazz.cast(slotTypeValues()));
        case "valueSelectionSetting":
            return Optional.ofNullable(clazz.cast(valueSelectionSetting()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSlotTypeResponse, T> g) {
        return obj -> g.apply((CreateSlotTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSlotTypeResponse> {
        /**
         * <p>
         * The unique identifier assigned to the slot type. Use this to identify the slot type in the
         * <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier assigned to the slot type. Use this to identify the slot type in the
         *        <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * The name specified for the slot type.
         * </p>
         * 
         * @param slotTypeName
         *        The name specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeName(String slotTypeName);

        /**
         * <p>
         * The description specified for the slot type.
         * </p>
         * 
         * @param description
         *        The description specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of values that the slot type can assume.
         * </p>
         * 
         * @param slotTypeValues
         *        The list of values that the slot type can assume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues);

        /**
         * <p>
         * The list of values that the slot type can assume.
         * </p>
         * 
         * @param slotTypeValues
         *        The list of values that the slot type can assume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(SlotTypeValue... slotTypeValues);

        /**
         * <p>
         * The list of values that the slot type can assume.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeValue>.Builder} avoiding the need
         * to create one manually via {@link List<SlotTypeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #slotTypeValues(List<SlotTypeValue>)}.
         * 
         * @param slotTypeValues
         *        a consumer that will call methods on {@link List<SlotTypeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeValues(List<SlotTypeValue>)
         */
        Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues);

        /**
         * <p>
         * The strategy that Amazon Lex uses to select a value from the list of possible values.
         * </p>
         * 
         * @param valueSelectionSetting
         *        The strategy that Amazon Lex uses to select a value from the list of possible values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting);

        /**
         * <p>
         * The strategy that Amazon Lex uses to select a value from the list of possible values.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotValueSelectionSetting.Builder} avoiding the
         * need to create one manually via {@link SlotValueSelectionSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotValueSelectionSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #valueSelectionSetting(SlotValueSelectionSetting)}.
         * 
         * @param valueSelectionSetting
         *        a consumer that will call methods on {@link SlotValueSelectionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueSelectionSetting(SlotValueSelectionSetting)
         */
        default Builder valueSelectionSetting(Consumer<SlotValueSelectionSetting.Builder> valueSelectionSetting) {
            return valueSelectionSetting(SlotValueSelectionSetting.builder().applyMutation(valueSelectionSetting).build());
        }

        /**
         * <p>
         * The signature of the base slot type specified for the slot type.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The signature of the base slot type specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * The identifier for the bot associated with the slot type.
         * </p>
         * 
         * @param botId
         *        The identifier for the bot associated with the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the slot type.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The specified language and local specified for the slot type.
         * </p>
         * 
         * @param localeId
         *        The specified language and local specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A timestamp of the date and time that the slot type was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the slot type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String slotTypeId;

        private String slotTypeName;

        private String description;

        private List<SlotTypeValue> slotTypeValues = DefaultSdkAutoConstructList.getInstance();

        private SlotValueSelectionSetting valueSelectionSetting;

        private String parentSlotTypeSignature;

        private String botId;

        private String botVersion;

        private String localeId;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlotTypeResponse model) {
            super(model);
            slotTypeId(model.slotTypeId);
            slotTypeName(model.slotTypeName);
            description(model.description);
            slotTypeValues(model.slotTypeValues);
            valueSelectionSetting(model.valueSelectionSetting);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            creationDateTime(model.creationDateTime);
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        @Transient
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final String getSlotTypeName() {
            return slotTypeName;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        @Override
        @Transient
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SlotTypeValue.Builder> getSlotTypeValues() {
            List<SlotTypeValue.Builder> result = SlotTypeValuesCopier.copyToBuilder(this.slotTypeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypeValues(Collection<SlotTypeValue.BuilderImpl> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copyFromBuilder(slotTypeValues);
        }

        @Override
        @Transient
        public final Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copy(slotTypeValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slotTypeValues(SlotTypeValue... slotTypeValues) {
            slotTypeValues(Arrays.asList(slotTypeValues));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues) {
            slotTypeValues(Stream.of(slotTypeValues).map(c -> SlotTypeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SlotValueSelectionSetting.Builder getValueSelectionSetting() {
            return valueSelectionSetting != null ? valueSelectionSetting.toBuilder() : null;
        }

        public final void setValueSelectionSetting(SlotValueSelectionSetting.BuilderImpl valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting != null ? valueSelectionSetting.build() : null;
        }

        @Override
        @Transient
        public final Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        @Transient
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public CreateSlotTypeResponse build() {
            return new CreateSlotTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
