/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a setting that determines whether the post-fulfillment response is sent to the user. For more information,
 * see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete">https://docs.aws.
 * amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostFulfillmentStatusSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PostFulfillmentStatusSpecification.Builder, PostFulfillmentStatusSpecification> {
    private static final SdkField<ResponseSpecification> SUCCESS_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("successResponse")
            .getter(getter(PostFulfillmentStatusSpecification::successResponse)).setter(setter(Builder::successResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successResponse").build()).build();

    private static final SdkField<ResponseSpecification> FAILURE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("failureResponse")
            .getter(getter(PostFulfillmentStatusSpecification::failureResponse)).setter(setter(Builder::failureResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResponse").build()).build();

    private static final SdkField<ResponseSpecification> TIMEOUT_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("timeoutResponse")
            .getter(getter(PostFulfillmentStatusSpecification::timeoutResponse)).setter(setter(Builder::timeoutResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_RESPONSE_FIELD,
            FAILURE_RESPONSE_FIELD, TIMEOUT_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification successResponse;

    private final ResponseSpecification failureResponse;

    private final ResponseSpecification timeoutResponse;

    private PostFulfillmentStatusSpecification(BuilderImpl builder) {
        this.successResponse = builder.successResponse;
        this.failureResponse = builder.failureResponse;
        this.timeoutResponse = builder.timeoutResponse;
    }

    /**
     * Returns the value of the SuccessResponse property for this object.
     * 
     * @return The value of the SuccessResponse property for this object.
     */
    public final ResponseSpecification successResponse() {
        return successResponse;
    }

    /**
     * Returns the value of the FailureResponse property for this object.
     * 
     * @return The value of the FailureResponse property for this object.
     */
    public final ResponseSpecification failureResponse() {
        return failureResponse;
    }

    /**
     * Returns the value of the TimeoutResponse property for this object.
     * 
     * @return The value of the TimeoutResponse property for this object.
     */
    public final ResponseSpecification timeoutResponse() {
        return timeoutResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successResponse());
        hashCode = 31 * hashCode + Objects.hashCode(failureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostFulfillmentStatusSpecification)) {
            return false;
        }
        PostFulfillmentStatusSpecification other = (PostFulfillmentStatusSpecification) obj;
        return Objects.equals(successResponse(), other.successResponse())
                && Objects.equals(failureResponse(), other.failureResponse())
                && Objects.equals(timeoutResponse(), other.timeoutResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostFulfillmentStatusSpecification").add("SuccessResponse", successResponse())
                .add("FailureResponse", failureResponse()).add("TimeoutResponse", timeoutResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successResponse":
            return Optional.ofNullable(clazz.cast(successResponse()));
        case "failureResponse":
            return Optional.ofNullable(clazz.cast(failureResponse()));
        case "timeoutResponse":
            return Optional.ofNullable(clazz.cast(timeoutResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostFulfillmentStatusSpecification, T> g) {
        return obj -> g.apply((PostFulfillmentStatusSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostFulfillmentStatusSpecification> {
        /**
         * Sets the value of the SuccessResponse property for this object.
         *
         * @param successResponse
         *        The new value for the SuccessResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successResponse(ResponseSpecification successResponse);

        /**
         * Sets the value of the SuccessResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResponseSpecification.Builder} avoiding the need
         * to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #successResponse(ResponseSpecification)}.
         * 
         * @param successResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successResponse(ResponseSpecification)
         */
        default Builder successResponse(Consumer<ResponseSpecification.Builder> successResponse) {
            return successResponse(ResponseSpecification.builder().applyMutation(successResponse).build());
        }

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * @param failureResponse
         *        The new value for the FailureResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResponse(ResponseSpecification failureResponse);

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResponseSpecification.Builder} avoiding the need
         * to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #failureResponse(ResponseSpecification)}.
         * 
         * @param failureResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureResponse(ResponseSpecification)
         */
        default Builder failureResponse(Consumer<ResponseSpecification.Builder> failureResponse) {
            return failureResponse(ResponseSpecification.builder().applyMutation(failureResponse).build());
        }

        /**
         * Sets the value of the TimeoutResponse property for this object.
         *
         * @param timeoutResponse
         *        The new value for the TimeoutResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutResponse(ResponseSpecification timeoutResponse);

        /**
         * Sets the value of the TimeoutResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResponseSpecification.Builder} avoiding the need
         * to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #timeoutResponse(ResponseSpecification)}.
         * 
         * @param timeoutResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutResponse(ResponseSpecification)
         */
        default Builder timeoutResponse(Consumer<ResponseSpecification.Builder> timeoutResponse) {
            return timeoutResponse(ResponseSpecification.builder().applyMutation(timeoutResponse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification successResponse;

        private ResponseSpecification failureResponse;

        private ResponseSpecification timeoutResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PostFulfillmentStatusSpecification model) {
            successResponse(model.successResponse);
            failureResponse(model.failureResponse);
            timeoutResponse(model.timeoutResponse);
        }

        public final ResponseSpecification.Builder getSuccessResponse() {
            return successResponse != null ? successResponse.toBuilder() : null;
        }

        public final void setSuccessResponse(ResponseSpecification.BuilderImpl successResponse) {
            this.successResponse = successResponse != null ? successResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder successResponse(ResponseSpecification successResponse) {
            this.successResponse = successResponse;
            return this;
        }

        public final ResponseSpecification.Builder getFailureResponse() {
            return failureResponse != null ? failureResponse.toBuilder() : null;
        }

        public final void setFailureResponse(ResponseSpecification.BuilderImpl failureResponse) {
            this.failureResponse = failureResponse != null ? failureResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder failureResponse(ResponseSpecification failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public final ResponseSpecification.Builder getTimeoutResponse() {
            return timeoutResponse != null ? timeoutResponse.toBuilder() : null;
        }

        public final void setTimeoutResponse(ResponseSpecification.BuilderImpl timeoutResponse) {
            this.timeoutResponse = timeoutResponse != null ? timeoutResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder timeoutResponse(ResponseSpecification timeoutResponse) {
            this.timeoutResponse = timeoutResponse;
            return this;
        }

        @Override
        public PostFulfillmentStatusSpecification build() {
            return new PostFulfillmentStatusSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
