/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information for aggregated utterances. The <code>ListAggregatedUtterances</code> operations combines
 * all instances of the same utterance into a single aggregated summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatedUtterancesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatedUtterancesSummary.Builder, AggregatedUtterancesSummary> {
    private static final SdkField<String> UTTERANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("utterance").getter(getter(AggregatedUtterancesSummary::utterance)).setter(setter(Builder::utterance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterance").build()).build();

    private static final SdkField<Integer> HIT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("hitCount").getter(getter(AggregatedUtterancesSummary::hitCount)).setter(setter(Builder::hitCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hitCount").build()).build();

    private static final SdkField<Integer> MISSED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("missedCount").getter(getter(AggregatedUtterancesSummary::missedCount))
            .setter(setter(Builder::missedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missedCount").build()).build();

    private static final SdkField<Instant> UTTERANCE_FIRST_RECORDED_IN_AGGREGATION_DURATION_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("utteranceFirstRecordedInAggregationDuration")
            .getter(getter(AggregatedUtterancesSummary::utteranceFirstRecordedInAggregationDuration))
            .setter(setter(Builder::utteranceFirstRecordedInAggregationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("utteranceFirstRecordedInAggregationDuration").build()).build();

    private static final SdkField<Instant> UTTERANCE_LAST_RECORDED_IN_AGGREGATION_DURATION_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("utteranceLastRecordedInAggregationDuration")
            .getter(getter(AggregatedUtterancesSummary::utteranceLastRecordedInAggregationDuration))
            .setter(setter(Builder::utteranceLastRecordedInAggregationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("utteranceLastRecordedInAggregationDuration").build()).build();

    private static final SdkField<Boolean> CONTAINS_DATA_FROM_DELETED_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("containsDataFromDeletedResources")
            .getter(getter(AggregatedUtterancesSummary::containsDataFromDeletedResources))
            .setter(setter(Builder::containsDataFromDeletedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containsDataFromDeletedResources")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_FIELD,
            HIT_COUNT_FIELD, MISSED_COUNT_FIELD, UTTERANCE_FIRST_RECORDED_IN_AGGREGATION_DURATION_FIELD,
            UTTERANCE_LAST_RECORDED_IN_AGGREGATION_DURATION_FIELD, CONTAINS_DATA_FROM_DELETED_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String utterance;

    private final Integer hitCount;

    private final Integer missedCount;

    private final Instant utteranceFirstRecordedInAggregationDuration;

    private final Instant utteranceLastRecordedInAggregationDuration;

    private final Boolean containsDataFromDeletedResources;

    private AggregatedUtterancesSummary(BuilderImpl builder) {
        this.utterance = builder.utterance;
        this.hitCount = builder.hitCount;
        this.missedCount = builder.missedCount;
        this.utteranceFirstRecordedInAggregationDuration = builder.utteranceFirstRecordedInAggregationDuration;
        this.utteranceLastRecordedInAggregationDuration = builder.utteranceLastRecordedInAggregationDuration;
        this.containsDataFromDeletedResources = builder.containsDataFromDeletedResources;
    }

    /**
     * <p>
     * The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code> operation, the text
     * is the transcription of the audio utterance.
     * </p>
     * 
     * @return The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code> operation,
     *         the text is the transcription of the audio utterance.
     */
    public final String utterance() {
        return utterance;
    }

    /**
     * <p>
     * The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance is
     * detected, it activates an intent or a slot.
     * </p>
     * 
     * @return The number of times that the utterance was detected by Amazon Lex during the time period. When an
     *         utterance is detected, it activates an intent or a slot.
     */
    public final Integer hitCount() {
        return hitCount;
    }

    /**
     * <p>
     * The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't activate
     * an intent or slot.
     * </p>
     * 
     * @return The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't
     *         activate an intent or slot.
     */
    public final Integer missedCount() {
        return missedCount;
    }

    /**
     * <p>
     * The date and time that the utterance was first recorded in the time window for aggregation. An utterance may have
     * been sent to Amazon Lex before that time, but only utterances within the time window are counted.
     * </p>
     * 
     * @return The date and time that the utterance was first recorded in the time window for aggregation. An utterance
     *         may have been sent to Amazon Lex before that time, but only utterances within the time window are
     *         counted.
     */
    public final Instant utteranceFirstRecordedInAggregationDuration() {
        return utteranceFirstRecordedInAggregationDuration;
    }

    /**
     * <p>
     * The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be
     * sent to Amazon Lex after that time, but only utterances within the time window are counted.
     * </p>
     * 
     * @return The last date and time that an utterance was recorded in the time window for aggregation. An utterance
     *         may be sent to Amazon Lex after that time, but only utterances within the time window are counted.
     */
    public final Instant utteranceLastRecordedInAggregationDuration() {
        return utteranceLastRecordedInAggregationDuration;
    }

    /**
     * <p>
     * Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When the
     * aggregated contains this kind of data, this field is set to true.
     * </p>
     * 
     * @return Aggregated utterance data may contain utterances from versions of your bot that have since been deleted.
     *         When the aggregated contains this kind of data, this field is set to true.
     */
    public final Boolean containsDataFromDeletedResources() {
        return containsDataFromDeletedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utterance());
        hashCode = 31 * hashCode + Objects.hashCode(hitCount());
        hashCode = 31 * hashCode + Objects.hashCode(missedCount());
        hashCode = 31 * hashCode + Objects.hashCode(utteranceFirstRecordedInAggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(utteranceLastRecordedInAggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(containsDataFromDeletedResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedUtterancesSummary)) {
            return false;
        }
        AggregatedUtterancesSummary other = (AggregatedUtterancesSummary) obj;
        return Objects.equals(utterance(), other.utterance())
                && Objects.equals(hitCount(), other.hitCount())
                && Objects.equals(missedCount(), other.missedCount())
                && Objects.equals(utteranceFirstRecordedInAggregationDuration(),
                        other.utteranceFirstRecordedInAggregationDuration())
                && Objects.equals(utteranceLastRecordedInAggregationDuration(),
                        other.utteranceLastRecordedInAggregationDuration())
                && Objects.equals(containsDataFromDeletedResources(), other.containsDataFromDeletedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregatedUtterancesSummary").add("Utterance", utterance()).add("HitCount", hitCount())
                .add("MissedCount", missedCount())
                .add("UtteranceFirstRecordedInAggregationDuration", utteranceFirstRecordedInAggregationDuration())
                .add("UtteranceLastRecordedInAggregationDuration", utteranceLastRecordedInAggregationDuration())
                .add("ContainsDataFromDeletedResources", containsDataFromDeletedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "utterance":
            return Optional.ofNullable(clazz.cast(utterance()));
        case "hitCount":
            return Optional.ofNullable(clazz.cast(hitCount()));
        case "missedCount":
            return Optional.ofNullable(clazz.cast(missedCount()));
        case "utteranceFirstRecordedInAggregationDuration":
            return Optional.ofNullable(clazz.cast(utteranceFirstRecordedInAggregationDuration()));
        case "utteranceLastRecordedInAggregationDuration":
            return Optional.ofNullable(clazz.cast(utteranceLastRecordedInAggregationDuration()));
        case "containsDataFromDeletedResources":
            return Optional.ofNullable(clazz.cast(containsDataFromDeletedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedUtterancesSummary, T> g) {
        return obj -> g.apply((AggregatedUtterancesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatedUtterancesSummary> {
        /**
         * <p>
         * The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code> operation, the
         * text is the transcription of the audio utterance.
         * </p>
         * 
         * @param utterance
         *        The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code>
         *        operation, the text is the transcription of the audio utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterance(String utterance);

        /**
         * <p>
         * The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance
         * is detected, it activates an intent or a slot.
         * </p>
         * 
         * @param hitCount
         *        The number of times that the utterance was detected by Amazon Lex during the time period. When an
         *        utterance is detected, it activates an intent or a slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitCount(Integer hitCount);

        /**
         * <p>
         * The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't
         * activate an intent or slot.
         * </p>
         * 
         * @param missedCount
         *        The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't
         *        activate an intent or slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missedCount(Integer missedCount);

        /**
         * <p>
         * The date and time that the utterance was first recorded in the time window for aggregation. An utterance may
         * have been sent to Amazon Lex before that time, but only utterances within the time window are counted.
         * </p>
         * 
         * @param utteranceFirstRecordedInAggregationDuration
         *        The date and time that the utterance was first recorded in the time window for aggregation. An
         *        utterance may have been sent to Amazon Lex before that time, but only utterances within the time
         *        window are counted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceFirstRecordedInAggregationDuration(Instant utteranceFirstRecordedInAggregationDuration);

        /**
         * <p>
         * The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be
         * sent to Amazon Lex after that time, but only utterances within the time window are counted.
         * </p>
         * 
         * @param utteranceLastRecordedInAggregationDuration
         *        The last date and time that an utterance was recorded in the time window for aggregation. An utterance
         *        may be sent to Amazon Lex after that time, but only utterances within the time window are counted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceLastRecordedInAggregationDuration(Instant utteranceLastRecordedInAggregationDuration);

        /**
         * <p>
         * Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When
         * the aggregated contains this kind of data, this field is set to true.
         * </p>
         * 
         * @param containsDataFromDeletedResources
         *        Aggregated utterance data may contain utterances from versions of your bot that have since been
         *        deleted. When the aggregated contains this kind of data, this field is set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsDataFromDeletedResources(Boolean containsDataFromDeletedResources);
    }

    static final class BuilderImpl implements Builder {
        private String utterance;

        private Integer hitCount;

        private Integer missedCount;

        private Instant utteranceFirstRecordedInAggregationDuration;

        private Instant utteranceLastRecordedInAggregationDuration;

        private Boolean containsDataFromDeletedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedUtterancesSummary model) {
            utterance(model.utterance);
            hitCount(model.hitCount);
            missedCount(model.missedCount);
            utteranceFirstRecordedInAggregationDuration(model.utteranceFirstRecordedInAggregationDuration);
            utteranceLastRecordedInAggregationDuration(model.utteranceLastRecordedInAggregationDuration);
            containsDataFromDeletedResources(model.containsDataFromDeletedResources);
        }

        public final String getUtterance() {
            return utterance;
        }

        public final void setUtterance(String utterance) {
            this.utterance = utterance;
        }

        @Override
        @Transient
        public final Builder utterance(String utterance) {
            this.utterance = utterance;
            return this;
        }

        public final Integer getHitCount() {
            return hitCount;
        }

        public final void setHitCount(Integer hitCount) {
            this.hitCount = hitCount;
        }

        @Override
        @Transient
        public final Builder hitCount(Integer hitCount) {
            this.hitCount = hitCount;
            return this;
        }

        public final Integer getMissedCount() {
            return missedCount;
        }

        public final void setMissedCount(Integer missedCount) {
            this.missedCount = missedCount;
        }

        @Override
        @Transient
        public final Builder missedCount(Integer missedCount) {
            this.missedCount = missedCount;
            return this;
        }

        public final Instant getUtteranceFirstRecordedInAggregationDuration() {
            return utteranceFirstRecordedInAggregationDuration;
        }

        public final void setUtteranceFirstRecordedInAggregationDuration(Instant utteranceFirstRecordedInAggregationDuration) {
            this.utteranceFirstRecordedInAggregationDuration = utteranceFirstRecordedInAggregationDuration;
        }

        @Override
        @Transient
        public final Builder utteranceFirstRecordedInAggregationDuration(Instant utteranceFirstRecordedInAggregationDuration) {
            this.utteranceFirstRecordedInAggregationDuration = utteranceFirstRecordedInAggregationDuration;
            return this;
        }

        public final Instant getUtteranceLastRecordedInAggregationDuration() {
            return utteranceLastRecordedInAggregationDuration;
        }

        public final void setUtteranceLastRecordedInAggregationDuration(Instant utteranceLastRecordedInAggregationDuration) {
            this.utteranceLastRecordedInAggregationDuration = utteranceLastRecordedInAggregationDuration;
        }

        @Override
        @Transient
        public final Builder utteranceLastRecordedInAggregationDuration(Instant utteranceLastRecordedInAggregationDuration) {
            this.utteranceLastRecordedInAggregationDuration = utteranceLastRecordedInAggregationDuration;
            return this;
        }

        public final Boolean getContainsDataFromDeletedResources() {
            return containsDataFromDeletedResources;
        }

        public final void setContainsDataFromDeletedResources(Boolean containsDataFromDeletedResources) {
            this.containsDataFromDeletedResources = containsDataFromDeletedResources;
        }

        @Override
        @Transient
        public final Builder containsDataFromDeletedResources(Boolean containsDataFromDeletedResources) {
            this.containsDataFromDeletedResources = containsDataFromDeletedResources;
            return this;
        }

        @Override
        public AggregatedUtterancesSummary build() {
            return new AggregatedUtterancesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
