/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a record of an event that affects a bot alias. For example, when the version of a bot that the alias points
 * to changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotAliasHistoryEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<BotAliasHistoryEvent.Builder, BotAliasHistoryEvent> {
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BotAliasHistoryEvent::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(BotAliasHistoryEvent::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDate").getter(getter(BotAliasHistoryEvent::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_VERSION_FIELD,
            START_DATE_FIELD, END_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botVersion;

    private final Instant startDate;

    private final Instant endDate;

    private BotAliasHistoryEvent(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * The version of the bot that was used in the event.
     * </p>
     * 
     * @return The version of the bot that was used in the event.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The date and time that the event started.
     * </p>
     * 
     * @return The date and time that the event started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time that the event ended.
     * </p>
     * 
     * @return The date and time that the event ended.
     */
    public final Instant endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasHistoryEvent)) {
            return false;
        }
        BotAliasHistoryEvent other = (BotAliasHistoryEvent) obj;
        return Objects.equals(botVersion(), other.botVersion()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotAliasHistoryEvent").add("BotVersion", botVersion()).add("StartDate", startDate())
                .add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotAliasHistoryEvent, T> g) {
        return obj -> g.apply((BotAliasHistoryEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotAliasHistoryEvent> {
        /**
         * <p>
         * The version of the bot that was used in the event.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that was used in the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The date and time that the event started.
         * </p>
         * 
         * @param startDate
         *        The date and time that the event started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date and time that the event ended.
         * </p>
         * 
         * @param endDate
         *        The date and time that the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);
    }

    static final class BuilderImpl implements Builder {
        private String botVersion;

        private Instant startDate;

        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasHistoryEvent model) {
            botVersion(model.botVersion);
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        @Transient
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public BotAliasHistoryEvent build() {
            return new BotAliasHistoryEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
