/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotVersionResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateBotVersionResponse.Builder, CreateBotVersionResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotVersionResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotVersionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateBotVersionResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Map<String, BotVersionLocaleDetails>> BOT_VERSION_LOCALE_SPECIFICATION_FIELD = SdkField
            .<Map<String, BotVersionLocaleDetails>> builder(MarshallingType.MAP)
            .memberName("botVersionLocaleSpecification")
            .getter(getter(CreateBotVersionResponse::botVersionLocaleSpecification))
            .setter(setter(Builder::botVersionLocaleSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionLocaleSpecification")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BotVersionLocaleDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotVersionLocaleDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(CreateBotVersionResponse::botStatusAsString))
            .setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateBotVersionResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_VERSION_LOCALE_SPECIFICATION_FIELD, BOT_STATUS_FIELD,
            CREATION_DATE_TIME_FIELD));

    private final String botId;

    private final String description;

    private final String botVersion;

    private final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification;

    private final String botStatus;

    private final Instant creationDateTime;

    private CreateBotVersionResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botVersionLocaleSpecification = builder.botVersionLocaleSpecification;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The bot identifier specified in the request.
     * </p>
     * 
     * @return The bot identifier specified in the request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The description of the version specified in the request.
     * </p>
     * 
     * @return The description of the version specified in the request.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version number assigned to the version.
     * </p>
     * 
     * @return The version number assigned to the version.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotVersionLocaleSpecification property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotVersionLocaleSpecification() {
        return botVersionLocaleSpecification != null && !(botVersionLocaleSpecification instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The source versions used for each locale in the new version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotVersionLocaleSpecification} method.
     * </p>
     * 
     * @return The source versions used for each locale in the new version.
     */
    public final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification() {
        return botVersionLocaleSpecification;
    }

    /**
     * <p>
     * When you send a request to create or update a bot, Amazon Lex sets the status response element to
     * <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex
     * can't build the bot, it sets status to <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return When you send a request to create or update a bot, Amazon Lex sets the status response element to
     *         <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If
     *         Amazon Lex can't build the bot, it sets status to <code>Failed</code>.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * When you send a request to create or update a bot, Amazon Lex sets the status response element to
     * <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex
     * can't build the bot, it sets status to <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return When you send a request to create or update a bot, Amazon Lex sets the status response element to
     *         <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If
     *         Amazon Lex can't build the bot, it sets status to <code>Failed</code>.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * <p>
     * A timestamp of the date and time that the version was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the version was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotVersionLocaleSpecification() ? botVersionLocaleSpecification() : null);
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotVersionResponse)) {
            return false;
        }
        CreateBotVersionResponse other = (CreateBotVersionResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion())
                && hasBotVersionLocaleSpecification() == other.hasBotVersionLocaleSpecification()
                && Objects.equals(botVersionLocaleSpecification(), other.botVersionLocaleSpecification())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateBotVersionResponse")
                .add("BotId", botId())
                .add("Description", description())
                .add("BotVersion", botVersion())
                .add("BotVersionLocaleSpecification", hasBotVersionLocaleSpecification() ? botVersionLocaleSpecification() : null)
                .add("BotStatus", botStatusAsString()).add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botVersionLocaleSpecification":
            return Optional.ofNullable(clazz.cast(botVersionLocaleSpecification()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBotVersionResponse, T> g) {
        return obj -> g.apply((CreateBotVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotVersionResponse> {
        /**
         * <p>
         * The bot identifier specified in the request.
         * </p>
         * 
         * @param botId
         *        The bot identifier specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The description of the version specified in the request.
         * </p>
         * 
         * @param description
         *        The description of the version specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version number assigned to the version.
         * </p>
         * 
         * @param botVersion
         *        The version number assigned to the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The source versions used for each locale in the new version.
         * </p>
         * 
         * @param botVersionLocaleSpecification
         *        The source versions used for each locale in the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification);

        /**
         * <p>
         * When you send a request to create or update a bot, Amazon Lex sets the status response element to
         * <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon
         * Lex can't build the bot, it sets status to <code>Failed</code>.
         * </p>
         * 
         * @param botStatus
         *        When you send a request to create or update a bot, Amazon Lex sets the status response element to
         *        <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If
         *        Amazon Lex can't build the bot, it sets status to <code>Failed</code>.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * When you send a request to create or update a bot, Amazon Lex sets the status response element to
         * <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon
         * Lex can't build the bot, it sets status to <code>Failed</code>.
         * </p>
         * 
         * @param botStatus
         *        When you send a request to create or update a bot, Amazon Lex sets the status response element to
         *        <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If
         *        Amazon Lex can't build the bot, it sets status to <code>Failed</code>.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * A timestamp of the date and time that the version was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String description;

        private String botVersion;

        private Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification = DefaultSdkAutoConstructMap.getInstance();

        private String botStatus;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotVersionResponse model) {
            super(model);
            botId(model.botId);
            description(model.description);
            botVersion(model.botVersion);
            botVersionLocaleSpecification(model.botVersionLocaleSpecification);
            botStatus(model.botStatus);
            creationDateTime(model.creationDateTime);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Map<String, BotVersionLocaleDetails.Builder> getBotVersionLocaleSpecification() {
            Map<String, BotVersionLocaleDetails.Builder> result = BotVersionLocaleSpecificationCopier
                    .copyToBuilder(this.botVersionLocaleSpecification);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotVersionLocaleSpecification(
                Map<String, BotVersionLocaleDetails.BuilderImpl> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier
                    .copyFromBuilder(botVersionLocaleSpecification);
        }

        @Override
        @Transient
        public final Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier.copy(botVersionLocaleSpecification);
            return this;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        @Transient
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public CreateBotVersionResponse build() {
            return new CreateBotVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
