/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteImportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DeleteImportResponse.Builder, DeleteImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(DeleteImportResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(DeleteImportResponse::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            IMPORT_STATUS_FIELD));

    private final String importId;

    private final String importStatus;

    private DeleteImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
    }

    /**
     * <p>
     * The unique identifier of the deleted import.
     * </p>
     * 
     * @return The unique identifier of the deleted import.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * The current status of the deletion. When the deletion is complete, the import will no longer be returned by the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to
     * the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation
     * with the import identifier will fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The current status of the deletion. When the deletion is complete, the import will no longer be returned
     *         by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a>
     *         operation and calls to the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation
     *         with the import identifier will fail.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The current status of the deletion. When the deletion is complete, the import will no longer be returned by the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to
     * the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation
     * with the import identifier will fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The current status of the deletion. When the deletion is complete, the import will no longer be returned
     *         by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a>
     *         operation and calls to the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation
     *         with the import identifier will fail.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImportResponse)) {
            return false;
        }
        DeleteImportResponse other = (DeleteImportResponse) obj;
        return Objects.equals(importId(), other.importId())
                && Objects.equals(importStatusAsString(), other.importStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteImportResponse").add("ImportId", importId()).add("ImportStatus", importStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteImportResponse, T> g) {
        return obj -> g.apply((DeleteImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteImportResponse> {
        /**
         * <p>
         * The unique identifier of the deleted import.
         * </p>
         * 
         * @param importId
         *        The unique identifier of the deleted import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The current status of the deletion. When the deletion is complete, the import will no longer be returned by
         * the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and
         * calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a>
         * operation with the import identifier will fail.
         * </p>
         * 
         * @param importStatus
         *        The current status of the deletion. When the deletion is complete, the import will no longer be
         *        returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and
         *        calls to the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a>
         *        operation with the import identifier will fail.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The current status of the deletion. When the deletion is complete, the import will no longer be returned by
         * the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and
         * calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a>
         * operation with the import identifier will fail.
         * </p>
         * 
         * @param importStatus
         *        The current status of the deletion. When the deletion is complete, the import will no longer be
         *        returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and
         *        calls to the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a>
         *        operation with the import identifier will fail.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String importId;

        private String importStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImportResponse model) {
            super(model);
            importId(model.importId);
            importStatus(model.importStatus);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        @Transient
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        @Transient
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        @Override
        public DeleteImportResponse build() {
            return new DeleteImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
