/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettingsMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.SentimentAnalysisSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBotAliasRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, UpdateBotAliasRequest> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::botAliasId)).setter(UpdateBotAliasRequest.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasName").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::botAliasName)).setter(UpdateBotAliasRequest.setter(Builder::botAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::description)).setter(UpdateBotAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::botVersion)).setter(UpdateBotAliasRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<Map<String, BotAliasLocaleSettings>> BOT_ALIAS_LOCALE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("botAliasLocaleSettings").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::botAliasLocaleSettings)).setter(UpdateBotAliasRequest.setter(Builder::botAliasLocaleSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasLocaleSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotAliasLocaleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConversationLogSettings> CONVERSATION_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationLogSettings").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::conversationLogSettings)).setter(UpdateBotAliasRequest.setter(Builder::conversationLogSettings)).constructor(ConversationLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogSettings").build()}).build();
    private static final SdkField<SentimentAnalysisSettings> SENTIMENT_ANALYSIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sentimentAnalysisSettings").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::sentimentAnalysisSettings)).setter(UpdateBotAliasRequest.setter(Builder::sentimentAnalysisSettings)).constructor(SentimentAnalysisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentAnalysisSettings").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(UpdateBotAliasRequest.getter(UpdateBotAliasRequest::botId)).setter(UpdateBotAliasRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD, BOT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_LOCALE_SETTINGS_FIELD, CONVERSATION_LOG_SETTINGS_FIELD, SENTIMENT_ANALYSIS_SETTINGS_FIELD, BOT_ID_FIELD));
    private final String botAliasId;
    private final String botAliasName;
    private final String description;
    private final String botVersion;
    private final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings;
    private final ConversationLogSettings conversationLogSettings;
    private final SentimentAnalysisSettings sentimentAnalysisSettings;
    private final String botId;

    private UpdateBotAliasRequest(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
        this.conversationLogSettings = builder.conversationLogSettings;
        this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        this.botId = builder.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botAliasName() {
        return this.botAliasName;
    }

    public final String description() {
        return this.description;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final boolean hasBotAliasLocaleSettings() {
        return this.botAliasLocaleSettings != null && !(this.botAliasLocaleSettings instanceof SdkAutoConstructMap);
    }

    public final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings() {
        return this.botAliasLocaleSettings;
    }

    public final ConversationLogSettings conversationLogSettings() {
        return this.conversationLogSettings;
    }

    public final SentimentAnalysisSettings sentimentAnalysisSettings() {
        return this.sentimentAnalysisSettings;
    }

    public final String botId() {
        return this.botId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotAliasLocaleSettings() ? this.botAliasLocaleSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAnalysisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotAliasRequest)) {
            return false;
        }
        UpdateBotAliasRequest other = (UpdateBotAliasRequest)((Object)obj);
        return Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botAliasName(), other.botAliasName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botVersion(), other.botVersion()) && this.hasBotAliasLocaleSettings() == other.hasBotAliasLocaleSettings() && Objects.equals(this.botAliasLocaleSettings(), other.botAliasLocaleSettings()) && Objects.equals(this.conversationLogSettings(), other.conversationLogSettings()) && Objects.equals(this.sentimentAnalysisSettings(), other.sentimentAnalysisSettings()) && Objects.equals(this.botId(), other.botId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBotAliasRequest").add("BotAliasId", (Object)this.botAliasId()).add("BotAliasName", (Object)this.botAliasName()).add("Description", (Object)this.description()).add("BotVersion", (Object)this.botVersion()).add("BotAliasLocaleSettings", this.hasBotAliasLocaleSettings() ? this.botAliasLocaleSettings() : null).add("ConversationLogSettings", (Object)this.conversationLogSettings()).add("SentimentAnalysisSettings", (Object)this.sentimentAnalysisSettings()).add("BotId", (Object)this.botId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botAliasName": {
                return Optional.ofNullable(clazz.cast(this.botAliasName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "botAliasLocaleSettings": {
                return Optional.ofNullable(clazz.cast(this.botAliasLocaleSettings()));
            }
            case "conversationLogSettings": {
                return Optional.ofNullable(clazz.cast(this.conversationLogSettings()));
            }
            case "sentimentAnalysisSettings": {
                return Optional.ofNullable(clazz.cast(this.sentimentAnalysisSettings()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotAliasRequest, T> g) {
        return obj -> g.apply((UpdateBotAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botAliasId;
        private String botAliasName;
        private String description;
        private String botVersion;
        private Map<String, BotAliasLocaleSettings> botAliasLocaleSettings = DefaultSdkAutoConstructMap.getInstance();
        private ConversationLogSettings conversationLogSettings;
        private SentimentAnalysisSettings sentimentAnalysisSettings;
        private String botId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotAliasRequest model) {
            super(model);
            this.botAliasId(model.botAliasId);
            this.botAliasName(model.botAliasName);
            this.description(model.description);
            this.botVersion(model.botVersion);
            this.botAliasLocaleSettings(model.botAliasLocaleSettings);
            this.conversationLogSettings(model.conversationLogSettings);
            this.sentimentAnalysisSettings(model.sentimentAnalysisSettings);
            this.botId(model.botId);
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        @Transient
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasName() {
            return this.botAliasName;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        @Override
        @Transient
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Map<String, BotAliasLocaleSettings.Builder> getBotAliasLocaleSettings() {
            Map<String, BotAliasLocaleSettings.Builder> result = BotAliasLocaleSettingsMapCopier.copyToBuilder(this.botAliasLocaleSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotAliasLocaleSettings(Map<String, BotAliasLocaleSettings.BuilderImpl> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copyFromBuilder(botAliasLocaleSettings);
        }

        @Override
        @Transient
        public final Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copy(botAliasLocaleSettings);
            return this;
        }

        public final ConversationLogSettings.Builder getConversationLogSettings() {
            return this.conversationLogSettings != null ? this.conversationLogSettings.toBuilder() : null;
        }

        public final void setConversationLogSettings(ConversationLogSettings.BuilderImpl conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings != null ? conversationLogSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder conversationLogSettings(ConversationLogSettings conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        public final SentimentAnalysisSettings.Builder getSentimentAnalysisSettings() {
            return this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.toBuilder() : null;
        }

        public final void setSentimentAnalysisSettings(SentimentAnalysisSettings.BuilderImpl sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings != null ? sentimentAnalysisSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBotAliasRequest build() {
            return new UpdateBotAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBotAliasRequest> {
        public Builder botAliasId(String var1);

        public Builder botAliasName(String var1);

        public Builder description(String var1);

        public Builder botVersion(String var1);

        public Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> var1);

        public Builder conversationLogSettings(ConversationLogSettings var1);

        default public Builder conversationLogSettings(Consumer<ConversationLogSettings.Builder> conversationLogSettings) {
            return this.conversationLogSettings((ConversationLogSettings)((ConversationLogSettings.Builder)ConversationLogSettings.builder().applyMutation(conversationLogSettings)).build());
        }

        public Builder sentimentAnalysisSettings(SentimentAnalysisSettings var1);

        default public Builder sentimentAnalysisSettings(Consumer<SentimentAnalysisSettings.Builder> sentimentAnalysisSettings) {
            return this.sentimentAnalysisSettings((SentimentAnalysisSettings)((SentimentAnalysisSettings.Builder)SentimentAnalysisSettings.builder().applyMutation(sentimentAnalysisSettings)).build());
        }

        public Builder botId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

