/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettingsMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.SentimentAnalysisSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBotAliasResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, UpdateBotAliasResponse> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botAliasId)).setter(UpdateBotAliasResponse.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasName").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botAliasName)).setter(UpdateBotAliasResponse.setter(Builder::botAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::description)).setter(UpdateBotAliasResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botVersion)).setter(UpdateBotAliasResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<Map<String, BotAliasLocaleSettings>> BOT_ALIAS_LOCALE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("botAliasLocaleSettings").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botAliasLocaleSettings)).setter(UpdateBotAliasResponse.setter(Builder::botAliasLocaleSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasLocaleSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotAliasLocaleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConversationLogSettings> CONVERSATION_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationLogSettings").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::conversationLogSettings)).setter(UpdateBotAliasResponse.setter(Builder::conversationLogSettings)).constructor(ConversationLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogSettings").build()}).build();
    private static final SdkField<SentimentAnalysisSettings> SENTIMENT_ANALYSIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sentimentAnalysisSettings").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::sentimentAnalysisSettings)).setter(UpdateBotAliasResponse.setter(Builder::sentimentAnalysisSettings)).constructor(SentimentAnalysisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentAnalysisSettings").build()}).build();
    private static final SdkField<String> BOT_ALIAS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasStatus").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botAliasStatusAsString)).setter(UpdateBotAliasResponse.setter(Builder::botAliasStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasStatus").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::botId)).setter(UpdateBotAliasResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::creationDateTime)).setter(UpdateBotAliasResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(UpdateBotAliasResponse.getter(UpdateBotAliasResponse::lastUpdatedDateTime)).setter(UpdateBotAliasResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD, BOT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_LOCALE_SETTINGS_FIELD, CONVERSATION_LOG_SETTINGS_FIELD, SENTIMENT_ANALYSIS_SETTINGS_FIELD, BOT_ALIAS_STATUS_FIELD, BOT_ID_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private final String botAliasId;
    private final String botAliasName;
    private final String description;
    private final String botVersion;
    private final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings;
    private final ConversationLogSettings conversationLogSettings;
    private final SentimentAnalysisSettings sentimentAnalysisSettings;
    private final String botAliasStatus;
    private final String botId;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private UpdateBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
        this.conversationLogSettings = builder.conversationLogSettings;
        this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        this.botAliasStatus = builder.botAliasStatus;
        this.botId = builder.botId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botAliasName() {
        return this.botAliasName;
    }

    public final String description() {
        return this.description;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final boolean hasBotAliasLocaleSettings() {
        return this.botAliasLocaleSettings != null && !(this.botAliasLocaleSettings instanceof SdkAutoConstructMap);
    }

    public final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings() {
        return this.botAliasLocaleSettings;
    }

    public final ConversationLogSettings conversationLogSettings() {
        return this.conversationLogSettings;
    }

    public final SentimentAnalysisSettings sentimentAnalysisSettings() {
        return this.sentimentAnalysisSettings;
    }

    public final BotAliasStatus botAliasStatus() {
        return BotAliasStatus.fromValue(this.botAliasStatus);
    }

    public final String botAliasStatusAsString() {
        return this.botAliasStatus;
    }

    public final String botId() {
        return this.botId;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotAliasLocaleSettings() ? this.botAliasLocaleSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAnalysisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotAliasResponse)) {
            return false;
        }
        UpdateBotAliasResponse other = (UpdateBotAliasResponse)((Object)obj);
        return Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botAliasName(), other.botAliasName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botVersion(), other.botVersion()) && this.hasBotAliasLocaleSettings() == other.hasBotAliasLocaleSettings() && Objects.equals(this.botAliasLocaleSettings(), other.botAliasLocaleSettings()) && Objects.equals(this.conversationLogSettings(), other.conversationLogSettings()) && Objects.equals(this.sentimentAnalysisSettings(), other.sentimentAnalysisSettings()) && Objects.equals(this.botAliasStatusAsString(), other.botAliasStatusAsString()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBotAliasResponse").add("BotAliasId", (Object)this.botAliasId()).add("BotAliasName", (Object)this.botAliasName()).add("Description", (Object)this.description()).add("BotVersion", (Object)this.botVersion()).add("BotAliasLocaleSettings", this.hasBotAliasLocaleSettings() ? this.botAliasLocaleSettings() : null).add("ConversationLogSettings", (Object)this.conversationLogSettings()).add("SentimentAnalysisSettings", (Object)this.sentimentAnalysisSettings()).add("BotAliasStatus", (Object)this.botAliasStatusAsString()).add("BotId", (Object)this.botId()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botAliasName": {
                return Optional.ofNullable(clazz.cast(this.botAliasName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "botAliasLocaleSettings": {
                return Optional.ofNullable(clazz.cast(this.botAliasLocaleSettings()));
            }
            case "conversationLogSettings": {
                return Optional.ofNullable(clazz.cast(this.conversationLogSettings()));
            }
            case "sentimentAnalysisSettings": {
                return Optional.ofNullable(clazz.cast(this.sentimentAnalysisSettings()));
            }
            case "botAliasStatus": {
                return Optional.ofNullable(clazz.cast(this.botAliasStatusAsString()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotAliasResponse, T> g) {
        return obj -> g.apply((UpdateBotAliasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botAliasId;
        private String botAliasName;
        private String description;
        private String botVersion;
        private Map<String, BotAliasLocaleSettings> botAliasLocaleSettings = DefaultSdkAutoConstructMap.getInstance();
        private ConversationLogSettings conversationLogSettings;
        private SentimentAnalysisSettings sentimentAnalysisSettings;
        private String botAliasStatus;
        private String botId;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotAliasResponse model) {
            super(model);
            this.botAliasId(model.botAliasId);
            this.botAliasName(model.botAliasName);
            this.description(model.description);
            this.botVersion(model.botVersion);
            this.botAliasLocaleSettings(model.botAliasLocaleSettings);
            this.conversationLogSettings(model.conversationLogSettings);
            this.sentimentAnalysisSettings(model.sentimentAnalysisSettings);
            this.botAliasStatus(model.botAliasStatus);
            this.botId(model.botId);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        @Transient
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasName() {
            return this.botAliasName;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        @Override
        @Transient
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Map<String, BotAliasLocaleSettings.Builder> getBotAliasLocaleSettings() {
            Map<String, BotAliasLocaleSettings.Builder> result = BotAliasLocaleSettingsMapCopier.copyToBuilder(this.botAliasLocaleSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotAliasLocaleSettings(Map<String, BotAliasLocaleSettings.BuilderImpl> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copyFromBuilder(botAliasLocaleSettings);
        }

        @Override
        @Transient
        public final Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copy(botAliasLocaleSettings);
            return this;
        }

        public final ConversationLogSettings.Builder getConversationLogSettings() {
            return this.conversationLogSettings != null ? this.conversationLogSettings.toBuilder() : null;
        }

        public final void setConversationLogSettings(ConversationLogSettings.BuilderImpl conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings != null ? conversationLogSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder conversationLogSettings(ConversationLogSettings conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        public final SentimentAnalysisSettings.Builder getSentimentAnalysisSettings() {
            return this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.toBuilder() : null;
        }

        public final void setSentimentAnalysisSettings(SentimentAnalysisSettings.BuilderImpl sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings != null ? sentimentAnalysisSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        public final String getBotAliasStatus() {
            return this.botAliasStatus;
        }

        public final void setBotAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
        }

        @Override
        @Transient
        public final Builder botAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder botAliasStatus(BotAliasStatus botAliasStatus) {
            this.botAliasStatus(botAliasStatus == null ? null : botAliasStatus.toString());
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public UpdateBotAliasResponse build() {
            return new UpdateBotAliasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBotAliasResponse> {
        public Builder botAliasId(String var1);

        public Builder botAliasName(String var1);

        public Builder description(String var1);

        public Builder botVersion(String var1);

        public Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> var1);

        public Builder conversationLogSettings(ConversationLogSettings var1);

        default public Builder conversationLogSettings(Consumer<ConversationLogSettings.Builder> conversationLogSettings) {
            return this.conversationLogSettings((ConversationLogSettings)((ConversationLogSettings.Builder)ConversationLogSettings.builder().applyMutation(conversationLogSettings)).build());
        }

        public Builder sentimentAnalysisSettings(SentimentAnalysisSettings var1);

        default public Builder sentimentAnalysisSettings(Consumer<SentimentAnalysisSettings.Builder> sentimentAnalysisSettings) {
            return this.sentimentAnalysisSettings((SentimentAnalysisSettings)((SentimentAnalysisSettings.Builder)SentimentAnalysisSettings.builder().applyMutation(sentimentAnalysisSettings)).build());
        }

        public Builder botAliasStatus(String var1);

        public Builder botAliasStatus(BotAliasStatus var1);

        public Builder botId(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

