/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateBotRequest.Builder, CreateBotRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(CreateBotRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateBotRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(CreateBotRequest::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(CreateBotRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<Map<String, String>> BOT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("botTags")
            .getter(getter(CreateBotRequest::botTags))
            .setter(setter(Builder::botTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TEST_BOT_ALIAS_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("testBotAliasTags")
            .getter(getter(CreateBotRequest::testBotAliasTags))
            .setter(setter(Builder::testBotAliasTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testBotAliasTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_TAGS_FIELD,
            TEST_BOT_ALIAS_TAGS_FIELD));

    private final String botName;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final Map<String, String> botTags;

    private final Map<String, String> testBotAliasTags;

    private CreateBotRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botTags = builder.botTags;
        this.testBotAliasTags = builder.testBotAliasTags;
    }

    /**
     * <p>
     * The name of the bot. The bot name must be unique in the account that creates the bot.
     * </p>
     * 
     * @return The name of the bot. The bot name must be unique in the account that creates the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * A description of the bot. It appears in lists to help you identify a particular bot.
     * </p>
     * 
     * @return A description of the bot. It appears in lists to help you identify a particular bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     * </p>
     * 
     * @return Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Lex deletes any data provided before the timeout.
     * </p>
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     * </p>
     * 
     * @return The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     *         </p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *         </p>
     *         <p>
     *         You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBotTags() {
        return botTags != null && !(botTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the
     * <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotTags} method.
     * </p>
     * 
     * @return A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the
     *         <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code>
     *         operation.
     */
    public final Map<String, String> botTags() {
        return botTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestBotAliasTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestBotAliasTags() {
        return testBotAliasTags != null && !(testBotAliasTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the
     * <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
     * <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestBotAliasTags} method.
     * </p>
     * 
     * @return A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't
     *         use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
     *         <code>TagResource</code> operation.
     */
    public final Map<String, String> testBotAliasTags() {
        return testBotAliasTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotTags() ? botTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTestBotAliasTags() ? testBotAliasTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotRequest)) {
            return false;
        }
        CreateBotRequest other = (CreateBotRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && hasBotTags() == other.hasBotTags() && Objects.equals(botTags(), other.botTags())
                && hasTestBotAliasTags() == other.hasTestBotAliasTags()
                && Objects.equals(testBotAliasTags(), other.testBotAliasTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotRequest").add("BotName", botName()).add("Description", description())
                .add("RoleArn", roleArn()).add("DataPrivacy", dataPrivacy())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).add("BotTags", hasBotTags() ? botTags() : null)
                .add("TestBotAliasTags", hasTestBotAliasTags() ? testBotAliasTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botTags":
            return Optional.ofNullable(clazz.cast(botTags()));
        case "testBotAliasTags":
            return Optional.ofNullable(clazz.cast(testBotAliasTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBotRequest, T> g) {
        return obj -> g.apply((CreateBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotRequest> {
        /**
         * <p>
         * The name of the bot. The bot name must be unique in the account that creates the bot.
         * </p>
         * 
         * @param botName
         *        The name of the bot. The bot name must be unique in the account that creates the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * A description of the bot. It appears in lists to help you identify a particular bot.
         * </p>
         * 
         * @param description
         *        A description of the bot. It appears in lists to help you identify a particular bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * 
         * @param dataPrivacy
         *        Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to
         * create one manually via {@link DataPrivacy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * </p>
         * <p>
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
         *        bot. </p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *        </p>
         *        <p>
         *        You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the
         * <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * </p>
         * 
         * @param botTags
         *        A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the
         *        <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botTags(Map<String, String> botTags);

        /**
         * <p>
         * A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use
         * the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param testBotAliasTags
         *        A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You
         *        can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use
         *        the <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testBotAliasTags(Map<String, String> testBotAliasTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botName;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private Map<String, String> botTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> testBotAliasTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotRequest model) {
            super(model);
            botName(model.botName);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botTags(model.botTags);
            testBotAliasTags(model.testBotAliasTags);
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final Map<String, String> getBotTags() {
            if (botTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return botTags;
        }

        public final void setBotTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
        }

        @Override
        public final Builder botTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
            return this;
        }

        public final Map<String, String> getTestBotAliasTags() {
            if (testBotAliasTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return testBotAliasTags;
        }

        public final void setTestBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
        }

        @Override
        public final Builder testBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotRequest build() {
            return new CreateBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
