/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourcePolicyRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DeleteResourcePolicyRequest.Builder, DeleteResourcePolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(DeleteResourcePolicyRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()).build();

    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRevisionId").getter(getter(DeleteResourcePolicyRequest::expectedRevisionId))
            .setter(setter(Builder::expectedRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedRevisionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            EXPECTED_REVISION_ID_FIELD));

    private final String resourceArn;

    private final String expectedRevisionId;

    private DeleteResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.expectedRevisionId = builder.expectedRevisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns
     * an exception
     * </p>
     * <p>
     * If you don't specify a revision ID, Amazon Lex will delete the current policy.
     * </p>
     * 
     * @return The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex
     *         returns an exception</p>
     *         <p>
     *         If you don't specify a revision ID, Amazon Lex will delete the current policy.
     */
    public final String expectedRevisionId() {
        return expectedRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePolicyRequest)) {
            return false;
        }
        DeleteResourcePolicyRequest other = (DeleteResourcePolicyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(expectedRevisionId(), other.expectedRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourcePolicyRequest").add("ResourceArn", resourceArn())
                .add("ExpectedRevisionId", expectedRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "expectedRevisionId":
            return Optional.ofNullable(clazz.cast(expectedRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePolicyRequest, T> g) {
        return obj -> g.apply((DeleteResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourcePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex
         * returns an exception
         * </p>
         * <p>
         * If you don't specify a revision ID, Amazon Lex will delete the current policy.
         * </p>
         * 
         * @param expectedRevisionId
         *        The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon
         *        Lex returns an exception</p>
         *        <p>
         *        If you don't specify a revision ID, Amazon Lex will delete the current policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRevisionId(String expectedRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private String expectedRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePolicyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            expectedRevisionId(model.expectedRevisionId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getExpectedRevisionId() {
            return expectedRevisionId;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourcePolicyRequest build() {
            return new DeleteResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
