/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;

public class ListBotVersionsIterable
implements SdkIterable<ListBotVersionsResponse> {
    private final LexModelsV2Client client;
    private final ListBotVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotVersionsIterable(LexModelsV2Client client, ListBotVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBotVersionsResponseFetcher();
    }

    public Iterator<ListBotVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotVersionsResponseFetcher
    implements SyncPageFetcher<ListBotVersionsResponse> {
        private ListBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotVersionsResponse nextPage(ListBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListBotVersionsIterable.this.client.listBotVersions(ListBotVersionsIterable.this.firstRequest);
            }
            return ListBotVersionsIterable.this.client.listBotVersions((ListBotVersionsRequest)((Object)ListBotVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

