/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2Waiter;

/**
 * Service client for accessing Lex Models V2. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LexModelsV2Client extends SdkClient {
    String SERVICE_NAME = "lex";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "models-v2-lex";

    /**
     * Create a {@link LexModelsV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LexModelsV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LexModelsV2Client}.
     */
    static LexModelsV2ClientBuilder builder() {
        return new DefaultLexModelsV2ClientBuilder();
    }

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     * @return Result of the BatchCreateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateCustomVocabularyItemResponse batchCreateCustomVocabularyItem(
            BatchCreateCustomVocabularyItemRequest batchCreateCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateCustomVocabularyItemRequest.Builder} to
     *        create a request.
     * @return Result of the BatchCreateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateCustomVocabularyItemResponse batchCreateCustomVocabularyItem(
            Consumer<BatchCreateCustomVocabularyItemRequest.Builder> batchCreateCustomVocabularyItemRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return batchCreateCustomVocabularyItem(BatchCreateCustomVocabularyItemRequest.builder()
                .applyMutation(batchCreateCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     * @return Result of the BatchDeleteCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteCustomVocabularyItemResponse batchDeleteCustomVocabularyItem(
            BatchDeleteCustomVocabularyItemRequest batchDeleteCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteCustomVocabularyItemRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteCustomVocabularyItemResponse batchDeleteCustomVocabularyItem(
            Consumer<BatchDeleteCustomVocabularyItemRequest.Builder> batchDeleteCustomVocabularyItemRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return batchDeleteCustomVocabularyItem(BatchDeleteCustomVocabularyItemRequest.builder()
                .applyMutation(batchDeleteCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     * @return Result of the BatchUpdateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateCustomVocabularyItemResponse batchUpdateCustomVocabularyItem(
            BatchUpdateCustomVocabularyItemRequest batchUpdateCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchUpdateCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateCustomVocabularyItemRequest.Builder} to
     *        create a request.
     * @return Result of the BatchUpdateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateCustomVocabularyItemResponse batchUpdateCustomVocabularyItem(
            Consumer<BatchUpdateCustomVocabularyItemRequest.Builder> batchUpdateCustomVocabularyItemRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return batchUpdateCustomVocabularyItem(BatchUpdateCustomVocabularyItemRequest.builder()
                .applyMutation(batchUpdateCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default BuildBotLocaleResponse buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildBotLocaleRequest.Builder} avoiding the need to
     * create one manually via {@link BuildBotLocaleRequest#builder()}
     * </p>
     *
     * @param buildBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link BuildBotLocaleRequest.Builder} to create a request.
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default BuildBotLocaleResponse buildBotLocale(Consumer<BuildBotLocaleRequest.Builder> buildBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return buildBotLocale(BuildBotLocaleRequest.builder().applyMutation(buildBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotRequest#builder()}
     * </p>
     *
     * @param createBotRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotRequest.Builder} to create a request.
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBotResponse createBot(Consumer<CreateBotRequest.Builder> createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBot(CreateBotRequest.builder().applyMutation(createBotRequest).build());
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotAliasResponse createBotAlias(CreateBotAliasRequest createBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotAliasRequest#builder()}
     * </p>
     *
     * @param createBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotAliasRequest.Builder} to create a request.
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotAliasResponse createBotAlias(Consumer<CreateBotAliasRequest.Builder> createBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotAlias(CreateBotAliasRequest.builder().applyMutation(createBotAliasRequest).build());
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotLocaleResponse createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotLocaleRequest#builder()}
     * </p>
     *
     * @param createBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotLocaleRequest.Builder} to create a request.
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotLocaleResponse createBotLocale(Consumer<CreateBotLocaleRequest.Builder> createBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotLocale(CreateBotLocaleRequest.builder().applyMutation(createBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotVersionRequest#builder()}
     * </p>
     *
     * @param createBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotVersionRequest.Builder} to create a request.
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBotVersionResponse createBotVersion(Consumer<CreateBotVersionRequest.Builder> createBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotVersion(CreateBotVersionRequest.builder().applyMutation(createBotVersionRequest).build());
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     *
     * @param createExportRequest
     * @return Result of the CreateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExportResponse createExport(CreateExportRequest createExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportRequest.Builder} avoiding the need to
     * create one manually via {@link CreateExportRequest#builder()}
     * </p>
     *
     * @param createExportRequest
     *        A {@link Consumer} that will call methods on {@link CreateExportRequest.Builder} to create a request.
     * @return Result of the CreateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExportResponse createExport(Consumer<CreateExportRequest.Builder> createExportRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createExport(CreateExportRequest.builder().applyMutation(createExportRequest).build());
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateIntentResponse createIntent(CreateIntentRequest createIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIntentRequest#builder()}
     * </p>
     *
     * @param createIntentRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntentRequest.Builder} to create a request.
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateIntentResponse createIntent(Consumer<CreateIntentRequest.Builder> createIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createIntent(CreateIntentRequest.builder().applyMutation(createIntentRequest).build());
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     *
     * @param createResourcePolicyRequest
     * @return Result of the CreateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourcePolicyResponse createResourcePolicy(CreateResourcePolicyRequest createResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourcePolicyRequest#builder()}
     * </p>
     *
     * @param createResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourcePolicyResponse createResourcePolicy(
            Consumer<CreateResourcePolicyRequest.Builder> createResourcePolicyRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, PreconditionFailedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createResourcePolicy(CreateResourcePolicyRequest.builder().applyMutation(createResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     * @return Result of the CreateResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourcePolicyStatementResponse createResourcePolicyStatement(
            CreateResourcePolicyStatementRequest createResourcePolicyStatementRequest) throws ResourceNotFoundException,
            ConflictException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourcePolicyStatementRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourcePolicyStatementRequest#builder()}
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourcePolicyStatementRequest.Builder} to
     *        create a request.
     * @return Result of the CreateResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourcePolicyStatementResponse createResourcePolicyStatement(
            Consumer<CreateResourcePolicyStatementRequest.Builder> createResourcePolicyStatementRequest)
            throws ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, PreconditionFailedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return createResourcePolicyStatement(CreateResourcePolicyStatementRequest.builder()
                .applyMutation(createResourcePolicyStatementRequest).build());
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSlotResponse createSlot(CreateSlotRequest createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotRequest#builder()}
     * </p>
     *
     * @param createSlotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotRequest.Builder} to create a request.
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSlotResponse createSlot(Consumer<CreateSlotRequest.Builder> createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createSlot(CreateSlotRequest.builder().applyMutation(createSlotRequest).build());
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSlotTypeResponse createSlotType(CreateSlotTypeRequest createSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotTypeRequest#builder()}
     * </p>
     *
     * @param createSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotTypeRequest.Builder} to create a request.
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSlotTypeResponse createSlotType(Consumer<CreateSlotTypeRequest.Builder> createSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createSlotType(CreateSlotTypeRequest.builder().applyMutation(createSlotTypeRequest).build());
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUploadUrlResponse createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadUrlRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUploadUrlRequest#builder()}
     * </p>
     *
     * @param createUploadUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateUploadUrlRequest.Builder} to create a request.
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUploadUrlResponse createUploadUrl(Consumer<CreateUploadUrlRequest.Builder> createUploadUrlRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createUploadUrl(CreateUploadUrlRequest.builder().applyMutation(createUploadUrlRequest).build());
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotRequest#builder()}
     * </p>
     *
     * @param deleteBotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotRequest.Builder} to create a request.
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBotResponse deleteBot(Consumer<DeleteBotRequest.Builder> deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBot(DeleteBotRequest.builder().applyMutation(deleteBotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotAliasRequest#builder()}
     * </p>
     *
     * @param deleteBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotAliasRequest.Builder} to create a request.
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotAliasResponse deleteBotAlias(Consumer<DeleteBotAliasRequest.Builder> deleteBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotAlias(DeleteBotAliasRequest.builder().applyMutation(deleteBotAliasRequest).build());
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotLocaleResponse deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotLocaleRequest#builder()}
     * </p>
     *
     * @param deleteBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotLocaleRequest.Builder} to create a request.
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotLocaleResponse deleteBotLocale(Consumer<DeleteBotLocaleRequest.Builder> deleteBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotLocale(DeleteBotLocaleRequest.builder().applyMutation(deleteBotLocaleRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotVersionRequest#builder()}
     * </p>
     *
     * @param deleteBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotVersionRequest.Builder} to create a request.
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBotVersionResponse deleteBotVersion(Consumer<DeleteBotVersionRequest.Builder> deleteBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotVersion(DeleteBotVersionRequest.builder().applyMutation(deleteBotVersionRequest).build());
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     * @return Result of the DeleteCustomVocabulary operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVocabularyResponse deleteCustomVocabulary(DeleteCustomVocabularyRequest deleteCustomVocabularyRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCustomVocabulary operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVocabularyResponse deleteCustomVocabulary(
            Consumer<DeleteCustomVocabularyRequest.Builder> deleteCustomVocabularyRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteCustomVocabulary(DeleteCustomVocabularyRequest.builder().applyMutation(deleteCustomVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     *
     * @param deleteExportRequest
     * @return Result of the DeleteExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExportResponse deleteExport(DeleteExportRequest deleteExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExportRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteExportRequest#builder()}
     * </p>
     *
     * @param deleteExportRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExportRequest.Builder} to create a request.
     * @return Result of the DeleteExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExportResponse deleteExport(Consumer<DeleteExportRequest.Builder> deleteExportRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteExport(DeleteExportRequest.builder().applyMutation(deleteExportRequest).build());
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     *
     * @param deleteImportRequest
     * @return Result of the DeleteImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImportResponse deleteImport(DeleteImportRequest deleteImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImportRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImportRequest#builder()}
     * </p>
     *
     * @param deleteImportRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImportRequest.Builder} to create a request.
     * @return Result of the DeleteImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImportResponse deleteImport(Consumer<DeleteImportRequest.Builder> deleteImportRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteImport(DeleteImportRequest.builder().applyMutation(deleteImportRequest).build());
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIntentRequest#builder()}
     * </p>
     *
     * @param deleteIntentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntentRequest.Builder} to create a request.
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteIntentResponse deleteIntent(Consumer<DeleteIntentRequest.Builder> deleteIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteIntent(DeleteIntentRequest.builder().applyMutation(deleteIntentRequest).build());
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceNotFoundException, PreconditionFailedException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ResourceNotFoundException,
            PreconditionFailedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     * @return Result of the DeleteResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyStatementResponse deleteResourcePolicyStatement(
            DeleteResourcePolicyStatementRequest deleteResourcePolicyStatementRequest) throws ResourceNotFoundException,
            PreconditionFailedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyStatementRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourcePolicyStatementRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyStatementRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyStatementResponse deleteResourcePolicyStatement(
            Consumer<DeleteResourcePolicyStatementRequest.Builder> deleteResourcePolicyStatementRequest)
            throws ResourceNotFoundException, PreconditionFailedException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteResourcePolicyStatement(DeleteResourcePolicyStatementRequest.builder()
                .applyMutation(deleteResourcePolicyStatementRequest).build());
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSlotResponse deleteSlot(DeleteSlotRequest deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotRequest#builder()}
     * </p>
     *
     * @param deleteSlotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotRequest.Builder} to create a request.
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSlotResponse deleteSlot(Consumer<DeleteSlotRequest.Builder> deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteSlot(DeleteSlotRequest.builder().applyMutation(deleteSlotRequest).build());
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotTypeRequest#builder()}
     * </p>
     *
     * @param deleteSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotTypeRequest.Builder} to create a request.
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSlotTypeResponse deleteSlotType(Consumer<DeleteSlotTypeRequest.Builder> deleteSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteSlotType(DeleteSlotTypeRequest.builder().applyMutation(deleteSlotTypeRequest).build());
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return Result of the DeleteUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUtterancesResponse deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUtterancesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUtterancesRequest#builder()}
     * </p>
     *
     * @param deleteUtterancesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUtterancesRequest.Builder} to create a request.
     * @return Result of the DeleteUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUtterancesResponse deleteUtterances(Consumer<DeleteUtterancesRequest.Builder> deleteUtterancesRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return deleteUtterances(DeleteUtterancesRequest.builder().applyMutation(deleteUtterancesRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBotResponse describeBot(DescribeBotRequest describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBotRequest#builder()}
     * </p>
     *
     * @param describeBotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotRequest.Builder} to create a request.
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBotResponse describeBot(Consumer<DescribeBotRequest.Builder> describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBot(DescribeBotRequest.builder().applyMutation(describeBotRequest).build());
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotAliasResponse describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotAliasRequest#builder()}
     * </p>
     *
     * @param describeBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotAliasRequest.Builder} to create a request.
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotAliasResponse describeBotAlias(Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotAlias(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build());
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotLocaleResponse describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotLocaleRequest#builder()}
     * </p>
     *
     * @param describeBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotLocaleRequest.Builder} to create a request.
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotLocaleResponse describeBotLocale(Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotLocale(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     *
     * @param describeBotRecommendationRequest
     * @return Result of the DescribeBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotRecommendationResponse describeBotRecommendation(
            DescribeBotRecommendationRequest describeBotRecommendationRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRecommendationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBotRecommendationRequest#builder()}
     * </p>
     *
     * @param describeBotRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotRecommendationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotRecommendationResponse describeBotRecommendation(
            Consumer<DescribeBotRecommendationRequest.Builder> describeBotRecommendationRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return describeBotRecommendation(DescribeBotRecommendationRequest.builder()
                .applyMutation(describeBotRecommendationRequest).build());
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotVersionResponse describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBotVersionRequest#builder()}
     * </p>
     *
     * @param describeBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotVersionResponse describeBotVersion(Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotVersion(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     * @return Result of the DescribeCustomVocabularyMetadata operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomVocabularyMetadataResponse describeCustomVocabularyMetadata(
            DescribeCustomVocabularyMetadataRequest describeCustomVocabularyMetadataRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomVocabularyMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomVocabularyMetadataRequest#builder()}
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomVocabularyMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCustomVocabularyMetadata operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomVocabularyMetadataResponse describeCustomVocabularyMetadata(
            Consumer<DescribeCustomVocabularyMetadataRequest.Builder> describeCustomVocabularyMetadataRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeCustomVocabularyMetadata(DescribeCustomVocabularyMetadataRequest.builder()
                .applyMutation(describeCustomVocabularyMetadataRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     *
     * @param describeExportRequest
     * @return Result of the DescribeExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeExportRequest#builder()}
     * </p>
     *
     * @param describeExportRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExportRequest.Builder} to create a request.
     * @return Result of the DescribeExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExportResponse describeExport(Consumer<DescribeExportRequest.Builder> describeExportRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeExport(DescribeExportRequest.builder().applyMutation(describeExportRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     *
     * @param describeImportRequest
     * @return Result of the DescribeImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImportResponse describeImport(DescribeImportRequest describeImportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImportRequest#builder()}
     * </p>
     *
     * @param describeImportRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImportRequest.Builder} to create a request.
     * @return Result of the DescribeImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImportResponse describeImport(Consumer<DescribeImportRequest.Builder> describeImportRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeImport(DescribeImportRequest.builder().applyMutation(describeImportRequest).build());
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIntentResponse describeIntent(DescribeIntentRequest describeIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIntentRequest#builder()}
     * </p>
     *
     * @param describeIntentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIntentRequest.Builder} to create a request.
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIntentResponse describeIntent(Consumer<DescribeIntentRequest.Builder> describeIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeIntent(DescribeIntentRequest.builder().applyMutation(describeIntentRequest).build());
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSlotResponse describeSlot(DescribeSlotRequest describeSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSlotRequest#builder()}
     * </p>
     *
     * @param describeSlotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotRequest.Builder} to create a request.
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSlotResponse describeSlot(Consumer<DescribeSlotRequest.Builder> describeSlotRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeSlot(DescribeSlotRequest.builder().applyMutation(describeSlotRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlotTypeResponse describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSlotTypeRequest#builder()}
     * </p>
     *
     * @param describeSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotTypeRequest.Builder} to create a request.
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlotTypeResponse describeSlotType(Consumer<DescribeSlotTypeRequest.Builder> describeSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeSlotType(DescribeSlotTypeRequest.builder().applyMutation(describeSlotTypeRequest).build());
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAggregatedUtterancesRequest
     * @return Result of the ListAggregatedUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesResponse listAggregatedUtterances(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) throws ValidationException,
            PreconditionFailedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatedUtterancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAggregatedUtterancesRequest#builder()}
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAggregatedUtterancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAggregatedUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesResponse listAggregatedUtterances(
            Consumer<ListAggregatedUtterancesRequest.Builder> listAggregatedUtterancesRequest) throws ValidationException,
            PreconditionFailedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listAggregatedUtterances(ListAggregatedUtterancesRequest.builder().applyMutation(listAggregatedUtterancesRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client.listAggregatedUtterancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client
     *             .listAggregatedUtterancesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client.listAggregatedUtterancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesIterable listAggregatedUtterancesPaginator(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) throws ValidationException,
            PreconditionFailedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client.listAggregatedUtterancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client
     *             .listAggregatedUtterancesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesIterable responses = client.listAggregatedUtterancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatedUtterancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAggregatedUtterancesRequest#builder()}
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAggregatedUtterancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesIterable listAggregatedUtterancesPaginator(
            Consumer<ListAggregatedUtterancesRequest.Builder> listAggregatedUtterancesRequest) throws ValidationException,
            PreconditionFailedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listAggregatedUtterancesPaginator(ListAggregatedUtterancesRequest.builder()
                .applyMutation(listAggregatedUtterancesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesResponse listBotAliases(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesResponse listBotAliases(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotAliases(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client
     *             .listBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesIterable listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client
     *             .listBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesIterable listBotAliasesPaginator(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotAliasesPaginator(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesResponse listBotLocales(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesResponse listBotLocales(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotLocales(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client
     *             .listBotLocalesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesIterable listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client
     *             .listBotLocalesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesIterable listBotLocalesPaginator(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotLocalesPaginator(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return Result of the ListBotRecommendations operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsResponse listBotRecommendations(ListBotRecommendationsRequest listBotRecommendationsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBotRecommendationsRequest#builder()}
     * </p>
     *
     * @param listBotRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBotRecommendations operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsResponse listBotRecommendations(
            Consumer<ListBotRecommendationsRequest.Builder> listBotRecommendationsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBotRecommendations(ListBotRecommendationsRequest.builder().applyMutation(listBotRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client.listBotRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client
     *             .listBotRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client.listBotRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsIterable listBotRecommendationsPaginator(
            ListBotRecommendationsRequest listBotRecommendationsRequest) throws ThrottlingException, ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client.listBotRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client
     *             .listBotRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsIterable responses = client.listBotRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBotRecommendationsRequest#builder()}
     * </p>
     *
     * @param listBotRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsIterable listBotRecommendationsPaginator(
            Consumer<ListBotRecommendationsRequest.Builder> listBotRecommendationsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBotRecommendationsPaginator(ListBotRecommendationsRequest.builder()
                .applyMutation(listBotRecommendationsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsResponse listBotVersions(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsResponse listBotVersions(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotVersions(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client
     *             .listBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsIterable listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client
     *             .listBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsIterable listBotVersionsPaginator(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotVersionsPaginator(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsResponse listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsResponse listBuiltInIntents(Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBuiltInIntents(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client
     *             .listBuiltInIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsIterable listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client
     *             .listBuiltInIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsIterable listBuiltInIntentsPaginator(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInIntentsPaginator(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesResponse listBuiltInSlotTypes(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesResponse listBuiltInSlotTypes(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client
     *             .listBuiltInSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client
     *             .listBuiltInSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest)
                .build());
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return Result of the ListCustomVocabularyItems operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsResponse listCustomVocabularyItems(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomVocabularyItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomVocabularyItemsRequest#builder()}
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVocabularyItemsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCustomVocabularyItems operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsResponse listCustomVocabularyItems(
            Consumer<ListCustomVocabularyItemsRequest.Builder> listCustomVocabularyItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listCustomVocabularyItems(ListCustomVocabularyItemsRequest.builder()
                .applyMutation(listCustomVocabularyItemsRequest).build());
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client.listCustomVocabularyItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client
     *             .listCustomVocabularyItemsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client.listCustomVocabularyItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsIterable listCustomVocabularyItemsPaginator(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client.listCustomVocabularyItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client
     *             .listCustomVocabularyItemsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsIterable responses = client.listCustomVocabularyItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomVocabularyItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomVocabularyItemsRequest#builder()}
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVocabularyItemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsIterable listCustomVocabularyItemsPaginator(
            Consumer<ListCustomVocabularyItemsRequest.Builder> listCustomVocabularyItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listCustomVocabularyItemsPaginator(ListCustomVocabularyItemsRequest.builder()
                .applyMutation(listCustomVocabularyItemsRequest).build());
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     *
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request.
     * @return Result of the ListExports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsResponse listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request.
     * @return Result of the ListImports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsResponse listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsResponse listIntents(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsResponse listIntents(Consumer<ListIntentsRequest.Builder> listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listIntents(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     *
     * @param listIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsIterable listIntentsPaginator(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsIterable listIntentsPaginator(Consumer<ListIntentsRequest.Builder> listIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listIntentsPaginator(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return Result of the ListRecommendedIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsResponse listRecommendedIntents(ListRecommendedIntentsRequest listRecommendedIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedIntentsRequest#builder()}
     * </p>
     *
     * @param listRecommendedIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendedIntentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRecommendedIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsResponse listRecommendedIntents(
            Consumer<ListRecommendedIntentsRequest.Builder> listRecommendedIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listRecommendedIntents(ListRecommendedIntentsRequest.builder().applyMutation(listRecommendedIntentsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client.listRecommendedIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client
     *             .listRecommendedIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client.listRecommendedIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsIterable listRecommendedIntentsPaginator(
            ListRecommendedIntentsRequest listRecommendedIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client.listRecommendedIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client
     *             .listRecommendedIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsIterable responses = client.listRecommendedIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedIntentsRequest#builder()}
     * </p>
     *
     * @param listRecommendedIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendedIntentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsIterable listRecommendedIntentsPaginator(
            Consumer<ListRecommendedIntentsRequest.Builder> listRecommendedIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listRecommendedIntentsPaginator(ListRecommendedIntentsRequest.builder()
                .applyMutation(listRecommendedIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesResponse listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesResponse listSlotTypes(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listSlotTypes(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client
     *             .listSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesIterable listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client
     *             .listSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesIterable listSlotTypesPaginator(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listSlotTypesPaginator(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsResponse listSlots(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsResponse listSlots(Consumer<ListSlotsRequest.Builder> listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listSlots(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     *
     * @param listSlotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsIterable listSlotsPaginator(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsIterable listSlotsPaginator(Consumer<ListSlotsRequest.Builder> listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listSlotsPaginator(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     * @return Result of the SearchAssociatedTranscripts operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAssociatedTranscriptsResponse searchAssociatedTranscripts(
            SearchAssociatedTranscriptsRequest searchAssociatedTranscriptsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAssociatedTranscriptsRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAssociatedTranscriptsRequest#builder()}
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     *        A {@link Consumer} that will call methods on {@link SearchAssociatedTranscriptsRequest.Builder} to create
     *        a request.
     * @return Result of the SearchAssociatedTranscripts operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAssociatedTranscriptsResponse searchAssociatedTranscripts(
            Consumer<SearchAssociatedTranscriptsRequest.Builder> searchAssociatedTranscriptsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return searchAssociatedTranscripts(SearchAssociatedTranscriptsRequest.builder()
                .applyMutation(searchAssociatedTranscriptsRequest).build());
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     *
     * @param startBotRecommendationRequest
     * @return Result of the StartBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBotRecommendationResponse startBotRecommendation(StartBotRecommendationRequest startBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBotRecommendationRequest.Builder} avoiding the
     * need to create one manually via {@link StartBotRecommendationRequest#builder()}
     * </p>
     *
     * @param startBotRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link StartBotRecommendationRequest.Builder} to create a
     *        request.
     * @return Result of the StartBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBotRecommendationResponse startBotRecommendation(
            Consumer<StartBotRecommendationRequest.Builder> startBotRecommendationRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return startBotRecommendation(StartBotRecommendationRequest.builder().applyMutation(startBotRecommendationRequest)
                .build());
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     *
     * @param startImportRequest
     * @return Result of the StartImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportResponse startImport(StartImportRequest startImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on {@link StartImportRequest.Builder} to create a request.
     * @return Result of the StartImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportResponse startImport(Consumer<StartImportRequest.Builder> startImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     *
     * @param stopBotRecommendationRequest
     * @return Result of the StopBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBotRecommendationResponse stopBotRecommendation(StopBotRecommendationRequest stopBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBotRecommendationRequest.Builder} avoiding the
     * need to create one manually via {@link StopBotRecommendationRequest#builder()}
     * </p>
     *
     * @param stopBotRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link StopBotRecommendationRequest.Builder} to create a
     *        request.
     * @return Result of the StopBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBotRecommendationResponse stopBotRecommendation(
            Consumer<StopBotRecommendationRequest.Builder> stopBotRecommendationRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return stopBotRecommendation(StopBotRecommendationRequest.builder().applyMutation(stopBotRecommendationRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotRequest#builder()}
     * </p>
     *
     * @param updateBotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotRequest.Builder} to create a request.
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBotResponse updateBot(Consumer<UpdateBotRequest.Builder> updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBot(UpdateBotRequest.builder().applyMutation(updateBotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotAliasResponse updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotAliasRequest#builder()}
     * </p>
     *
     * @param updateBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotAliasRequest.Builder} to create a request.
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotAliasResponse updateBotAlias(Consumer<UpdateBotAliasRequest.Builder> updateBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBotAlias(UpdateBotAliasRequest.builder().applyMutation(updateBotAliasRequest).build());
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotLocaleResponse updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBotLocaleRequest#builder()}
     * </p>
     *
     * @param updateBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotLocaleRequest.Builder} to create a request.
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotLocaleResponse updateBotLocale(Consumer<UpdateBotLocaleRequest.Builder> updateBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBotLocale(UpdateBotLocaleRequest.builder().applyMutation(updateBotLocaleRequest).build());
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     *
     * @param updateBotRecommendationRequest
     * @return Result of the UpdateBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBotRecommendationResponse updateBotRecommendation(UpdateBotRecommendationRequest updateBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRecommendationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateBotRecommendationRequest#builder()}
     * </p>
     *
     * @param updateBotRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotRecommendationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBotRecommendationResponse updateBotRecommendation(
            Consumer<UpdateBotRecommendationRequest.Builder> updateBotRecommendationRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBotRecommendation(UpdateBotRecommendationRequest.builder().applyMutation(updateBotRecommendationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     *
     * @param updateExportRequest
     * @return Result of the UpdateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExportResponse updateExport(UpdateExportRequest updateExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExportRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateExportRequest#builder()}
     * </p>
     *
     * @param updateExportRequest
     *        A {@link Consumer} that will call methods on {@link UpdateExportRequest.Builder} to create a request.
     * @return Result of the UpdateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExportResponse updateExport(Consumer<UpdateExportRequest.Builder> updateExportRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateExport(UpdateExportRequest.builder().applyMutation(updateExportRequest).build());
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateIntentResponse updateIntent(UpdateIntentRequest updateIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIntentRequest#builder()}
     * </p>
     *
     * @param updateIntentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntentRequest.Builder} to create a request.
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateIntentResponse updateIntent(Consumer<UpdateIntentRequest.Builder> updateIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateIntent(UpdateIntentRequest.builder().applyMutation(updateIntentRequest).build());
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     *
     * @param updateResourcePolicyRequest
     * @return Result of the UpdateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourcePolicyResponse updateResourcePolicy(UpdateResourcePolicyRequest updateResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourcePolicyRequest#builder()}
     * </p>
     *
     * @param updateResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourcePolicyResponse updateResourcePolicy(
            Consumer<UpdateResourcePolicyRequest.Builder> updateResourcePolicyRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, PreconditionFailedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateResourcePolicy(UpdateResourcePolicyRequest.builder().applyMutation(updateResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSlotResponse updateSlot(UpdateSlotRequest updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotRequest#builder()}
     * </p>
     *
     * @param updateSlotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotRequest.Builder} to create a request.
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSlotResponse updateSlot(Consumer<UpdateSlotRequest.Builder> updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateSlot(UpdateSlotRequest.builder().applyMutation(updateSlotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSlotTypeResponse updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotTypeRequest#builder()}
     * </p>
     *
     * @param updateSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotTypeRequest.Builder} to create a request.
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSlotTypeResponse updateSlotType(Consumer<UpdateSlotTypeRequest.Builder> updateSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateSlotType(UpdateSlotTypeRequest.builder().applyMutation(updateSlotTypeRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link LexModelsV2Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link LexModelsV2Waiter}
     */
    default LexModelsV2Waiter waiter() {
        throw new UnsupportedOperationException();
    }
}
