/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the results of the analysis of a turn in the test set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetTurnResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetTurnResult.Builder, TestSetTurnResult> {
    private static final SdkField<AgentTurnResult> AGENT_FIELD = SdkField.<AgentTurnResult> builder(MarshallingType.SDK_POJO)
            .memberName("agent").getter(getter(TestSetTurnResult::agent)).setter(setter(Builder::agent))
            .constructor(AgentTurnResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agent").build()).build();

    private static final SdkField<UserTurnResult> USER_FIELD = SdkField.<UserTurnResult> builder(MarshallingType.SDK_POJO)
            .memberName("user").getter(getter(TestSetTurnResult::user)).setter(setter(Builder::user))
            .constructor(UserTurnResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD, USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentTurnResult agent;

    private final UserTurnResult user;

    private TestSetTurnResult(BuilderImpl builder) {
        this.agent = builder.agent;
        this.user = builder.user;
    }

    /**
     * <p>
     * Contains information about the agent messages in the turn.
     * </p>
     * 
     * @return Contains information about the agent messages in the turn.
     */
    public final AgentTurnResult agent() {
        return agent;
    }

    /**
     * <p>
     * Contains information about the user messages in the turn.
     * </p>
     * 
     * @return Contains information about the user messages in the turn.
     */
    public final UserTurnResult user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agent());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetTurnResult)) {
            return false;
        }
        TestSetTurnResult other = (TestSetTurnResult) obj;
        return Objects.equals(agent(), other.agent()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetTurnResult").add("Agent", agent()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agent":
            return Optional.ofNullable(clazz.cast(agent()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSetTurnResult, T> g) {
        return obj -> g.apply((TestSetTurnResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetTurnResult> {
        /**
         * <p>
         * Contains information about the agent messages in the turn.
         * </p>
         * 
         * @param agent
         *        Contains information about the agent messages in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agent(AgentTurnResult agent);

        /**
         * <p>
         * Contains information about the agent messages in the turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentTurnResult.Builder} avoiding the
         * need to create one manually via {@link AgentTurnResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentTurnResult.Builder#build()} is called immediately and its
         * result is passed to {@link #agent(AgentTurnResult)}.
         * 
         * @param agent
         *        a consumer that will call methods on {@link AgentTurnResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agent(AgentTurnResult)
         */
        default Builder agent(Consumer<AgentTurnResult.Builder> agent) {
            return agent(AgentTurnResult.builder().applyMutation(agent).build());
        }

        /**
         * <p>
         * Contains information about the user messages in the turn.
         * </p>
         * 
         * @param user
         *        Contains information about the user messages in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserTurnResult user);

        /**
         * <p>
         * Contains information about the user messages in the turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnResult.Builder} avoiding the need
         * to create one manually via {@link UserTurnResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnResult.Builder#build()} is called immediately and its
         * result is passed to {@link #user(UserTurnResult)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserTurnResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserTurnResult)
         */
        default Builder user(Consumer<UserTurnResult.Builder> user) {
            return user(UserTurnResult.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentTurnResult agent;

        private UserTurnResult user;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetTurnResult model) {
            agent(model.agent);
            user(model.user);
        }

        public final AgentTurnResult.Builder getAgent() {
            return agent != null ? agent.toBuilder() : null;
        }

        public final void setAgent(AgentTurnResult.BuilderImpl agent) {
            this.agent = agent != null ? agent.build() : null;
        }

        @Override
        public final Builder agent(AgentTurnResult agent) {
            this.agent = agent;
            return this;
        }

        public final UserTurnResult.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(UserTurnResult.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(UserTurnResult user) {
            this.user = user;
            return this;
        }

        @Override
        public TestSetTurnResult build() {
            return new TestSetTurnResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
