/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatusCountMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotResolutionTestResultItemCounts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotResolutionTestResultItemCounts> {
    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResultCount").getter(SlotResolutionTestResultItemCounts.getter(SlotResolutionTestResultItemCounts::totalResultCount)).setter(SlotResolutionTestResultItemCounts.setter(Builder::totalResultCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()}).build();
    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("speechTranscriptionResultCounts").getter(SlotResolutionTestResultItemCounts.getter(SlotResolutionTestResultItemCounts::speechTranscriptionResultCountsAsStrings)).setter(SlotResolutionTestResultItemCounts.setter(Builder::speechTranscriptionResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> SLOT_MATCH_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slotMatchResultCounts").getter(SlotResolutionTestResultItemCounts.getter(SlotResolutionTestResultItemCounts::slotMatchResultCountsAsStrings)).setter(SlotResolutionTestResultItemCounts.setter(Builder::slotMatchResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotMatchResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RESULT_COUNT_FIELD, SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, SLOT_MATCH_RESULT_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalResultCount;
    private final Map<String, Integer> speechTranscriptionResultCounts;
    private final Map<String, Integer> slotMatchResultCounts;

    private SlotResolutionTestResultItemCounts(BuilderImpl builder) {
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.slotMatchResultCounts = builder.slotMatchResultCounts;
    }

    public final Integer totalResultCount() {
        return this.totalResultCount;
    }

    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.speechTranscriptionResultCounts);
    }

    public final boolean hasSpeechTranscriptionResultCounts() {
        return this.speechTranscriptionResultCounts != null && !(this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return this.speechTranscriptionResultCounts;
    }

    public final Map<TestResultMatchStatus, Integer> slotMatchResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.slotMatchResultCounts);
    }

    public final boolean hasSlotMatchResultCounts() {
        return this.slotMatchResultCounts != null && !(this.slotMatchResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> slotMatchResultCountsAsStrings() {
        return this.slotMatchResultCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResultCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotMatchResultCounts() ? this.slotMatchResultCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotResolutionTestResultItemCounts)) {
            return false;
        }
        SlotResolutionTestResultItemCounts other = (SlotResolutionTestResultItemCounts)obj;
        return Objects.equals(this.totalResultCount(), other.totalResultCount()) && this.hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts() && Objects.equals(this.speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings()) && this.hasSlotMatchResultCounts() == other.hasSlotMatchResultCounts() && Objects.equals(this.slotMatchResultCountsAsStrings(), other.slotMatchResultCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SlotResolutionTestResultItemCounts").add("TotalResultCount", (Object)this.totalResultCount()).add("SpeechTranscriptionResultCounts", this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null).add("SlotMatchResultCounts", this.hasSlotMatchResultCounts() ? this.slotMatchResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalResultCount": {
                return Optional.ofNullable(clazz.cast(this.totalResultCount()));
            }
            case "speechTranscriptionResultCounts": {
                return Optional.ofNullable(clazz.cast(this.speechTranscriptionResultCountsAsStrings()));
            }
            case "slotMatchResultCounts": {
                return Optional.ofNullable(clazz.cast(this.slotMatchResultCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotResolutionTestResultItemCounts, T> g) {
        return obj -> g.apply((SlotResolutionTestResultItemCounts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalResultCount;
        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> slotMatchResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotResolutionTestResultItemCounts model) {
            this.totalResultCount(model.totalResultCount);
            this.speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            this.slotMatchResultCountsWithStrings(model.slotMatchResultCounts);
        }

        public final Integer getTotalResultCount() {
            return this.totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getSlotMatchResultCounts() {
            if (this.slotMatchResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.slotMatchResultCounts;
        }

        public final void setSlotMatchResultCounts(Map<String, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(slotMatchResultCounts);
        }

        @Override
        public final Builder slotMatchResultCountsWithStrings(Map<String, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(slotMatchResultCounts);
            return this;
        }

        @Override
        public final Builder slotMatchResultCounts(Map<TestResultMatchStatus, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(slotMatchResultCounts);
            return this;
        }

        public SlotResolutionTestResultItemCounts build() {
            return new SlotResolutionTestResultItemCounts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotResolutionTestResultItemCounts> {
        public Builder totalResultCount(Integer var1);

        public Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> var1);

        public Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> var1);

        public Builder slotMatchResultCountsWithStrings(Map<String, Integer> var1);

        public Builder slotMatchResultCounts(Map<TestResultMatchStatus, Integer> var1);
    }
}

