/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentMetricsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentStageMetricsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionAnalyticsDataPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionMetricsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionResultItemsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetRecordsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceAnalyticsDataPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceMetricsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2AsyncWaiter;

/**
 * Service client for accessing Lex Models V2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LexModelsV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "lex";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "models-v2-lex";

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchCreateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateCustomVocabularyItemResponse> batchCreateCustomVocabularyItem(
            BatchCreateCustomVocabularyItemRequest batchCreateCustomVocabularyItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateCustomVocabularyItemResponse> batchCreateCustomVocabularyItem(
            Consumer<BatchCreateCustomVocabularyItemRequest.Builder> batchCreateCustomVocabularyItemRequest) {
        return batchCreateCustomVocabularyItem(BatchCreateCustomVocabularyItemRequest.builder()
                .applyMutation(batchCreateCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchDeleteCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteCustomVocabularyItemResponse> batchDeleteCustomVocabularyItem(
            BatchDeleteCustomVocabularyItemRequest batchDeleteCustomVocabularyItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteCustomVocabularyItemResponse> batchDeleteCustomVocabularyItem(
            Consumer<BatchDeleteCustomVocabularyItemRequest.Builder> batchDeleteCustomVocabularyItemRequest) {
        return batchDeleteCustomVocabularyItem(BatchDeleteCustomVocabularyItemRequest.builder()
                .applyMutation(batchDeleteCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchUpdateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateCustomVocabularyItemResponse> batchUpdateCustomVocabularyItem(
            BatchUpdateCustomVocabularyItemRequest batchUpdateCustomVocabularyItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateCustomVocabularyItemRequest.Builder}
     * avoiding the need to create one manually via {@link BatchUpdateCustomVocabularyItemRequest#builder()}
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateCustomVocabularyItemResponse> batchUpdateCustomVocabularyItem(
            Consumer<BatchUpdateCustomVocabularyItemRequest.Builder> batchUpdateCustomVocabularyItemRequest) {
        return batchUpdateCustomVocabularyItem(BatchUpdateCustomVocabularyItemRequest.builder()
                .applyMutation(batchUpdateCustomVocabularyItemRequest).build());
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return A Java Future containing the result of the BuildBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BuildBotLocaleResponse> buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildBotLocaleRequest.Builder} avoiding the need to
     * create one manually via {@link BuildBotLocaleRequest#builder()}
     * </p>
     *
     * @param buildBotLocaleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BuildBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BuildBotLocaleResponse> buildBotLocale(Consumer<BuildBotLocaleRequest.Builder> buildBotLocaleRequest) {
        return buildBotLocale(BuildBotLocaleRequest.builder().applyMutation(buildBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotRequest#builder()}
     * </p>
     *
     * @param createBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(Consumer<CreateBotRequest.Builder> createBotRequest) {
        return createBot(CreateBotRequest.builder().applyMutation(createBotRequest).build());
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return A Java Future containing the result of the CreateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotAliasResponse> createBotAlias(CreateBotAliasRequest createBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotAliasRequest#builder()}
     * </p>
     *
     * @param createBotAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotAliasResponse> createBotAlias(Consumer<CreateBotAliasRequest.Builder> createBotAliasRequest) {
        return createBotAlias(CreateBotAliasRequest.builder().applyMutation(createBotAliasRequest).build());
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return A Java Future containing the result of the CreateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotLocaleResponse> createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotLocaleRequest#builder()}
     * </p>
     *
     * @param createBotLocaleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotLocaleResponse> createBotLocale(
            Consumer<CreateBotLocaleRequest.Builder> createBotLocaleRequest) {
        return createBotLocale(CreateBotLocaleRequest.builder().applyMutation(createBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBotVersionResponse> createBotVersion(CreateBotVersionRequest createBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotVersionRequest#builder()}
     * </p>
     *
     * @param createBotVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBotVersionResponse> createBotVersion(
            Consumer<CreateBotVersionRequest.Builder> createBotVersionRequest) {
        return createBotVersion(CreateBotVersionRequest.builder().applyMutation(createBotVersionRequest).build());
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     *
     * @param createExportRequest
     * @return A Java Future containing the result of the CreateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExportResponse> createExport(CreateExportRequest createExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportRequest.Builder} avoiding the need to
     * create one manually via {@link CreateExportRequest#builder()}
     * </p>
     *
     * @param createExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExportResponse> createExport(Consumer<CreateExportRequest.Builder> createExportRequest) {
        return createExport(CreateExportRequest.builder().applyMutation(createExportRequest).build());
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return A Java Future containing the result of the CreateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateIntentResponse> createIntent(CreateIntentRequest createIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIntentRequest#builder()}
     * </p>
     *
     * @param createIntentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateIntentResponse> createIntent(Consumer<CreateIntentRequest.Builder> createIntentRequest) {
        return createIntent(CreateIntentRequest.builder().applyMutation(createIntentRequest).build());
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     *
     * @param createResourcePolicyRequest
     * @return A Java Future containing the result of the CreateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourcePolicyResponse> createResourcePolicy(
            CreateResourcePolicyRequest createResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourcePolicyRequest#builder()}
     * </p>
     *
     * @param createResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourcePolicyResponse> createResourcePolicy(
            Consumer<CreateResourcePolicyRequest.Builder> createResourcePolicyRequest) {
        return createResourcePolicy(CreateResourcePolicyRequest.builder().applyMutation(createResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     * @return A Java Future containing the result of the CreateResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourcePolicyStatementResponse> createResourcePolicyStatement(
            CreateResourcePolicyStatementRequest createResourcePolicyStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourcePolicyStatementRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourcePolicyStatementRequest#builder()}
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourcePolicyStatementResponse> createResourcePolicyStatement(
            Consumer<CreateResourcePolicyStatementRequest.Builder> createResourcePolicyStatementRequest) {
        return createResourcePolicyStatement(CreateResourcePolicyStatementRequest.builder()
                .applyMutation(createResourcePolicyStatementRequest).build());
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return A Java Future containing the result of the CreateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSlotResponse> createSlot(CreateSlotRequest createSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotRequest#builder()}
     * </p>
     *
     * @param createSlotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSlotResponse> createSlot(Consumer<CreateSlotRequest.Builder> createSlotRequest) {
        return createSlot(CreateSlotRequest.builder().applyMutation(createSlotRequest).build());
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return A Java Future containing the result of the CreateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSlotTypeResponse> createSlotType(CreateSlotTypeRequest createSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotTypeRequest#builder()}
     * </p>
     *
     * @param createSlotTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSlotTypeResponse> createSlotType(Consumer<CreateSlotTypeRequest.Builder> createSlotTypeRequest) {
        return createSlotType(CreateSlotTypeRequest.builder().applyMutation(createSlotTypeRequest).build());
    }

    /**
     * <p>
     * Create a report that describes the differences between the bot and the test set.
     * </p>
     *
     * @param createTestSetDiscrepancyReportRequest
     * @return A Java Future containing the result of the CreateTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestSetDiscrepancyReportResponse> createTestSetDiscrepancyReport(
            CreateTestSetDiscrepancyReportRequest createTestSetDiscrepancyReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a report that describes the differences between the bot and the test set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestSetDiscrepancyReportRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTestSetDiscrepancyReportRequest#builder()}
     * </p>
     *
     * @param createTestSetDiscrepancyReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestSetDiscrepancyReportResponse> createTestSetDiscrepancyReport(
            Consumer<CreateTestSetDiscrepancyReportRequest.Builder> createTestSetDiscrepancyReportRequest) {
        return createTestSetDiscrepancyReport(CreateTestSetDiscrepancyReportRequest.builder()
                .applyMutation(createTestSetDiscrepancyReportRequest).build());
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return A Java Future containing the result of the CreateUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUploadUrlResponse> createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadUrlRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUploadUrlRequest#builder()}
     * </p>
     *
     * @param createUploadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUploadUrlResponse> createUploadUrl(
            Consumer<CreateUploadUrlRequest.Builder> createUploadUrlRequest) {
        return createUploadUrl(CreateUploadUrlRequest.builder().applyMutation(createUploadUrlRequest).build());
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotRequest#builder()}
     * </p>
     *
     * @param deleteBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBotResponse> deleteBot(Consumer<DeleteBotRequest.Builder> deleteBotRequest) {
        return deleteBot(DeleteBotRequest.builder().applyMutation(deleteBotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotAliasRequest#builder()}
     * </p>
     *
     * @param deleteBotAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(Consumer<DeleteBotAliasRequest.Builder> deleteBotAliasRequest) {
        return deleteBotAlias(DeleteBotAliasRequest.builder().applyMutation(deleteBotAliasRequest).build());
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return A Java Future containing the result of the DeleteBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotLocaleResponse> deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotLocaleRequest#builder()}
     * </p>
     *
     * @param deleteBotLocaleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotLocaleResponse> deleteBotLocale(
            Consumer<DeleteBotLocaleRequest.Builder> deleteBotLocaleRequest) {
        return deleteBotLocale(DeleteBotLocaleRequest.builder().applyMutation(deleteBotLocaleRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotVersionRequest#builder()}
     * </p>
     *
     * @param deleteBotVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(
            Consumer<DeleteBotVersionRequest.Builder> deleteBotVersionRequest) {
        return deleteBotVersion(DeleteBotVersionRequest.builder().applyMutation(deleteBotVersionRequest).build());
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     * @return A Java Future containing the result of the DeleteCustomVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVocabularyResponse> deleteCustomVocabulary(
            DeleteCustomVocabularyRequest deleteCustomVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCustomVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVocabularyResponse> deleteCustomVocabulary(
            Consumer<DeleteCustomVocabularyRequest.Builder> deleteCustomVocabularyRequest) {
        return deleteCustomVocabulary(DeleteCustomVocabularyRequest.builder().applyMutation(deleteCustomVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     *
     * @param deleteExportRequest
     * @return A Java Future containing the result of the DeleteExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExportResponse> deleteExport(DeleteExportRequest deleteExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExportRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteExportRequest#builder()}
     * </p>
     *
     * @param deleteExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExportResponse> deleteExport(Consumer<DeleteExportRequest.Builder> deleteExportRequest) {
        return deleteExport(DeleteExportRequest.builder().applyMutation(deleteExportRequest).build());
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     *
     * @param deleteImportRequest
     * @return A Java Future containing the result of the DeleteImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImportResponse> deleteImport(DeleteImportRequest deleteImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImportRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImportRequest#builder()}
     * </p>
     *
     * @param deleteImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImportResponse> deleteImport(Consumer<DeleteImportRequest.Builder> deleteImportRequest) {
        return deleteImport(DeleteImportRequest.builder().applyMutation(deleteImportRequest).build());
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteIntentResponse> deleteIntent(DeleteIntentRequest deleteIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIntentRequest#builder()}
     * </p>
     *
     * @param deleteIntentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteIntentResponse> deleteIntent(Consumer<DeleteIntentRequest.Builder> deleteIntentRequest) {
        return deleteIntent(DeleteIntentRequest.builder().applyMutation(deleteIntentRequest).build());
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     * @return A Java Future containing the result of the DeleteResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyStatementResponse> deleteResourcePolicyStatement(
            DeleteResourcePolicyStatementRequest deleteResourcePolicyStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyStatementRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourcePolicyStatementRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyStatementResponse> deleteResourcePolicyStatement(
            Consumer<DeleteResourcePolicyStatementRequest.Builder> deleteResourcePolicyStatementRequest) {
        return deleteResourcePolicyStatement(DeleteResourcePolicyStatementRequest.builder()
                .applyMutation(deleteResourcePolicyStatementRequest).build());
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return A Java Future containing the result of the DeleteSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSlotResponse> deleteSlot(DeleteSlotRequest deleteSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotRequest#builder()}
     * </p>
     *
     * @param deleteSlotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSlotResponse> deleteSlot(Consumer<DeleteSlotRequest.Builder> deleteSlotRequest) {
        return deleteSlot(DeleteSlotRequest.builder().applyMutation(deleteSlotRequest).build());
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotTypeRequest#builder()}
     * </p>
     *
     * @param deleteSlotTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(Consumer<DeleteSlotTypeRequest.Builder> deleteSlotTypeRequest) {
        return deleteSlotType(DeleteSlotTypeRequest.builder().applyMutation(deleteSlotTypeRequest).build());
    }

    /**
     * <p>
     * The action to delete the selected test set.
     * </p>
     *
     * @param deleteTestSetRequest
     * @return A Java Future containing the result of the DeleteTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTestSetResponse> deleteTestSet(DeleteTestSetRequest deleteTestSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The action to delete the selected test set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTestSetRequest#builder()}
     * </p>
     *
     * @param deleteTestSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTestSetResponse> deleteTestSet(Consumer<DeleteTestSetRequest.Builder> deleteTestSetRequest) {
        return deleteTestSet(DeleteTestSetRequest.builder().applyMutation(deleteTestSetRequest).build());
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return A Java Future containing the result of the DeleteUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUtterancesResponse> deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUtterancesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUtterancesRequest#builder()}
     * </p>
     *
     * @param deleteUtterancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUtterancesResponse> deleteUtterances(
            Consumer<DeleteUtterancesRequest.Builder> deleteUtterancesRequest) {
        return deleteUtterances(DeleteUtterancesRequest.builder().applyMutation(deleteUtterancesRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return A Java Future containing the result of the DescribeBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBotResponse> describeBot(DescribeBotRequest describeBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBotRequest#builder()}
     * </p>
     *
     * @param describeBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBotResponse> describeBot(Consumer<DescribeBotRequest.Builder> describeBotRequest) {
        return describeBot(DescribeBotRequest.builder().applyMutation(describeBotRequest).build());
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return A Java Future containing the result of the DescribeBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotAliasResponse> describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotAliasRequest#builder()}
     * </p>
     *
     * @param describeBotAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotAliasResponse> describeBotAlias(
            Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest) {
        return describeBotAlias(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build());
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return A Java Future containing the result of the DescribeBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotLocaleResponse> describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotLocaleRequest#builder()}
     * </p>
     *
     * @param describeBotLocaleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotLocaleResponse> describeBotLocale(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest) {
        return describeBotLocale(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     *
     * @param describeBotRecommendationRequest
     * @return A Java Future containing the result of the DescribeBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotRecommendationResponse> describeBotRecommendation(
            DescribeBotRecommendationRequest describeBotRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRecommendationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBotRecommendationRequest#builder()}
     * </p>
     *
     * @param describeBotRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotRecommendationResponse> describeBotRecommendation(
            Consumer<DescribeBotRecommendationRequest.Builder> describeBotRecommendationRequest) {
        return describeBotRecommendation(DescribeBotRecommendationRequest.builder()
                .applyMutation(describeBotRecommendationRequest).build());
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return A Java Future containing the result of the DescribeBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotVersionResponse> describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBotVersionRequest#builder()}
     * </p>
     *
     * @param describeBotVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotVersionResponse> describeBotVersion(
            Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest) {
        return describeBotVersion(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     * @return A Java Future containing the result of the DescribeCustomVocabularyMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomVocabularyMetadataResponse> describeCustomVocabularyMetadata(
            DescribeCustomVocabularyMetadataRequest describeCustomVocabularyMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomVocabularyMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomVocabularyMetadataRequest#builder()}
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeCustomVocabularyMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomVocabularyMetadataResponse> describeCustomVocabularyMetadata(
            Consumer<DescribeCustomVocabularyMetadataRequest.Builder> describeCustomVocabularyMetadataRequest) {
        return describeCustomVocabularyMetadata(DescribeCustomVocabularyMetadataRequest.builder()
                .applyMutation(describeCustomVocabularyMetadataRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     *
     * @param describeExportRequest
     * @return A Java Future containing the result of the DescribeExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExportResponse> describeExport(DescribeExportRequest describeExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeExportRequest#builder()}
     * </p>
     *
     * @param describeExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExportResponse> describeExport(Consumer<DescribeExportRequest.Builder> describeExportRequest) {
        return describeExport(DescribeExportRequest.builder().applyMutation(describeExportRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     *
     * @param describeImportRequest
     * @return A Java Future containing the result of the DescribeImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImportResponse> describeImport(DescribeImportRequest describeImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImportRequest#builder()}
     * </p>
     *
     * @param describeImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImportResponse> describeImport(Consumer<DescribeImportRequest.Builder> describeImportRequest) {
        return describeImport(DescribeImportRequest.builder().applyMutation(describeImportRequest).build());
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return A Java Future containing the result of the DescribeIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIntentResponse> describeIntent(DescribeIntentRequest describeIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIntentRequest#builder()}
     * </p>
     *
     * @param describeIntentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIntentResponse> describeIntent(Consumer<DescribeIntentRequest.Builder> describeIntentRequest) {
        return describeIntent(DescribeIntentRequest.builder().applyMutation(describeIntentRequest).build());
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return A Java Future containing the result of the DescribeSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSlotResponse> describeSlot(DescribeSlotRequest describeSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSlotRequest#builder()}
     * </p>
     *
     * @param describeSlotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSlotResponse> describeSlot(Consumer<DescribeSlotRequest.Builder> describeSlotRequest) {
        return describeSlot(DescribeSlotRequest.builder().applyMutation(describeSlotRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return A Java Future containing the result of the DescribeSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlotTypeResponse> describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSlotTypeRequest#builder()}
     * </p>
     *
     * @param describeSlotTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlotTypeResponse> describeSlotType(
            Consumer<DescribeSlotTypeRequest.Builder> describeSlotTypeRequest) {
        return describeSlotType(DescribeSlotTypeRequest.builder().applyMutation(describeSlotTypeRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about the test execution.
     * </p>
     *
     * @param describeTestExecutionRequest
     * @return A Java Future containing the result of the DescribeTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestExecutionResponse> describeTestExecution(
            DescribeTestExecutionRequest describeTestExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about the test execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTestExecutionRequest#builder()}
     * </p>
     *
     * @param describeTestExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestExecutionResponse> describeTestExecution(
            Consumer<DescribeTestExecutionRequest.Builder> describeTestExecutionRequest) {
        return describeTestExecution(DescribeTestExecutionRequest.builder().applyMutation(describeTestExecutionRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about the test set.
     * </p>
     *
     * @param describeTestSetRequest
     * @return A Java Future containing the result of the DescribeTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetResponse> describeTestSet(DescribeTestSetRequest describeTestSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about the test set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTestSetRequest#builder()}
     * </p>
     *
     * @param describeTestSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetResponse> describeTestSet(
            Consumer<DescribeTestSetRequest.Builder> describeTestSetRequest) {
        return describeTestSet(DescribeTestSetRequest.builder().applyMutation(describeTestSetRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about the test set discrepancy report.
     * </p>
     *
     * @param describeTestSetDiscrepancyReportRequest
     * @return A Java Future containing the result of the DescribeTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetDiscrepancyReportResponse> describeTestSetDiscrepancyReport(
            DescribeTestSetDiscrepancyReportRequest describeTestSetDiscrepancyReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about the test set discrepancy report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestSetDiscrepancyReportRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTestSetDiscrepancyReportRequest#builder()}
     * </p>
     *
     * @param describeTestSetDiscrepancyReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetDiscrepancyReportResponse> describeTestSetDiscrepancyReport(
            Consumer<DescribeTestSetDiscrepancyReportRequest.Builder> describeTestSetDiscrepancyReportRequest) {
        return describeTestSetDiscrepancyReport(DescribeTestSetDiscrepancyReportRequest.builder()
                .applyMutation(describeTestSetDiscrepancyReportRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about the test set generation.
     * </p>
     *
     * @param describeTestSetGenerationRequest
     * @return A Java Future containing the result of the DescribeTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetGenerationResponse> describeTestSetGeneration(
            DescribeTestSetGenerationRequest describeTestSetGenerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about the test set generation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestSetGenerationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTestSetGenerationRequest#builder()}
     * </p>
     *
     * @param describeTestSetGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTestSetGenerationResponse> describeTestSetGeneration(
            Consumer<DescribeTestSetGenerationRequest.Builder> describeTestSetGenerationRequest) {
        return describeTestSetGeneration(DescribeTestSetGenerationRequest.builder()
                .applyMutation(describeTestSetGenerationRequest).build());
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     * </p>
     *
     * @param getTestExecutionArtifactsUrlRequest
     * @return A Java Future containing the result of the GetTestExecutionArtifactsUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.GetTestExecutionArtifactsUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTestExecutionArtifactsUrlResponse> getTestExecutionArtifactsUrl(
            GetTestExecutionArtifactsUrlRequest getTestExecutionArtifactsUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestExecutionArtifactsUrlRequest.Builder}
     * avoiding the need to create one manually via {@link GetTestExecutionArtifactsUrlRequest#builder()}
     * </p>
     *
     * @param getTestExecutionArtifactsUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTestExecutionArtifactsUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.GetTestExecutionArtifactsUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTestExecutionArtifactsUrlResponse> getTestExecutionArtifactsUrl(
            Consumer<GetTestExecutionArtifactsUrlRequest.Builder> getTestExecutionArtifactsUrlRequest) {
        return getTestExecutionArtifactsUrl(GetTestExecutionArtifactsUrlRequest.builder()
                .applyMutation(getTestExecutionArtifactsUrlRequest).build());
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAggregatedUtterancesRequest
     * @return A Java Future containing the result of the ListAggregatedUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAggregatedUtterancesResponse> listAggregatedUtterances(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatedUtterancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAggregatedUtterancesRequest#builder()}
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAggregatedUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAggregatedUtterancesResponse> listAggregatedUtterances(
            Consumer<ListAggregatedUtterancesRequest.Builder> listAggregatedUtterancesRequest) {
        return listAggregatedUtterances(ListAggregatedUtterancesRequest.builder().applyMutation(listAggregatedUtterancesRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesPublisher publisher = client.listAggregatedUtterancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesPublisher publisher = client.listAggregatedUtterancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesPublisher listAggregatedUtterancesPaginator(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) {
        return new ListAggregatedUtterancesPublisher(this, listAggregatedUtterancesRequest);
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesPublisher publisher = client.listAggregatedUtterancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListAggregatedUtterancesPublisher publisher = client.listAggregatedUtterancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatedUtterances(software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatedUtterancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAggregatedUtterancesRequest#builder()}
     * </p>
     *
     * @param listAggregatedUtterancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregatedUtterancesPublisher listAggregatedUtterancesPaginator(
            Consumer<ListAggregatedUtterancesRequest.Builder> listAggregatedUtterancesRequest) {
        return listAggregatedUtterancesPaginator(ListAggregatedUtterancesRequest.builder()
                .applyMutation(listAggregatedUtterancesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A Java Future containing the result of the ListBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotAliasesResponse> listBotAliases(ListBotAliasesRequest listBotAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotAliasesResponse> listBotAliases(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest) {
        return listBotAliases(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesPublisher listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest) {
        return new ListBotAliasesPublisher(this, listBotAliasesRequest);
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesPublisher listBotAliasesPaginator(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest) {
        return listBotAliasesPaginator(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A Java Future containing the result of the ListBotLocales operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotLocalesResponse> listBotLocales(ListBotLocalesRequest listBotLocalesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBotLocales operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotLocalesResponse> listBotLocales(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest) {
        return listBotLocales(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesPublisher listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest) {
        return new ListBotLocalesPublisher(this, listBotLocalesRequest);
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesPublisher listBotLocalesPaginator(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest) {
        return listBotLocalesPaginator(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return A Java Future containing the result of the ListBotRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBotRecommendationsResponse> listBotRecommendations(
            ListBotRecommendationsRequest listBotRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBotRecommendationsRequest#builder()}
     * </p>
     *
     * @param listBotRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListBotRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBotRecommendationsResponse> listBotRecommendations(
            Consumer<ListBotRecommendationsRequest.Builder> listBotRecommendationsRequest) {
        return listBotRecommendations(ListBotRecommendationsRequest.builder().applyMutation(listBotRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsPublisher publisher = client.listBotRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsPublisher publisher = client.listBotRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsPublisher listBotRecommendationsPaginator(
            ListBotRecommendationsRequest listBotRecommendationsRequest) {
        return new ListBotRecommendationsPublisher(this, listBotRecommendationsRequest);
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsPublisher publisher = client.listBotRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotRecommendationsPublisher publisher = client.listBotRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotRecommendations(software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBotRecommendationsRequest#builder()}
     * </p>
     *
     * @param listBotRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBotRecommendationsPublisher listBotRecommendationsPaginator(
            Consumer<ListBotRecommendationsRequest.Builder> listBotRecommendationsRequest) {
        return listBotRecommendationsPaginator(ListBotRecommendationsRequest.builder()
                .applyMutation(listBotRecommendationsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A Java Future containing the result of the ListBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotVersionsResponse> listBotVersions(ListBotVersionsRequest listBotVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotVersionsResponse> listBotVersions(
            Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest) {
        return listBotVersions(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsPublisher listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest) {
        return new ListBotVersionsPublisher(this, listBotVersionsRequest);
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsPublisher listBotVersionsPaginator(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest) {
        return listBotVersionsPaginator(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(ListBotsRequest listBotsRequest) {
        return new ListBotsPublisher(this, listBotsRequest);
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A Java Future containing the result of the ListBuiltInIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInIntentsResponse> listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuiltInIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInIntentsResponse> listBuiltInIntents(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) {
        return listBuiltInIntents(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsPublisher listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest) {
        return new ListBuiltInIntentsPublisher(this, listBuiltInIntentsRequest);
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsPublisher listBuiltInIntentsPaginator(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) {
        return listBuiltInIntentsPaginator(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A Java Future containing the result of the ListBuiltInSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInSlotTypesResponse> listBuiltInSlotTypes(
            ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuiltInSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInSlotTypesResponse> listBuiltInSlotTypes(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) {
        return listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesPublisher listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) {
        return new ListBuiltInSlotTypesPublisher(this, listBuiltInSlotTypesRequest);
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesPublisher listBuiltInSlotTypesPaginator(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) {
        return listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest)
                .build());
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return A Java Future containing the result of the ListCustomVocabularyItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVocabularyItemsResponse> listCustomVocabularyItems(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomVocabularyItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomVocabularyItemsRequest#builder()}
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCustomVocabularyItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVocabularyItemsResponse> listCustomVocabularyItems(
            Consumer<ListCustomVocabularyItemsRequest.Builder> listCustomVocabularyItemsRequest) {
        return listCustomVocabularyItems(ListCustomVocabularyItemsRequest.builder()
                .applyMutation(listCustomVocabularyItemsRequest).build());
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsPublisher publisher = client.listCustomVocabularyItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsPublisher publisher = client.listCustomVocabularyItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsPublisher listCustomVocabularyItemsPaginator(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) {
        return new ListCustomVocabularyItemsPublisher(this, listCustomVocabularyItemsRequest);
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsPublisher publisher = client.listCustomVocabularyItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListCustomVocabularyItemsPublisher publisher = client.listCustomVocabularyItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVocabularyItems(software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomVocabularyItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomVocabularyItemsRequest#builder()}
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVocabularyItemsPublisher listCustomVocabularyItemsPaginator(
            Consumer<ListCustomVocabularyItemsRequest.Builder> listCustomVocabularyItemsRequest) {
        return listCustomVocabularyItemsPaginator(ListCustomVocabularyItemsRequest.builder()
                .applyMutation(listCustomVocabularyItemsRequest).build());
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, listExportsRequest);
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, listImportsRequest);
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentMetricsRequest
     * @return A Java Future containing the result of the ListIntentMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIntentMetricsResponse> listIntentMetrics(ListIntentMetricsRequest listIntentMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIntentMetricsRequest#builder()}
     * </p>
     *
     * @param listIntentMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIntentMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIntentMetricsResponse> listIntentMetrics(
            Consumer<ListIntentMetricsRequest.Builder> listIntentMetricsRequest) {
        return listIntentMetrics(ListIntentMetricsRequest.builder().applyMutation(listIntentMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntentMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentMetricsPublisher publisher = client.listIntentMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentMetricsPublisher publisher = client.listIntentMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntentMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIntentMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntentMetricsPublisher listIntentMetricsPaginator(ListIntentMetricsRequest listIntentMetricsRequest) {
        return new ListIntentMetricsPublisher(this, listIntentMetricsRequest);
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntentMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentMetricsPublisher publisher = client.listIntentMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentMetricsPublisher publisher = client.listIntentMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntentMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIntentMetricsRequest#builder()}
     * </p>
     *
     * @param listIntentMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntentMetricsPublisher listIntentMetricsPaginator(
            Consumer<ListIntentMetricsRequest.Builder> listIntentMetricsRequest) {
        return listIntentMetricsPaginator(ListIntentMetricsRequest.builder().applyMutation(listIntentMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following
     * fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>intentPath</code> – Define an order of intents for which you want to retrieve metrics. Separate intents in
     * the path with a forward slash. For example, populate the <code>intentPath</code> field with
     * <code>/BookCar/BookHotel</code> to see details about how many times users invoked the <code>BookCar</code> and
     * <code>BookHotel</code> intents in that order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the optional <code>filters</code> field to filter the results.
     * </p>
     *
     * @param listIntentPathsRequest
     * @return A Java Future containing the result of the ListIntentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListIntentPathsResponse> listIntentPaths(ListIntentPathsRequest listIntentPathsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following
     * fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>intentPath</code> – Define an order of intents for which you want to retrieve metrics. Separate intents in
     * the path with a forward slash. For example, populate the <code>intentPath</code> field with
     * <code>/BookCar/BookHotel</code> to see details about how many times users invoked the <code>BookCar</code> and
     * <code>BookHotel</code> intents in that order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the optional <code>filters</code> field to filter the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentPathsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIntentPathsRequest#builder()}
     * </p>
     *
     * @param listIntentPathsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIntentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListIntentPathsResponse> listIntentPaths(
            Consumer<ListIntentPathsRequest.Builder> listIntentPathsRequest) {
        return listIntentPaths(ListIntentPathsRequest.builder().applyMutation(listIntentPathsRequest).build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentStageMetricsRequest
     * @return A Java Future containing the result of the ListIntentStageMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIntentStageMetricsResponse> listIntentStageMetrics(
            ListIntentStageMetricsRequest listIntentStageMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentStageMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIntentStageMetricsRequest#builder()}
     * </p>
     *
     * @param listIntentStageMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListIntentStageMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIntentStageMetricsResponse> listIntentStageMetrics(
            Consumer<ListIntentStageMetricsRequest.Builder> listIntentStageMetricsRequest) {
        return listIntentStageMetrics(ListIntentStageMetricsRequest.builder().applyMutation(listIntentStageMetricsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntentStageMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentStageMetricsPublisher publisher = client.listIntentStageMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentStageMetricsPublisher publisher = client.listIntentStageMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntentStageMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIntentStageMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntentStageMetricsPublisher listIntentStageMetricsPaginator(
            ListIntentStageMetricsRequest listIntentStageMetricsRequest) {
        return new ListIntentStageMetricsPublisher(this, listIntentStageMetricsRequest);
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntentStageMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentStageMetricsPublisher publisher = client.listIntentStageMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentStageMetricsPublisher publisher = client.listIntentStageMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntentStageMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentStageMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIntentStageMetricsRequest#builder()}
     * </p>
     *
     * @param listIntentStageMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntentStageMetricsPublisher listIntentStageMetricsPaginator(
            Consumer<ListIntentStageMetricsRequest.Builder> listIntentStageMetricsRequest) {
        return listIntentStageMetricsPaginator(ListIntentStageMetricsRequest.builder()
                .applyMutation(listIntentStageMetricsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return A Java Future containing the result of the ListIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIntentsResponse> listIntents(ListIntentsRequest listIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIntentsResponse> listIntents(Consumer<ListIntentsRequest.Builder> listIntentsRequest) {
        return listIntents(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     *
     * @param listIntentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsPublisher listIntentsPaginator(ListIntentsRequest listIntentsRequest) {
        return new ListIntentsPublisher(this, listIntentsRequest);
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsPublisher listIntentsPaginator(Consumer<ListIntentsRequest.Builder> listIntentsRequest) {
        return listIntentsPaginator(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return A Java Future containing the result of the ListRecommendedIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendedIntentsResponse> listRecommendedIntents(
            ListRecommendedIntentsRequest listRecommendedIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedIntentsRequest#builder()}
     * </p>
     *
     * @param listRecommendedIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListRecommendedIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendedIntentsResponse> listRecommendedIntents(
            Consumer<ListRecommendedIntentsRequest.Builder> listRecommendedIntentsRequest) {
        return listRecommendedIntents(ListRecommendedIntentsRequest.builder().applyMutation(listRecommendedIntentsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsPublisher publisher = client.listRecommendedIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsPublisher publisher = client.listRecommendedIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsPublisher listRecommendedIntentsPaginator(
            ListRecommendedIntentsRequest listRecommendedIntentsRequest) {
        return new ListRecommendedIntentsPublisher(this, listRecommendedIntentsRequest);
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsPublisher publisher = client.listRecommendedIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListRecommendedIntentsPublisher publisher = client.listRecommendedIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedIntentsRequest#builder()}
     * </p>
     *
     * @param listRecommendedIntentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedIntentsPublisher listRecommendedIntentsPaginator(
            Consumer<ListRecommendedIntentsRequest.Builder> listRecommendedIntentsRequest) {
        return listRecommendedIntentsPaginator(ListRecommendedIntentsRequest.builder()
                .applyMutation(listRecommendedIntentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listSessionAnalyticsDataRequest
     * @return A Java Future containing the result of the ListSessionAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionAnalyticsDataResponse> listSessionAnalyticsData(
            ListSessionAnalyticsDataRequest listSessionAnalyticsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionAnalyticsDataRequest.Builder} avoiding
     * the need to create one manually via {@link ListSessionAnalyticsDataRequest#builder()}
     * </p>
     *
     * @param listSessionAnalyticsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSessionAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionAnalyticsDataResponse> listSessionAnalyticsData(
            Consumer<ListSessionAnalyticsDataRequest.Builder> listSessionAnalyticsDataRequest) {
        return listSessionAnalyticsData(ListSessionAnalyticsDataRequest.builder().applyMutation(listSessionAnalyticsDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSessionAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionAnalyticsDataPublisher publisher = client.listSessionAnalyticsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionAnalyticsDataPublisher publisher = client.listSessionAnalyticsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionAnalyticsDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionAnalyticsDataPublisher listSessionAnalyticsDataPaginator(
            ListSessionAnalyticsDataRequest listSessionAnalyticsDataRequest) {
        return new ListSessionAnalyticsDataPublisher(this, listSessionAnalyticsDataRequest);
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSessionAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionAnalyticsDataPublisher publisher = client.listSessionAnalyticsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionAnalyticsDataPublisher publisher = client.listSessionAnalyticsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionAnalyticsDataRequest.Builder} avoiding
     * the need to create one manually via {@link ListSessionAnalyticsDataRequest#builder()}
     * </p>
     *
     * @param listSessionAnalyticsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionAnalyticsDataPublisher listSessionAnalyticsDataPaginator(
            Consumer<ListSessionAnalyticsDataRequest.Builder> listSessionAnalyticsDataRequest) {
        return listSessionAnalyticsDataPaginator(ListSessionAnalyticsDataRequest.builder()
                .applyMutation(listSessionAnalyticsDataRequest).build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listSessionMetricsRequest
     * @return A Java Future containing the result of the ListSessionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionMetricsResponse> listSessionMetrics(ListSessionMetricsRequest listSessionMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionMetricsRequest#builder()}
     * </p>
     *
     * @param listSessionMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSessionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionMetricsResponse> listSessionMetrics(
            Consumer<ListSessionMetricsRequest.Builder> listSessionMetricsRequest) {
        return listSessionMetrics(ListSessionMetricsRequest.builder().applyMutation(listSessionMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSessionMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionMetricsPublisher publisher = client.listSessionMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionMetricsPublisher publisher = client.listSessionMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionMetricsPublisher listSessionMetricsPaginator(ListSessionMetricsRequest listSessionMetricsRequest) {
        return new ListSessionMetricsPublisher(this, listSessionMetricsRequest);
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSessionMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionMetricsPublisher publisher = client.listSessionMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSessionMetricsPublisher publisher = client.listSessionMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionMetricsRequest#builder()}
     * </p>
     *
     * @param listSessionMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionMetricsPublisher listSessionMetricsPaginator(
            Consumer<ListSessionMetricsRequest.Builder> listSessionMetricsRequest) {
        return listSessionMetricsPaginator(ListSessionMetricsRequest.builder().applyMutation(listSessionMetricsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A Java Future containing the result of the ListSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSlotTypesResponse> listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSlotTypesResponse> listSlotTypes(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest) {
        return listSlotTypes(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesPublisher listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) {
        return new ListSlotTypesPublisher(this, listSlotTypesRequest);
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesPublisher listSlotTypesPaginator(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest) {
        return listSlotTypesPaginator(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return A Java Future containing the result of the ListSlots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSlotsResponse> listSlots(ListSlotsRequest listSlotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSlots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSlotsResponse> listSlots(Consumer<ListSlotsRequest.Builder> listSlotsRequest) {
        return listSlots(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     *
     * @param listSlotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsPublisher listSlotsPaginator(ListSlotsRequest listSlotsRequest) {
        return new ListSlotsPublisher(this, listSlotsRequest);
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsPublisher listSlotsPaginator(Consumer<ListSlotsRequest.Builder> listSlotsRequest) {
        return listSlotsPaginator(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     * @return A Java Future containing the result of the ListTestExecutionResultItems operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestExecutionResultItemsResponse> listTestExecutionResultItems(
            ListTestExecutionResultItemsRequest listTestExecutionResultItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestExecutionResultItemsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTestExecutionResultItemsRequest#builder()}
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTestExecutionResultItems operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestExecutionResultItemsResponse> listTestExecutionResultItems(
            Consumer<ListTestExecutionResultItemsRequest.Builder> listTestExecutionResultItemsRequest) {
        return listTestExecutionResultItems(ListTestExecutionResultItemsRequest.builder()
                .applyMutation(listTestExecutionResultItemsRequest).build());
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestExecutionResultItems(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionResultItemsPublisher publisher = client.listTestExecutionResultItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionResultItemsPublisher publisher = client.listTestExecutionResultItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestExecutionResultItems(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestExecutionResultItemsPublisher listTestExecutionResultItemsPaginator(
            ListTestExecutionResultItemsRequest listTestExecutionResultItemsRequest) {
        return new ListTestExecutionResultItemsPublisher(this, listTestExecutionResultItemsRequest);
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestExecutionResultItems(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionResultItemsPublisher publisher = client.listTestExecutionResultItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionResultItemsPublisher publisher = client.listTestExecutionResultItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestExecutionResultItems(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestExecutionResultItemsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTestExecutionResultItemsRequest#builder()}
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestExecutionResultItemsPublisher listTestExecutionResultItemsPaginator(
            Consumer<ListTestExecutionResultItemsRequest.Builder> listTestExecutionResultItemsRequest) {
        return listTestExecutionResultItemsPaginator(ListTestExecutionResultItemsRequest.builder()
                .applyMutation(listTestExecutionResultItemsRequest).build());
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     *
     * @param listTestExecutionsRequest
     * @return A Java Future containing the result of the ListTestExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestExecutionsResponse> listTestExecutions(ListTestExecutionsRequest listTestExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestExecutionsRequest#builder()}
     * </p>
     *
     * @param listTestExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestExecutionsResponse> listTestExecutions(
            Consumer<ListTestExecutionsRequest.Builder> listTestExecutionsRequest) {
        return listTestExecutions(ListTestExecutionsRequest.builder().applyMutation(listTestExecutionsRequest).build());
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestExecutions(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionsPublisher publisher = client.listTestExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionsPublisher publisher = client.listTestExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestExecutions(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestExecutionsPublisher listTestExecutionsPaginator(ListTestExecutionsRequest listTestExecutionsRequest) {
        return new ListTestExecutionsPublisher(this, listTestExecutionsRequest);
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestExecutions(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionsPublisher publisher = client.listTestExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestExecutionsPublisher publisher = client.listTestExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestExecutions(software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestExecutionsRequest#builder()}
     * </p>
     *
     * @param listTestExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestExecutionsPublisher listTestExecutionsPaginator(
            Consumer<ListTestExecutionsRequest.Builder> listTestExecutionsRequest) {
        return listTestExecutionsPaginator(ListTestExecutionsRequest.builder().applyMutation(listTestExecutionsRequest).build());
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     *
     * @param listTestSetRecordsRequest
     * @return A Java Future containing the result of the ListTestSetRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestSetRecordsResponse> listTestSetRecords(ListTestSetRecordsRequest listTestSetRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSetRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestSetRecordsRequest#builder()}
     * </p>
     *
     * @param listTestSetRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestSetRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestSetRecordsResponse> listTestSetRecords(
            Consumer<ListTestSetRecordsRequest.Builder> listTestSetRecordsRequest) {
        return listTestSetRecords(ListTestSetRecordsRequest.builder().applyMutation(listTestSetRecordsRequest).build());
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestSetRecords(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetRecordsPublisher publisher = client.listTestSetRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetRecordsPublisher publisher = client.listTestSetRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSetRecords(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestSetRecordsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestSetRecordsPublisher listTestSetRecordsPaginator(ListTestSetRecordsRequest listTestSetRecordsRequest) {
        return new ListTestSetRecordsPublisher(this, listTestSetRecordsRequest);
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestSetRecords(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetRecordsPublisher publisher = client.listTestSetRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetRecordsPublisher publisher = client.listTestSetRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSetRecords(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSetRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestSetRecordsRequest#builder()}
     * </p>
     *
     * @param listTestSetRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestSetRecordsPublisher listTestSetRecordsPaginator(
            Consumer<ListTestSetRecordsRequest.Builder> listTestSetRecordsRequest) {
        return listTestSetRecordsPaginator(ListTestSetRecordsRequest.builder().applyMutation(listTestSetRecordsRequest).build());
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     *
     * @param listTestSetsRequest
     * @return A Java Future containing the result of the ListTestSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTestSetsResponse> listTestSets(ListTestSetsRequest listTestSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestSetsRequest#builder()}
     * </p>
     *
     * @param listTestSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTestSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTestSetsResponse> listTestSets(Consumer<ListTestSetsRequest.Builder> listTestSetsRequest) {
        return listTestSets(ListTestSetsRequest.builder().applyMutation(listTestSetsRequest).build());
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTestSets(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetsPublisher publisher = client.listTestSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetsPublisher publisher = client.listTestSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSets(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest)} operation.</b>
     * </p>
     *
     * @param listTestSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTestSetsPublisher listTestSetsPaginator(ListTestSetsRequest listTestSetsRequest) {
        return new ListTestSetsPublisher(this, listTestSetsRequest);
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTestSets(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetsPublisher publisher = client.listTestSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListTestSetsPublisher publisher = client.listTestSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSets(software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestSetsRequest#builder()}
     * </p>
     *
     * @param listTestSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTestSetsPublisher listTestSetsPaginator(Consumer<ListTestSetsRequest.Builder> listTestSetsRequest) {
        return listTestSetsPaginator(ListTestSetsRequest.builder().applyMutation(listTestSetsRequest).build());
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listUtteranceAnalyticsDataRequest
     * @return A Java Future containing the result of the ListUtteranceAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUtteranceAnalyticsDataResponse> listUtteranceAnalyticsData(
            ListUtteranceAnalyticsDataRequest listUtteranceAnalyticsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUtteranceAnalyticsDataRequest.Builder} avoiding
     * the need to create one manually via {@link ListUtteranceAnalyticsDataRequest#builder()}
     * </p>
     *
     * @param listUtteranceAnalyticsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListUtteranceAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUtteranceAnalyticsDataResponse> listUtteranceAnalyticsData(
            Consumer<ListUtteranceAnalyticsDataRequest.Builder> listUtteranceAnalyticsDataRequest) {
        return listUtteranceAnalyticsData(ListUtteranceAnalyticsDataRequest.builder()
                .applyMutation(listUtteranceAnalyticsDataRequest).build());
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUtteranceAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceAnalyticsDataPublisher publisher = client.listUtteranceAnalyticsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceAnalyticsDataPublisher publisher = client.listUtteranceAnalyticsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUtteranceAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUtteranceAnalyticsDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUtteranceAnalyticsDataPublisher listUtteranceAnalyticsDataPaginator(
            ListUtteranceAnalyticsDataRequest listUtteranceAnalyticsDataRequest) {
        return new ListUtteranceAnalyticsDataPublisher(this, listUtteranceAnalyticsDataRequest);
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUtteranceAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceAnalyticsDataPublisher publisher = client.listUtteranceAnalyticsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceAnalyticsDataPublisher publisher = client.listUtteranceAnalyticsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUtteranceAnalyticsData(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUtteranceAnalyticsDataRequest.Builder} avoiding
     * the need to create one manually via {@link ListUtteranceAnalyticsDataRequest#builder()}
     * </p>
     *
     * @param listUtteranceAnalyticsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUtteranceAnalyticsDataPublisher listUtteranceAnalyticsDataPaginator(
            Consumer<ListUtteranceAnalyticsDataRequest.Builder> listUtteranceAnalyticsDataRequest) {
        return listUtteranceAnalyticsDataPaginator(ListUtteranceAnalyticsDataRequest.builder()
                .applyMutation(listUtteranceAnalyticsDataRequest).build());
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listUtteranceMetricsRequest
     * @return A Java Future containing the result of the ListUtteranceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUtteranceMetricsResponse> listUtteranceMetrics(
            ListUtteranceMetricsRequest listUtteranceMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUtteranceMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUtteranceMetricsRequest#builder()}
     * </p>
     *
     * @param listUtteranceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListUtteranceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUtteranceMetricsResponse> listUtteranceMetrics(
            Consumer<ListUtteranceMetricsRequest.Builder> listUtteranceMetricsRequest) {
        return listUtteranceMetrics(ListUtteranceMetricsRequest.builder().applyMutation(listUtteranceMetricsRequest).build());
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUtteranceMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceMetricsPublisher publisher = client.listUtteranceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceMetricsPublisher publisher = client.listUtteranceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUtteranceMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUtteranceMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUtteranceMetricsPublisher listUtteranceMetricsPaginator(ListUtteranceMetricsRequest listUtteranceMetricsRequest) {
        return new ListUtteranceMetricsPublisher(this, listUtteranceMetricsRequest);
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUtteranceMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceMetricsPublisher publisher = client.listUtteranceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListUtteranceMetricsPublisher publisher = client.listUtteranceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUtteranceMetrics(software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUtteranceMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUtteranceMetricsRequest#builder()}
     * </p>
     *
     * @param listUtteranceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUtteranceMetricsPublisher listUtteranceMetricsPaginator(
            Consumer<ListUtteranceMetricsRequest.Builder> listUtteranceMetricsRequest) {
        return listUtteranceMetricsPaginator(ListUtteranceMetricsRequest.builder().applyMutation(listUtteranceMetricsRequest)
                .build());
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     * @return A Java Future containing the result of the SearchAssociatedTranscripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAssociatedTranscriptsResponse> searchAssociatedTranscripts(
            SearchAssociatedTranscriptsRequest searchAssociatedTranscriptsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAssociatedTranscriptsRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAssociatedTranscriptsRequest#builder()}
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SearchAssociatedTranscripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAssociatedTranscriptsResponse> searchAssociatedTranscripts(
            Consumer<SearchAssociatedTranscriptsRequest.Builder> searchAssociatedTranscriptsRequest) {
        return searchAssociatedTranscripts(SearchAssociatedTranscriptsRequest.builder()
                .applyMutation(searchAssociatedTranscriptsRequest).build());
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     *
     * @param startBotRecommendationRequest
     * @return A Java Future containing the result of the StartBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBotRecommendationResponse> startBotRecommendation(
            StartBotRecommendationRequest startBotRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBotRecommendationRequest.Builder} avoiding the
     * need to create one manually via {@link StartBotRecommendationRequest#builder()}
     * </p>
     *
     * @param startBotRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBotRecommendationResponse> startBotRecommendation(
            Consumer<StartBotRecommendationRequest.Builder> startBotRecommendationRequest) {
        return startBotRecommendation(StartBotRecommendationRequest.builder().applyMutation(startBotRecommendationRequest)
                .build());
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(Consumer<StartImportRequest.Builder> startImportRequest) {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * The action to start test set execution.
     * </p>
     *
     * @param startTestExecutionRequest
     * @return A Java Future containing the result of the StartTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTestExecutionResponse> startTestExecution(StartTestExecutionRequest startTestExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The action to start test set execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartTestExecutionRequest#builder()}
     * </p>
     *
     * @param startTestExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTestExecutionResponse> startTestExecution(
            Consumer<StartTestExecutionRequest.Builder> startTestExecutionRequest) {
        return startTestExecution(StartTestExecutionRequest.builder().applyMutation(startTestExecutionRequest).build());
    }

    /**
     * <p>
     * The action to start the generation of test set.
     * </p>
     *
     * @param startTestSetGenerationRequest
     * @return A Java Future containing the result of the StartTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTestSetGenerationResponse> startTestSetGeneration(
            StartTestSetGenerationRequest startTestSetGenerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The action to start the generation of test set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestSetGenerationRequest.Builder} avoiding the
     * need to create one manually via {@link StartTestSetGenerationRequest#builder()}
     * </p>
     *
     * @param startTestSetGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTestSetGenerationResponse> startTestSetGeneration(
            Consumer<StartTestSetGenerationRequest.Builder> startTestSetGenerationRequest) {
        return startTestSetGeneration(StartTestSetGenerationRequest.builder().applyMutation(startTestSetGenerationRequest)
                .build());
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     *
     * @param stopBotRecommendationRequest
     * @return A Java Future containing the result of the StopBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopBotRecommendationResponse> stopBotRecommendation(
            StopBotRecommendationRequest stopBotRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBotRecommendationRequest.Builder} avoiding the
     * need to create one manually via {@link StopBotRecommendationRequest#builder()}
     * </p>
     *
     * @param stopBotRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopBotRecommendationResponse> stopBotRecommendation(
            Consumer<StopBotRecommendationRequest.Builder> stopBotRecommendationRequest) {
        return stopBotRecommendation(StopBotRecommendationRequest.builder().applyMutation(stopBotRecommendationRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotRequest#builder()}
     * </p>
     *
     * @param updateBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(Consumer<UpdateBotRequest.Builder> updateBotRequest) {
        return updateBot(UpdateBotRequest.builder().applyMutation(updateBotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return A Java Future containing the result of the UpdateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotAliasResponse> updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotAliasRequest#builder()}
     * </p>
     *
     * @param updateBotAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotAliasResponse> updateBotAlias(Consumer<UpdateBotAliasRequest.Builder> updateBotAliasRequest) {
        return updateBotAlias(UpdateBotAliasRequest.builder().applyMutation(updateBotAliasRequest).build());
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return A Java Future containing the result of the UpdateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotLocaleResponse> updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBotLocaleRequest#builder()}
     * </p>
     *
     * @param updateBotLocaleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotLocaleResponse> updateBotLocale(
            Consumer<UpdateBotLocaleRequest.Builder> updateBotLocaleRequest) {
        return updateBotLocale(UpdateBotLocaleRequest.builder().applyMutation(updateBotLocaleRequest).build());
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     *
     * @param updateBotRecommendationRequest
     * @return A Java Future containing the result of the UpdateBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBotRecommendationResponse> updateBotRecommendation(
            UpdateBotRecommendationRequest updateBotRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRecommendationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateBotRecommendationRequest#builder()}
     * </p>
     *
     * @param updateBotRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBotRecommendationResponse> updateBotRecommendation(
            Consumer<UpdateBotRecommendationRequest.Builder> updateBotRecommendationRequest) {
        return updateBotRecommendation(UpdateBotRecommendationRequest.builder().applyMutation(updateBotRecommendationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     *
     * @param updateExportRequest
     * @return A Java Future containing the result of the UpdateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateExportResponse> updateExport(UpdateExportRequest updateExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExportRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateExportRequest#builder()}
     * </p>
     *
     * @param updateExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateExportResponse> updateExport(Consumer<UpdateExportRequest.Builder> updateExportRequest) {
        return updateExport(UpdateExportRequest.builder().applyMutation(updateExportRequest).build());
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return A Java Future containing the result of the UpdateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateIntentResponse> updateIntent(UpdateIntentRequest updateIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIntentRequest#builder()}
     * </p>
     *
     * @param updateIntentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateIntentResponse> updateIntent(Consumer<UpdateIntentRequest.Builder> updateIntentRequest) {
        return updateIntent(UpdateIntentRequest.builder().applyMutation(updateIntentRequest).build());
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     *
     * @param updateResourcePolicyRequest
     * @return A Java Future containing the result of the UpdateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourcePolicyResponse> updateResourcePolicy(
            UpdateResourcePolicyRequest updateResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourcePolicyRequest#builder()}
     * </p>
     *
     * @param updateResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourcePolicyResponse> updateResourcePolicy(
            Consumer<UpdateResourcePolicyRequest.Builder> updateResourcePolicyRequest) {
        return updateResourcePolicy(UpdateResourcePolicyRequest.builder().applyMutation(updateResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return A Java Future containing the result of the UpdateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSlotResponse> updateSlot(UpdateSlotRequest updateSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotRequest#builder()}
     * </p>
     *
     * @param updateSlotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSlotResponse> updateSlot(Consumer<UpdateSlotRequest.Builder> updateSlotRequest) {
        return updateSlot(UpdateSlotRequest.builder().applyMutation(updateSlotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return A Java Future containing the result of the UpdateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSlotTypeResponse> updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotTypeRequest#builder()}
     * </p>
     *
     * @param updateSlotTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSlotTypeResponse> updateSlotType(Consumer<UpdateSlotTypeRequest.Builder> updateSlotTypeRequest) {
        return updateSlotType(UpdateSlotTypeRequest.builder().applyMutation(updateSlotTypeRequest).build());
    }

    /**
     * <p>
     * The action to update the test set.
     * </p>
     *
     * @param updateTestSetRequest
     * @return A Java Future containing the result of the UpdateTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTestSetResponse> updateTestSet(UpdateTestSetRequest updateTestSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The action to update the test set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTestSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTestSetRequest#builder()}
     * </p>
     *
     * @param updateTestSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTestSetResponse> updateTestSet(Consumer<UpdateTestSetRequest.Builder> updateTestSetRequest) {
        return updateTestSet(UpdateTestSetRequest.builder().applyMutation(updateTestSetRequest).build());
    }

    /**
     * Create an instance of {@link LexModelsV2AsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link LexModelsV2AsyncWaiter}
     */
    default LexModelsV2AsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default LexModelsV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LexModelsV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LexModelsV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LexModelsV2AsyncClient}.
     */
    static LexModelsV2AsyncClientBuilder builder() {
        return new DefaultLexModelsV2AsyncClientBuilder();
    }
}
