/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImportResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(DescribeImportResponse.getter(DescribeImportResponse::importId)).setter(DescribeImportResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(DescribeImportResponse.getter(DescribeImportResponse::resourceSpecification)).setter(DescribeImportResponse.setter(Builder::resourceSpecification)).constructor(ImportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> IMPORTED_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedResourceId").getter(DescribeImportResponse.getter(DescribeImportResponse::importedResourceId)).setter(DescribeImportResponse.setter(Builder::importedResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceId").build()}).build();
    private static final SdkField<String> IMPORTED_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedResourceName").getter(DescribeImportResponse.getter(DescribeImportResponse::importedResourceName)).setter(DescribeImportResponse.setter(Builder::importedResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceName").build()}).build();
    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergeStrategy").getter(DescribeImportResponse.getter(DescribeImportResponse::mergeStrategyAsString)).setter(DescribeImportResponse.setter(Builder::mergeStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(DescribeImportResponse.getter(DescribeImportResponse::importStatusAsString)).setter(DescribeImportResponse.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeImportResponse.getter(DescribeImportResponse::failureReasons)).setter(DescribeImportResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeImportResponse.getter(DescribeImportResponse::creationDateTime)).setter(DescribeImportResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeImportResponse.getter(DescribeImportResponse::lastUpdatedDateTime)).setter(DescribeImportResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, IMPORTED_RESOURCE_ID_FIELD, IMPORTED_RESOURCE_NAME_FIELD, MERGE_STRATEGY_FIELD, IMPORT_STATUS_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private final String importId;
    private final ImportResourceSpecification resourceSpecification;
    private final String importedResourceId;
    private final String importedResourceName;
    private final String mergeStrategy;
    private final String importStatus;
    private final List<String> failureReasons;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private DescribeImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.importedResourceId = builder.importedResourceId;
        this.importedResourceName = builder.importedResourceName;
        this.mergeStrategy = builder.mergeStrategy;
        this.importStatus = builder.importStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final String importedResourceId() {
        return this.importedResourceId;
    }

    public final String importedResourceName() {
        return this.importedResourceName;
    }

    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public final String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportResponse)) {
            return false;
        }
        DescribeImportResponse other = (DescribeImportResponse)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.importedResourceId(), other.importedResourceId()) && Objects.equals(this.importedResourceName(), other.importedResourceName()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImportResponse").add("ImportId", (Object)this.importId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("ImportedResourceId", (Object)this.importedResourceId()).add("ImportedResourceName", (Object)this.importedResourceName()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).add("ImportStatus", (Object)this.importStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "importedResourceId": {
                return Optional.ofNullable(clazz.cast(this.importedResourceId()));
            }
            case "importedResourceName": {
                return Optional.ofNullable(clazz.cast(this.importedResourceName()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportResponse, T> g) {
        return obj -> g.apply((DescribeImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String importId;
        private ImportResourceSpecification resourceSpecification;
        private String importedResourceId;
        private String importedResourceName;
        private String mergeStrategy;
        private String importStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportResponse model) {
            super(model);
            this.importId(model.importId);
            this.resourceSpecification(model.resourceSpecification);
            this.importedResourceId(model.importedResourceId);
            this.importedResourceName(model.importedResourceName);
            this.mergeStrategy(model.mergeStrategy);
            this.importStatus(model.importStatus);
            this.failureReasons(model.failureReasons);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getImportedResourceId() {
            return this.importedResourceId;
        }

        public final void setImportedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
        }

        @Override
        public final Builder importedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
            return this;
        }

        public final String getImportedResourceName() {
            return this.importedResourceName;
        }

        public final void setImportedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
        }

        @Override
        public final Builder importedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
            return this;
        }

        public final String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeImportResponse build() {
            return new DescribeImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImportResponse> {
        public Builder importId(String var1);

        public Builder resourceSpecification(ImportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ImportResourceSpecification)((ImportResourceSpecification.Builder)ImportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder importedResourceId(String var1);

        public Builder importedResourceName(String var1);

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

