/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current state of the conversation with the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DialogState implements SdkPojo, Serializable, ToCopyableBuilder<DialogState.Builder, DialogState> {
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.<DialogAction> builder(MarshallingType.SDK_POJO)
            .memberName("dialogAction").getter(getter(DialogState::dialogAction)).setter(setter(Builder::dialogAction))
            .constructor(DialogAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()).build();

    private static final SdkField<IntentOverride> INTENT_FIELD = SdkField.<IntentOverride> builder(MarshallingType.SDK_POJO)
            .memberName("intent").getter(getter(DialogState::intent)).setter(setter(Builder::intent))
            .constructor(IntentOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(DialogState::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALOG_ACTION_FIELD,
            INTENT_FIELD, SESSION_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final DialogAction dialogAction;

    private final IntentOverride intent;

    private final Map<String, String> sessionAttributes;

    private DialogState(BuilderImpl builder) {
        this.dialogAction = builder.dialogAction;
        this.intent = builder.intent;
        this.sessionAttributes = builder.sessionAttributes;
    }

    /**
     * Returns the value of the DialogAction property for this object.
     * 
     * @return The value of the DialogAction property for this object.
     */
    public final DialogAction dialogAction() {
        return dialogAction;
    }

    /**
     * Returns the value of the Intent property for this object.
     * 
     * @return The value of the Intent property for this object.
     */
    public final IntentOverride intent() {
        return intent;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of key/value pairs representing session-specific context information. It contains application information
     * passed between Amazon Lex and a client application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionAttributes} method.
     * </p>
     * 
     * @return Map of key/value pairs representing session-specific context information. It contains application
     *         information passed between Amazon Lex and a client application.
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogState)) {
            return false;
        }
        DialogState other = (DialogState) obj;
        return Objects.equals(dialogAction(), other.dialogAction()) && Objects.equals(intent(), other.intent())
                && hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DialogState").add("DialogAction", dialogAction()).add("Intent", intent())
                .add("SessionAttributes", hasSessionAttributes() ? sessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dialogAction":
            return Optional.ofNullable(clazz.cast(dialogAction()));
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DialogState, T> g) {
        return obj -> g.apply((DialogState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DialogState> {
        /**
         * Sets the value of the DialogAction property for this object.
         *
         * @param dialogAction
         *        The new value for the DialogAction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogAction(DialogAction dialogAction);

        /**
         * Sets the value of the DialogAction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DialogAction.Builder} avoiding the need
         * to create one manually via {@link DialogAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dialogAction(DialogAction)}.
         * 
         * @param dialogAction
         *        a consumer that will call methods on {@link DialogAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogAction(DialogAction)
         */
        default Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return dialogAction(DialogAction.builder().applyMutation(dialogAction).build());
        }

        /**
         * Sets the value of the Intent property for this object.
         *
         * @param intent
         *        The new value for the Intent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(IntentOverride intent);

        /**
         * Sets the value of the Intent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IntentOverride.Builder} avoiding the need
         * to create one manually via {@link IntentOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #intent(IntentOverride)}.
         * 
         * @param intent
         *        a consumer that will call methods on {@link IntentOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intent(IntentOverride)
         */
        default Builder intent(Consumer<IntentOverride.Builder> intent) {
            return intent(IntentOverride.builder().applyMutation(intent).build());
        }

        /**
         * <p>
         * Map of key/value pairs representing session-specific context information. It contains application information
         * passed between Amazon Lex and a client application.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing session-specific context information. It contains application
         *        information passed between Amazon Lex and a client application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);
    }

    static final class BuilderImpl implements Builder {
        private DialogAction dialogAction;

        private IntentOverride intent;

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DialogState model) {
            dialogAction(model.dialogAction);
            intent(model.intent);
            sessionAttributes(model.sessionAttributes);
        }

        public final DialogAction.Builder getDialogAction() {
            return dialogAction != null ? dialogAction.toBuilder() : null;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final IntentOverride.Builder getIntent() {
            return intent != null ? intent.toBuilder() : null;
        }

        public final void setIntent(IntentOverride.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(IntentOverride intent) {
            this.intent = intent;
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        @Override
        public DialogState build() {
            return new DialogState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
