/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;

public class ListBotRecommendationsIterable
implements SdkIterable<ListBotRecommendationsResponse> {
    private final LexModelsV2Client client;
    private final ListBotRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotRecommendationsIterable(LexModelsV2Client client, ListBotRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBotRecommendationsResponseFetcher();
    }

    public Iterator<ListBotRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotRecommendationsResponseFetcher
    implements SyncPageFetcher<ListBotRecommendationsResponse> {
        private ListBotRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotRecommendationsResponse nextPage(ListBotRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListBotRecommendationsIterable.this.client.listBotRecommendations(ListBotRecommendationsIterable.this.firstRequest);
            }
            return ListBotRecommendationsIterable.this.client.listBotRecommendations((ListBotRecommendationsRequest)((Object)ListBotRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

