/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse;

public class ListTestSetsIterable
implements SdkIterable<ListTestSetsResponse> {
    private final LexModelsV2Client client;
    private final ListTestSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestSetsIterable(LexModelsV2Client client, ListTestSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestSetsResponseFetcher();
    }

    public Iterator<ListTestSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestSetsResponseFetcher
    implements SyncPageFetcher<ListTestSetsResponse> {
        private ListTestSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestSetsResponse nextPage(ListTestSetsResponse previousPage) {
            if (previousPage == null) {
                return ListTestSetsIterable.this.client.listTestSets(ListTestSetsIterable.this.firstRequest);
            }
            return ListTestSetsIterable.this.client.listTestSets((ListTestSetsRequest)((Object)ListTestSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

