/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelsv2.internal.LexModelsV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchCreateCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchDeleteCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchUpdateCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BuildBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateTestSetDiscrepancyReportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteCustomVocabularyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeCustomVocabularyMetadataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestExecutionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetDiscrepancyReportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetGenerationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.GetTestExecutionArtifactsUrlRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListAggregatedUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotLocalesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListCustomVocabularyItemsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentPathsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentStageMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListRecommendedIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSessionAnalyticsDataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSessionMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestExecutionResultItemsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestExecutionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestSetRecordsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestSetsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListUtteranceAnalyticsDataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListUtteranceMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.SearchAssociatedTranscriptsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartTestExecutionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartTestSetGenerationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StopBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2Waiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link LexModelsV2Client}.
 *
 * @see LexModelsV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelsV2Client implements LexModelsV2Client {
    private static final Logger log = Logger.loggerFor(DefaultLexModelsV2Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final LexModelsV2ServiceClientConfiguration serviceClientConfiguration;

    protected DefaultLexModelsV2Client(LexModelsV2ServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     * @return Result of the BatchCreateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateCustomVocabularyItemResponse batchCreateCustomVocabularyItem(
            BatchCreateCustomVocabularyItemRequest batchCreateCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateCustomVocabularyItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateCustomVocabularyItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateCustomVocabularyItem");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateCustomVocabularyItemRequest, BatchCreateCustomVocabularyItemResponse>()
                            .withOperationName("BatchCreateCustomVocabularyItem").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchCreateCustomVocabularyItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateCustomVocabularyItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     * @return Result of the BatchDeleteCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteCustomVocabularyItemResponse batchDeleteCustomVocabularyItem(
            BatchDeleteCustomVocabularyItemRequest batchDeleteCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteCustomVocabularyItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteCustomVocabularyItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteCustomVocabularyItem");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteCustomVocabularyItemRequest, BatchDeleteCustomVocabularyItemResponse>()
                            .withOperationName("BatchDeleteCustomVocabularyItem").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteCustomVocabularyItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteCustomVocabularyItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     * @return Result of the BatchUpdateCustomVocabularyItem operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateCustomVocabularyItemResponse batchUpdateCustomVocabularyItem(
            BatchUpdateCustomVocabularyItemRequest batchUpdateCustomVocabularyItemRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateCustomVocabularyItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateCustomVocabularyItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateCustomVocabularyItem");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateCustomVocabularyItemRequest, BatchUpdateCustomVocabularyItemResponse>()
                            .withOperationName("BatchUpdateCustomVocabularyItem").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchUpdateCustomVocabularyItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateCustomVocabularyItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BuildBotLocaleResponse buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BuildBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BuildBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(buildBotLocaleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, buildBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BuildBotLocale");

            return clientHandler.execute(new ClientExecutionParams<BuildBotLocaleRequest, BuildBotLocaleResponse>()
                    .withOperationName("BuildBotLocale").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(buildBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BuildBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBot");

            return clientHandler.execute(new ClientExecutionParams<CreateBotRequest, CreateBotResponse>()
                    .withOperationName("CreateBot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createBotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBotAliasResponse createBotAlias(CreateBotAliasRequest createBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateBotAliasRequest, CreateBotAliasResponse>()
                    .withOperationName("CreateBotAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBotLocaleResponse createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBotLocaleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotLocale");

            return clientHandler.execute(new ClientExecutionParams<CreateBotLocaleRequest, CreateBotLocaleResponse>()
                    .withOperationName("CreateBotLocale").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBotVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                    .withOperationName("CreateBotVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     *
     * @param createExportRequest
     * @return Result of the CreateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateExportResponse createExport(CreateExportRequest createExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExport");

            return clientHandler.execute(new ClientExecutionParams<CreateExportRequest, CreateExportResponse>()
                    .withOperationName("CreateExport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateIntentResponse createIntent(CreateIntentRequest createIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntent");

            return clientHandler.execute(new ClientExecutionParams<CreateIntentRequest, CreateIntentResponse>()
                    .withOperationName("CreateIntent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     *
     * @param createResourcePolicyRequest
     * @return Result of the CreateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourcePolicyResponse createResourcePolicy(CreateResourcePolicyRequest createResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateResourcePolicyRequest, CreateResourcePolicyResponse>()
                    .withOperationName("CreateResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     * @return Result of the CreateResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourcePolicyStatementResponse createResourcePolicyStatement(
            CreateResourcePolicyStatementRequest createResourcePolicyStatementRequest) throws ResourceNotFoundException,
            ConflictException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourcePolicyStatementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourcePolicyStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicyStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourcePolicyStatementRequest, CreateResourcePolicyStatementResponse>()
                            .withOperationName("CreateResourcePolicyStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createResourcePolicyStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourcePolicyStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSlotResponse createSlot(CreateSlotRequest createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSlotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlot");

            return clientHandler.execute(new ClientExecutionParams<CreateSlotRequest, CreateSlotResponse>()
                    .withOperationName("CreateSlot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createSlotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSlotTypeResponse createSlotType(CreateSlotTypeRequest createSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlotType");

            return clientHandler.execute(new ClientExecutionParams<CreateSlotTypeRequest, CreateSlotTypeResponse>()
                    .withOperationName("CreateSlotType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a report that describes the differences between the bot and the test set.
     * </p>
     *
     * @param createTestSetDiscrepancyReportRequest
     * @return Result of the CreateTestSetDiscrepancyReport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTestSetDiscrepancyReportResponse createTestSetDiscrepancyReport(
            CreateTestSetDiscrepancyReportRequest createTestSetDiscrepancyReportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTestSetDiscrepancyReportResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTestSetDiscrepancyReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTestSetDiscrepancyReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTestSetDiscrepancyReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTestSetDiscrepancyReport");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTestSetDiscrepancyReportRequest, CreateTestSetDiscrepancyReportResponse>()
                            .withOperationName("CreateTestSetDiscrepancyReport").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTestSetDiscrepancyReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTestSetDiscrepancyReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUploadUrlResponse createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUploadUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUploadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUploadUrl");

            return clientHandler.execute(new ClientExecutionParams<CreateUploadUrlRequest, CreateUploadUrlResponse>()
                    .withOperationName("CreateUploadUrl").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUploadUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUploadUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBot");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>()
                    .withOperationName("DeleteBot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteBotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                    .withOperationName("DeleteBotAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBotLocaleResponse deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotLocaleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotLocale");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotLocaleRequest, DeleteBotLocaleResponse>()
                    .withOperationName("DeleteBotLocale").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                    .withOperationName("DeleteBotVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     * @return Result of the DeleteCustomVocabulary operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomVocabularyResponse deleteCustomVocabulary(DeleteCustomVocabularyRequest deleteCustomVocabularyRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomVocabularyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomVocabularyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomVocabularyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomVocabularyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomVocabulary");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomVocabularyRequest, DeleteCustomVocabularyResponse>()
                            .withOperationName("DeleteCustomVocabulary").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCustomVocabularyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomVocabularyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     *
     * @param deleteExportRequest
     * @return Result of the DeleteExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest deleteExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExport");

            return clientHandler.execute(new ClientExecutionParams<DeleteExportRequest, DeleteExportResponse>()
                    .withOperationName("DeleteExport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     *
     * @param deleteImportRequest
     * @return Result of the DeleteImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteImportResponse deleteImport(DeleteImportRequest deleteImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImport");

            return clientHandler.execute(new ClientExecutionParams<DeleteImportRequest, DeleteImportResponse>()
                    .withOperationName("DeleteImport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteImportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntent");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                    .withOperationName("DeleteIntent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceNotFoundException, PreconditionFailedException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     * @return Result of the DeleteResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyStatementResponse deleteResourcePolicyStatement(
            DeleteResourcePolicyStatementRequest deleteResourcePolicyStatementRequest) throws ResourceNotFoundException,
            PreconditionFailedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyStatementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicyStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyStatementRequest, DeleteResourcePolicyStatementResponse>()
                            .withOperationName("DeleteResourcePolicyStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteResourcePolicyStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResourcePolicyStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSlotResponse deleteSlot(DeleteSlotRequest deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSlotRequest, DeleteSlotResponse>()
                    .withOperationName("DeleteSlot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSlotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlotType");

            return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                    .withOperationName("DeleteSlotType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The action to delete the selected test set.
     * </p>
     *
     * @param deleteTestSetRequest
     * @return Result of the DeleteTestSet operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTestSetResponse deleteTestSet(DeleteTestSetRequest deleteTestSetRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTestSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTestSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTestSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTestSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteTestSetRequest, DeleteTestSetResponse>()
                    .withOperationName("DeleteTestSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTestSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTestSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return Result of the DeleteUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUtterancesResponse deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUtterancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUtterancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUtterancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUtterances");

            return clientHandler.execute(new ClientExecutionParams<DeleteUtterancesRequest, DeleteUtterancesResponse>()
                    .withOperationName("DeleteUtterances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteUtterancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUtterancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeBotResponse describeBot(DescribeBotRequest describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBot");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotRequest, DescribeBotResponse>()
                    .withOperationName("DescribeBot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(describeBotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotAliasResponse describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBotAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotAlias");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotAliasRequest, DescribeBotAliasResponse>()
                    .withOperationName("DescribeBotAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotLocaleResponse describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBotLocaleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotLocale");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotLocaleRequest, DescribeBotLocaleResponse>()
                    .withOperationName("DescribeBotLocale").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     *
     * @param describeBotRecommendationRequest
     * @return Result of the DescribeBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotRecommendationResponse describeBotRecommendation(
            DescribeBotRecommendationRequest describeBotRecommendationRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBotRecommendationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBotRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotRecommendation");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeBotRecommendationRequest, DescribeBotRecommendationResponse>()
                            .withOperationName("DescribeBotRecommendation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeBotRecommendationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeBotRecommendationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotVersionResponse describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBotVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotVersion");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotVersionRequest, DescribeBotVersionResponse>()
                    .withOperationName("DescribeBotVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     * @return Result of the DescribeCustomVocabularyMetadata operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomVocabularyMetadataResponse describeCustomVocabularyMetadata(
            DescribeCustomVocabularyMetadataRequest describeCustomVocabularyMetadataRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomVocabularyMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomVocabularyMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomVocabularyMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomVocabularyMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomVocabularyMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomVocabularyMetadataRequest, DescribeCustomVocabularyMetadataResponse>()
                            .withOperationName("DescribeCustomVocabularyMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCustomVocabularyMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomVocabularyMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     *
     * @param describeExportRequest
     * @return Result of the DescribeExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExport");

            return clientHandler.execute(new ClientExecutionParams<DescribeExportRequest, DescribeExportResponse>()
                    .withOperationName("DescribeExport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     *
     * @param describeImportRequest
     * @return Result of the DescribeImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeImportResponse describeImport(DescribeImportRequest describeImportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImport");

            return clientHandler.execute(new ClientExecutionParams<DescribeImportRequest, DescribeImportResponse>()
                    .withOperationName("DescribeImport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeImportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIntentResponse describeIntent(DescribeIntentRequest describeIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIntent");

            return clientHandler.execute(new ClientExecutionParams<DescribeIntentRequest, DescribeIntentResponse>()
                    .withOperationName("DescribeIntent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeResourcePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSlotResponse describeSlot(DescribeSlotRequest describeSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSlotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlot");

            return clientHandler.execute(new ClientExecutionParams<DescribeSlotRequest, DescribeSlotResponse>()
                    .withOperationName("DescribeSlot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSlotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSlotTypeResponse describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSlotTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlotType");

            return clientHandler.execute(new ClientExecutionParams<DescribeSlotTypeRequest, DescribeSlotTypeResponse>()
                    .withOperationName("DescribeSlotType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about the test execution.
     * </p>
     *
     * @param describeTestExecutionRequest
     * @return Result of the DescribeTestExecution operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTestExecutionResponse describeTestExecution(DescribeTestExecutionRequest describeTestExecutionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTestExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTestExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestExecution");

            return clientHandler.execute(new ClientExecutionParams<DescribeTestExecutionRequest, DescribeTestExecutionResponse>()
                    .withOperationName("DescribeTestExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTestExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTestExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set.
     * </p>
     *
     * @param describeTestSetRequest
     * @return Result of the DescribeTestSet operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTestSetResponse describeTestSet(DescribeTestSetRequest describeTestSetRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTestSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTestSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTestSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeTestSetRequest, DescribeTestSetResponse>()
                    .withOperationName("DescribeTestSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTestSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTestSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set discrepancy report.
     * </p>
     *
     * @param describeTestSetDiscrepancyReportRequest
     * @return Result of the DescribeTestSetDiscrepancyReport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTestSetDiscrepancyReportResponse describeTestSetDiscrepancyReport(
            DescribeTestSetDiscrepancyReportRequest describeTestSetDiscrepancyReportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTestSetDiscrepancyReportResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTestSetDiscrepancyReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTestSetDiscrepancyReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTestSetDiscrepancyReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSetDiscrepancyReport");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTestSetDiscrepancyReportRequest, DescribeTestSetDiscrepancyReportResponse>()
                            .withOperationName("DescribeTestSetDiscrepancyReport").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTestSetDiscrepancyReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTestSetDiscrepancyReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set generation.
     * </p>
     *
     * @param describeTestSetGenerationRequest
     * @return Result of the DescribeTestSetGeneration operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTestSetGenerationResponse describeTestSetGeneration(
            DescribeTestSetGenerationRequest describeTestSetGenerationRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTestSetGenerationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTestSetGenerationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTestSetGenerationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestSetGenerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSetGeneration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTestSetGenerationRequest, DescribeTestSetGenerationResponse>()
                            .withOperationName("DescribeTestSetGeneration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTestSetGenerationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTestSetGenerationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     * </p>
     *
     * @param getTestExecutionArtifactsUrlRequest
     * @return Result of the GetTestExecutionArtifactsUrl operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.GetTestExecutionArtifactsUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTestExecutionArtifactsUrlResponse getTestExecutionArtifactsUrl(
            GetTestExecutionArtifactsUrlRequest getTestExecutionArtifactsUrlRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTestExecutionArtifactsUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTestExecutionArtifactsUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTestExecutionArtifactsUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTestExecutionArtifactsUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTestExecutionArtifactsUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTestExecutionArtifactsUrlRequest, GetTestExecutionArtifactsUrlResponse>()
                            .withOperationName("GetTestExecutionArtifactsUrl").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTestExecutionArtifactsUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTestExecutionArtifactsUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAggregatedUtterancesRequest
     * @return Result of the ListAggregatedUtterances operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAggregatedUtterancesResponse listAggregatedUtterances(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) throws ValidationException,
            PreconditionFailedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAggregatedUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAggregatedUtterancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAggregatedUtterancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAggregatedUtterancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAggregatedUtterances");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAggregatedUtterancesRequest, ListAggregatedUtterancesResponse>()
                            .withOperationName("ListAggregatedUtterances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAggregatedUtterancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAggregatedUtterancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotAliasesResponse listBotAliases(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBotAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotAliases");

            return clientHandler.execute(new ClientExecutionParams<ListBotAliasesRequest, ListBotAliasesResponse>()
                    .withOperationName("ListBotAliases").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBotAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotLocalesResponse listBotLocales(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotLocalesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotLocalesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBotLocalesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotLocalesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotLocales");

            return clientHandler.execute(new ClientExecutionParams<ListBotLocalesRequest, ListBotLocalesResponse>()
                    .withOperationName("ListBotLocales").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBotLocalesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotLocalesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return Result of the ListBotRecommendations operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBotRecommendationsResponse listBotRecommendations(ListBotRecommendationsRequest listBotRecommendationsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBotRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBotRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBotRecommendationsRequest, ListBotRecommendationsResponse>()
                            .withOperationName("ListBotRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBotRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBotRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotVersionsResponse listBotVersions(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBotVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotVersions");

            return clientHandler.execute(new ClientExecutionParams<ListBotVersionsRequest, ListBotVersionsResponse>()
                    .withOperationName("ListBotVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBotVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBots");

            return clientHandler.execute(new ClientExecutionParams<ListBotsRequest, ListBotsResponse>()
                    .withOperationName("ListBots").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listBotsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInIntentsResponse listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBuiltInIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBuiltInIntentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuiltInIntentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInIntents");

            return clientHandler.execute(new ClientExecutionParams<ListBuiltInIntentsRequest, ListBuiltInIntentsResponse>()
                    .withOperationName("ListBuiltInIntents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBuiltInIntentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBuiltInIntentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInSlotTypesResponse listBuiltInSlotTypes(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBuiltInSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBuiltInSlotTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuiltInSlotTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInSlotTypes");

            return clientHandler.execute(new ClientExecutionParams<ListBuiltInSlotTypesRequest, ListBuiltInSlotTypesResponse>()
                    .withOperationName("ListBuiltInSlotTypes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBuiltInSlotTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBuiltInSlotTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return Result of the ListCustomVocabularyItems operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomVocabularyItemsResponse listCustomVocabularyItems(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomVocabularyItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomVocabularyItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomVocabularyItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomVocabularyItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomVocabularyItems");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomVocabularyItemsRequest, ListCustomVocabularyItemsResponse>()
                            .withOperationName("ListCustomVocabularyItems").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCustomVocabularyItemsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomVocabularyItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     *
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");

            return clientHandler.execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                    .withOperationName("ListExports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listExportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");

            return clientHandler.execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                    .withOperationName("ListImports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listImportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentMetricsRequest
     * @return Result of the ListIntentMetrics operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIntentMetricsResponse listIntentMetrics(ListIntentMetricsRequest listIntentMetricsRequest)
            throws ThrottlingException, ValidationException, PreconditionFailedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntentMetricsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIntentMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIntentMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentMetrics");

            return clientHandler.execute(new ClientExecutionParams<ListIntentMetricsRequest, ListIntentMetricsResponse>()
                    .withOperationName("ListIntentMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIntentMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIntentMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following
     * fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>intentPath</code> – Define an order of intents for which you want to retrieve metrics. Separate intents in
     * the path with a forward slash. For example, populate the <code>intentPath</code> field with
     * <code>/BookCar/BookHotel</code> to see details about how many times users invoked the <code>BookCar</code> and
     * <code>BookHotel</code> intents in that order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the optional <code>filters</code> field to filter the results.
     * </p>
     *
     * @param listIntentPathsRequest
     * @return Result of the ListIntentPaths operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListIntentPathsResponse listIntentPaths(ListIntentPathsRequest listIntentPathsRequest) throws ThrottlingException,
            ValidationException, PreconditionFailedException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntentPathsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIntentPathsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIntentPathsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentPathsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentPaths");

            return clientHandler.execute(new ClientExecutionParams<ListIntentPathsRequest, ListIntentPathsResponse>()
                    .withOperationName("ListIntentPaths").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIntentPathsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIntentPathsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentStageMetricsRequest
     * @return Result of the ListIntentStageMetrics operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIntentStageMetricsResponse listIntentStageMetrics(ListIntentStageMetricsRequest listIntentStageMetricsRequest)
            throws ThrottlingException, ValidationException, PreconditionFailedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntentStageMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIntentStageMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIntentStageMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentStageMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentStageMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<ListIntentStageMetricsRequest, ListIntentStageMetricsResponse>()
                            .withOperationName("ListIntentStageMetrics").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listIntentStageMetricsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListIntentStageMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIntentsResponse listIntents(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIntentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIntentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntents");

            return clientHandler.execute(new ClientExecutionParams<ListIntentsRequest, ListIntentsResponse>()
                    .withOperationName("ListIntents").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listIntentsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIntentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return Result of the ListRecommendedIntents operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecommendedIntentsResponse listRecommendedIntents(ListRecommendedIntentsRequest listRecommendedIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecommendedIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecommendedIntentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecommendedIntentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendedIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendedIntents");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecommendedIntentsRequest, ListRecommendedIntentsResponse>()
                            .withOperationName("ListRecommendedIntents").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRecommendedIntentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecommendedIntentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listSessionAnalyticsDataRequest
     * @return Result of the ListSessionAnalyticsData operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSessionAnalyticsDataResponse listSessionAnalyticsData(
            ListSessionAnalyticsDataRequest listSessionAnalyticsDataRequest) throws ThrottlingException, ValidationException,
            PreconditionFailedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionAnalyticsDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSessionAnalyticsDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionAnalyticsDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionAnalyticsDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionAnalyticsData");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSessionAnalyticsDataRequest, ListSessionAnalyticsDataResponse>()
                            .withOperationName("ListSessionAnalyticsData").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSessionAnalyticsDataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSessionAnalyticsDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listSessionMetricsRequest
     * @return Result of the ListSessionMetrics operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSessionMetricsResponse listSessionMetrics(ListSessionMetricsRequest listSessionMetricsRequest)
            throws ThrottlingException, ValidationException, PreconditionFailedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSessionMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionMetrics");

            return clientHandler.execute(new ClientExecutionParams<ListSessionMetricsRequest, ListSessionMetricsResponse>()
                    .withOperationName("ListSessionMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSessionMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSessionMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSlotTypesResponse listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSlotTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSlotTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlotTypes");

            return clientHandler.execute(new ClientExecutionParams<ListSlotTypesRequest, ListSlotTypesResponse>()
                    .withOperationName("ListSlotTypes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSlotTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSlotTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSlotsResponse listSlots(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSlotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSlotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSlotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlots");

            return clientHandler.execute(new ClientExecutionParams<ListSlotsRequest, ListSlotsResponse>()
                    .withOperationName("ListSlots").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listSlotsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSlotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     * @return Result of the ListTestExecutionResultItems operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestExecutionResultItemsResponse listTestExecutionResultItems(
            ListTestExecutionResultItemsRequest listTestExecutionResultItemsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestExecutionResultItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestExecutionResultItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestExecutionResultItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestExecutionResultItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestExecutionResultItems");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTestExecutionResultItemsRequest, ListTestExecutionResultItemsResponse>()
                            .withOperationName("ListTestExecutionResultItems").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTestExecutionResultItemsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTestExecutionResultItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     *
     * @param listTestExecutionsRequest
     * @return Result of the ListTestExecutions operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestExecutionsResponse listTestExecutions(ListTestExecutionsRequest listTestExecutionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestExecutions");

            return clientHandler.execute(new ClientExecutionParams<ListTestExecutionsRequest, ListTestExecutionsResponse>()
                    .withOperationName("ListTestExecutions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTestExecutionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTestExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     *
     * @param listTestSetRecordsRequest
     * @return Result of the ListTestSetRecords operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestSetRecordsResponse listTestSetRecords(ListTestSetRecordsRequest listTestSetRecordsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestSetRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestSetRecordsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestSetRecordsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestSetRecordsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestSetRecords");

            return clientHandler.execute(new ClientExecutionParams<ListTestSetRecordsRequest, ListTestSetRecordsResponse>()
                    .withOperationName("ListTestSetRecords").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTestSetRecordsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTestSetRecordsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     *
     * @param listTestSetsRequest
     * @return Result of the ListTestSets operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTestSetsResponse listTestSets(ListTestSetsRequest listTestSetsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTestSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestSets");

            return clientHandler.execute(new ClientExecutionParams<ListTestSetsRequest, ListTestSetsResponse>()
                    .withOperationName("ListTestSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTestSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTestSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listUtteranceAnalyticsDataRequest
     * @return Result of the ListUtteranceAnalyticsData operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUtteranceAnalyticsDataResponse listUtteranceAnalyticsData(
            ListUtteranceAnalyticsDataRequest listUtteranceAnalyticsDataRequest) throws ThrottlingException, ValidationException,
            PreconditionFailedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUtteranceAnalyticsDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUtteranceAnalyticsDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUtteranceAnalyticsDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUtteranceAnalyticsDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUtteranceAnalyticsData");

            return clientHandler
                    .execute(new ClientExecutionParams<ListUtteranceAnalyticsDataRequest, ListUtteranceAnalyticsDataResponse>()
                            .withOperationName("ListUtteranceAnalyticsData").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listUtteranceAnalyticsDataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListUtteranceAnalyticsDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listUtteranceMetricsRequest
     * @return Result of the ListUtteranceMetrics operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUtteranceMetricsResponse listUtteranceMetrics(ListUtteranceMetricsRequest listUtteranceMetricsRequest)
            throws ThrottlingException, ValidationException, PreconditionFailedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUtteranceMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUtteranceMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUtteranceMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUtteranceMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUtteranceMetrics");

            return clientHandler.execute(new ClientExecutionParams<ListUtteranceMetricsRequest, ListUtteranceMetricsResponse>()
                    .withOperationName("ListUtteranceMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listUtteranceMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUtteranceMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     * @return Result of the SearchAssociatedTranscripts operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchAssociatedTranscriptsResponse searchAssociatedTranscripts(
            SearchAssociatedTranscriptsRequest searchAssociatedTranscriptsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchAssociatedTranscriptsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchAssociatedTranscriptsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchAssociatedTranscriptsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchAssociatedTranscriptsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchAssociatedTranscripts");

            return clientHandler
                    .execute(new ClientExecutionParams<SearchAssociatedTranscriptsRequest, SearchAssociatedTranscriptsResponse>()
                            .withOperationName("SearchAssociatedTranscripts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(searchAssociatedTranscriptsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SearchAssociatedTranscriptsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     *
     * @param startBotRecommendationRequest
     * @return Result of the StartBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartBotRecommendationResponse startBotRecommendation(StartBotRecommendationRequest startBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartBotRecommendationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBotRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBotRecommendation");

            return clientHandler
                    .execute(new ClientExecutionParams<StartBotRecommendationRequest, StartBotRecommendationResponse>()
                            .withOperationName("StartBotRecommendation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startBotRecommendationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartBotRecommendationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     *
     * @param startImportRequest
     * @return Result of the StartImport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartImportResponse startImport(StartImportRequest startImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");

            return clientHandler.execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                    .withOperationName("StartImport").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startImportRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The action to start test set execution.
     * </p>
     *
     * @param startTestExecutionRequest
     * @return Result of the StartTestExecution operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartTestExecutionResponse startTestExecution(StartTestExecutionRequest startTestExecutionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ResourceNotFoundException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartTestExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTestExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTestExecution");

            return clientHandler.execute(new ClientExecutionParams<StartTestExecutionRequest, StartTestExecutionResponse>()
                    .withOperationName("StartTestExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startTestExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartTestExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The action to start the generation of test set.
     * </p>
     *
     * @param startTestSetGenerationRequest
     * @return Result of the StartTestSetGeneration operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartTestSetGenerationResponse startTestSetGeneration(StartTestSetGenerationRequest startTestSetGenerationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTestSetGenerationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartTestSetGenerationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTestSetGenerationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTestSetGenerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTestSetGeneration");

            return clientHandler
                    .execute(new ClientExecutionParams<StartTestSetGenerationRequest, StartTestSetGenerationResponse>()
                            .withOperationName("StartTestSetGeneration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startTestSetGenerationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartTestSetGenerationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     *
     * @param stopBotRecommendationRequest
     * @return Result of the StopBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopBotRecommendationResponse stopBotRecommendation(StopBotRecommendationRequest stopBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopBotRecommendationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBotRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBotRecommendation");

            return clientHandler.execute(new ClientExecutionParams<StopBotRecommendationRequest, StopBotRecommendationResponse>()
                    .withOperationName("StopBotRecommendation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopBotRecommendationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopBotRecommendationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBot");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotRequest, UpdateBotResponse>()
                    .withOperationName("UpdateBot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateBotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBotAliasResponse updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotAliasRequest, UpdateBotAliasResponse>()
                    .withOperationName("UpdateBotAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBotLocaleResponse updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBotLocaleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotLocale");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotLocaleRequest, UpdateBotLocaleResponse>()
                    .withOperationName("UpdateBotLocale").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     *
     * @param updateBotRecommendationRequest
     * @return Result of the UpdateBotRecommendation operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBotRecommendationResponse updateBotRecommendation(UpdateBotRecommendationRequest updateBotRecommendationRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBotRecommendationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBotRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotRecommendation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateBotRecommendationRequest, UpdateBotRecommendationResponse>()
                            .withOperationName("UpdateBotRecommendation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateBotRecommendationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateBotRecommendationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     *
     * @param updateExportRequest
     * @return Result of the UpdateExport operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest updateExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateExport");

            return clientHandler.execute(new ClientExecutionParams<UpdateExportRequest, UpdateExportResponse>()
                    .withOperationName("UpdateExport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateIntentResponse updateIntent(UpdateIntentRequest updateIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntent");

            return clientHandler.execute(new ClientExecutionParams<UpdateIntentRequest, UpdateIntentResponse>()
                    .withOperationName("UpdateIntent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     *
     * @param updateResourcePolicyRequest
     * @return Result of the UpdateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         You asked to describe a resource that doesn't exist. Check the resource that you are requesting and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResourcePolicyResponse updateResourcePolicy(UpdateResourcePolicyRequest updateResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<UpdateResourcePolicyRequest, UpdateResourcePolicyResponse>()
                    .withOperationName("UpdateResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSlotResponse updateSlot(UpdateSlotRequest updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSlotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlot");

            return clientHandler.execute(new ClientExecutionParams<UpdateSlotRequest, UpdateSlotResponse>()
                    .withOperationName("UpdateSlot").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSlotRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSlotTypeResponse updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlotType");

            return clientHandler.execute(new ClientExecutionParams<UpdateSlotTypeRequest, UpdateSlotTypeResponse>()
                    .withOperationName("UpdateSlotType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The action to update the test set.
     * </p>
     *
     * @param updateTestSetRequest
     * @return Result of the UpdateTestSet operation returned by the service.
     * @throws ThrottlingException
     *         Your request rate is too high. Reduce the frequency of requests.
     * @throws ServiceQuotaExceededException
     *         You have reached a quota for your bot.
     * @throws ValidationException
     *         One of the input parameters in your request isn't valid. Check the parameters and try your request again.
     * @throws PreconditionFailedException
     *         Your request couldn't be completed because one or more request fields aren't valid. Check the fields in
     *         your request and try again.
     * @throws ConflictException
     *         The action that you tried to perform couldn't be completed because the resource is in a conflicting
     *         state. For example, deleting a bot that is in the CREATING state. Try your request again.
     * @throws InternalServerException
     *         The service encountered an unexpected condition. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateTestSetResponse updateTestSet(UpdateTestSetRequest updateTestSetRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTestSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTestSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTestSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTestSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateTestSetRequest, UpdateTestSetResponse>()
                    .withOperationName("UpdateTestSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateTestSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTestSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link LexModelsV2Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link LexModelsV2Waiter}
     */
    @Override
    public LexModelsV2Waiter waiter() {
        return LexModelsV2Waiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        LexModelsV2ServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = LexModelsV2ServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LexModelsV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build());
    }

    @Override
    public final LexModelsV2ServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
