/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.DataPrivacy;
import software.amazon.awssdk.services.lexmodelsv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotImportSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotImportSpecification> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(BotImportSpecification.getter(BotImportSpecification::botName)).setter(BotImportSpecification.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(BotImportSpecification.getter(BotImportSpecification::roleArn)).setter(BotImportSpecification.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataPrivacy").getter(BotImportSpecification.getter(BotImportSpecification::dataPrivacy)).setter(BotImportSpecification.setter(Builder::dataPrivacy)).constructor(DataPrivacy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(BotImportSpecification.getter(BotImportSpecification::idleSessionTTLInSeconds)).setter(BotImportSpecification.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<Map<String, String>> BOT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("botTags").getter(BotImportSpecification.getter(BotImportSpecification::botTags)).setter(BotImportSpecification.setter(Builder::botTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TEST_BOT_ALIAS_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("testBotAliasTags").getter(BotImportSpecification.getter(BotImportSpecification::testBotAliasTags)).setter(BotImportSpecification.setter(Builder::testBotAliasTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testBotAliasTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_TAGS_FIELD, TEST_BOT_ALIAS_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botName;
    private final String roleArn;
    private final DataPrivacy dataPrivacy;
    private final Integer idleSessionTTLInSeconds;
    private final Map<String, String> botTags;
    private final Map<String, String> testBotAliasTags;

    private BotImportSpecification(BuilderImpl builder) {
        this.botName = builder.botName;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botTags = builder.botTags;
        this.testBotAliasTags = builder.testBotAliasTags;
    }

    public final String botName() {
        return this.botName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPrivacy dataPrivacy() {
        return this.dataPrivacy;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final boolean hasBotTags() {
        return this.botTags != null && !(this.botTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> botTags() {
        return this.botTags;
    }

    public final boolean hasTestBotAliasTags() {
        return this.testBotAliasTags != null && !(this.testBotAliasTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> testBotAliasTags() {
        return this.testBotAliasTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotTags() ? this.botTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestBotAliasTags() ? this.testBotAliasTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotImportSpecification)) {
            return false;
        }
        BotImportSpecification other = (BotImportSpecification)obj;
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPrivacy(), other.dataPrivacy()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && this.hasBotTags() == other.hasBotTags() && Objects.equals(this.botTags(), other.botTags()) && this.hasTestBotAliasTags() == other.hasTestBotAliasTags() && Objects.equals(this.testBotAliasTags(), other.testBotAliasTags());
    }

    public final String toString() {
        return ToString.builder((String)"BotImportSpecification").add("BotName", (Object)this.botName()).add("RoleArn", (Object)this.roleArn()).add("DataPrivacy", (Object)this.dataPrivacy()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("BotTags", this.hasBotTags() ? this.botTags() : null).add("TestBotAliasTags", this.hasTestBotAliasTags() ? this.testBotAliasTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "dataPrivacy": {
                return Optional.ofNullable(clazz.cast(this.dataPrivacy()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "botTags": {
                return Optional.ofNullable(clazz.cast(this.botTags()));
            }
            case "testBotAliasTags": {
                return Optional.ofNullable(clazz.cast(this.testBotAliasTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotImportSpecification, T> g) {
        return obj -> g.apply((BotImportSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botName;
        private String roleArn;
        private DataPrivacy dataPrivacy;
        private Integer idleSessionTTLInSeconds;
        private Map<String, String> botTags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> testBotAliasTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotImportSpecification model) {
            this.botName(model.botName);
            this.roleArn(model.roleArn);
            this.dataPrivacy(model.dataPrivacy);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.botTags(model.botTags);
            this.testBotAliasTags(model.testBotAliasTags);
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return this.dataPrivacy != null ? this.dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final Map<String, String> getBotTags() {
            if (this.botTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.botTags;
        }

        public final void setBotTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
        }

        @Override
        public final Builder botTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
            return this;
        }

        public final Map<String, String> getTestBotAliasTags() {
            if (this.testBotAliasTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.testBotAliasTags;
        }

        public final void setTestBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
        }

        @Override
        public final Builder testBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
            return this;
        }

        public BotImportSpecification build() {
            return new BotImportSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotImportSpecification> {
        public Builder botName(String var1);

        public Builder roleArn(String var1);

        public Builder dataPrivacy(DataPrivacy var1);

        default public Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return this.dataPrivacy((DataPrivacy)((DataPrivacy.Builder)DataPrivacy.builder().applyMutation(dataPrivacy)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder botTags(Map<String, String> var1);

        public Builder testBotAliasTags(Map<String, String> var1);
    }
}

