/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains specifications about the generative AI capabilities from Amazon Bedrock that you can turn on for your bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerativeAISettings implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerativeAISettings.Builder, GenerativeAISettings> {
    private static final SdkField<RuntimeSettings> RUNTIME_SETTINGS_FIELD = SdkField
            .<RuntimeSettings> builder(MarshallingType.SDK_POJO).memberName("runtimeSettings")
            .getter(getter(GenerativeAISettings::runtimeSettings)).setter(setter(Builder::runtimeSettings))
            .constructor(RuntimeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeSettings").build()).build();

    private static final SdkField<BuildtimeSettings> BUILDTIME_SETTINGS_FIELD = SdkField
            .<BuildtimeSettings> builder(MarshallingType.SDK_POJO).memberName("buildtimeSettings")
            .getter(getter(GenerativeAISettings::buildtimeSettings)).setter(setter(Builder::buildtimeSettings))
            .constructor(BuildtimeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildtimeSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_SETTINGS_FIELD,
            BUILDTIME_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuntimeSettings runtimeSettings;

    private final BuildtimeSettings buildtimeSettings;

    private GenerativeAISettings(BuilderImpl builder) {
        this.runtimeSettings = builder.runtimeSettings;
        this.buildtimeSettings = builder.buildtimeSettings;
    }

    /**
     * Returns the value of the RuntimeSettings property for this object.
     * 
     * @return The value of the RuntimeSettings property for this object.
     */
    public final RuntimeSettings runtimeSettings() {
        return runtimeSettings;
    }

    /**
     * Returns the value of the BuildtimeSettings property for this object.
     * 
     * @return The value of the BuildtimeSettings property for this object.
     */
    public final BuildtimeSettings buildtimeSettings() {
        return buildtimeSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runtimeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(buildtimeSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerativeAISettings)) {
            return false;
        }
        GenerativeAISettings other = (GenerativeAISettings) obj;
        return Objects.equals(runtimeSettings(), other.runtimeSettings())
                && Objects.equals(buildtimeSettings(), other.buildtimeSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerativeAISettings").add("RuntimeSettings", runtimeSettings())
                .add("BuildtimeSettings", buildtimeSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runtimeSettings":
            return Optional.ofNullable(clazz.cast(runtimeSettings()));
        case "buildtimeSettings":
            return Optional.ofNullable(clazz.cast(buildtimeSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerativeAISettings, T> g) {
        return obj -> g.apply((GenerativeAISettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerativeAISettings> {
        /**
         * Sets the value of the RuntimeSettings property for this object.
         *
         * @param runtimeSettings
         *        The new value for the RuntimeSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeSettings(RuntimeSettings runtimeSettings);

        /**
         * Sets the value of the RuntimeSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RuntimeSettings.Builder} avoiding the
         * need to create one manually via {@link RuntimeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #runtimeSettings(RuntimeSettings)}.
         * 
         * @param runtimeSettings
         *        a consumer that will call methods on {@link RuntimeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeSettings(RuntimeSettings)
         */
        default Builder runtimeSettings(Consumer<RuntimeSettings.Builder> runtimeSettings) {
            return runtimeSettings(RuntimeSettings.builder().applyMutation(runtimeSettings).build());
        }

        /**
         * Sets the value of the BuildtimeSettings property for this object.
         *
         * @param buildtimeSettings
         *        The new value for the BuildtimeSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildtimeSettings(BuildtimeSettings buildtimeSettings);

        /**
         * Sets the value of the BuildtimeSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BuildtimeSettings.Builder} avoiding the
         * need to create one manually via {@link BuildtimeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BuildtimeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #buildtimeSettings(BuildtimeSettings)}.
         * 
         * @param buildtimeSettings
         *        a consumer that will call methods on {@link BuildtimeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildtimeSettings(BuildtimeSettings)
         */
        default Builder buildtimeSettings(Consumer<BuildtimeSettings.Builder> buildtimeSettings) {
            return buildtimeSettings(BuildtimeSettings.builder().applyMutation(buildtimeSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuntimeSettings runtimeSettings;

        private BuildtimeSettings buildtimeSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerativeAISettings model) {
            runtimeSettings(model.runtimeSettings);
            buildtimeSettings(model.buildtimeSettings);
        }

        public final RuntimeSettings.Builder getRuntimeSettings() {
            return runtimeSettings != null ? runtimeSettings.toBuilder() : null;
        }

        public final void setRuntimeSettings(RuntimeSettings.BuilderImpl runtimeSettings) {
            this.runtimeSettings = runtimeSettings != null ? runtimeSettings.build() : null;
        }

        @Override
        public final Builder runtimeSettings(RuntimeSettings runtimeSettings) {
            this.runtimeSettings = runtimeSettings;
            return this;
        }

        public final BuildtimeSettings.Builder getBuildtimeSettings() {
            return buildtimeSettings != null ? buildtimeSettings.toBuilder() : null;
        }

        public final void setBuildtimeSettings(BuildtimeSettings.BuilderImpl buildtimeSettings) {
            this.buildtimeSettings = buildtimeSettings != null ? buildtimeSettings.build() : null;
        }

        @Override
        public final Builder buildtimeSettings(BuildtimeSettings buildtimeSettings) {
            this.buildtimeSettings = buildtimeSettings;
            return this;
        }

        @Override
        public GenerativeAISettings build() {
            return new GenerativeAISettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
