/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntentPathsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListIntentPathsRequest.Builder, ListIntentPathsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListIntentPathsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDateTime").getter(getter(ListIntentPathsRequest::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateTime").getter(getter(ListIntentPathsRequest::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<String> INTENT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentPath").getter(getter(ListIntentPathsRequest::intentPath)).setter(setter(Builder::intentPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentPath").build()).build();

    private static final SdkField<List<AnalyticsPathFilter>> FILTERS_FIELD = SdkField
            .<List<AnalyticsPathFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIntentPathsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsPathFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsPathFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, INTENT_PATH_FIELD, FILTERS_FIELD));

    private final String botId;

    private final Instant startDateTime;

    private final Instant endDateTime;

    private final String intentPath;

    private final List<AnalyticsPathFilter> filters;

    private ListIntentPathsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.intentPath = builder.intentPath;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The identifier for the bot for which you want to retrieve intent path metrics.
     * </p>
     * 
     * @return The identifier for the bot for which you want to retrieve intent path metrics.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The date and time that marks the beginning of the range of time for which you want to see intent path metrics.
     * </p>
     * 
     * @return The date and time that marks the beginning of the range of time for which you want to see intent path
     *         metrics.
     */
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The date and time that marks the end of the range of time for which you want to see intent path metrics.
     * </p>
     * 
     * @return The date and time that marks the end of the range of time for which you want to see intent path metrics.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * The intent path for which you want to retrieve metrics. Use a forward slash to separate intents in the path. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * /BookCar
     * </p>
     * </li>
     * <li>
     * <p>
     * /BookCar/BookHotel
     * </p>
     * </li>
     * <li>
     * <p>
     * /BookHotel/BookCar
     * </p>
     * </li>
     * </ul>
     * 
     * @return The intent path for which you want to retrieve metrics. Use a forward slash to separate intents in the
     *         path. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         /BookCar
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         /BookCar/BookHotel
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         /BookHotel/BookCar
     *         </p>
     *         </li>
     */
    public final String intentPath() {
        return intentPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each describes a condition by which you want to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of objects, each describes a condition by which you want to filter the results.
     */
    public final List<AnalyticsPathFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(intentPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentPathsRequest)) {
            return false;
        }
        ListIntentPathsRequest other = (ListIntentPathsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(endDateTime(), other.endDateTime()) && Objects.equals(intentPath(), other.intentPath())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntentPathsRequest").add("BotId", botId()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).add("IntentPath", intentPath())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "intentPath":
            return Optional.ofNullable(clazz.cast(intentPath()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentPathsRequest, T> g) {
        return obj -> g.apply((ListIntentPathsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListIntentPathsRequest> {
        /**
         * <p>
         * The identifier for the bot for which you want to retrieve intent path metrics.
         * </p>
         * 
         * @param botId
         *        The identifier for the bot for which you want to retrieve intent path metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The date and time that marks the beginning of the range of time for which you want to see intent path
         * metrics.
         * </p>
         * 
         * @param startDateTime
         *        The date and time that marks the beginning of the range of time for which you want to see intent path
         *        metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The date and time that marks the end of the range of time for which you want to see intent path metrics.
         * </p>
         * 
         * @param endDateTime
         *        The date and time that marks the end of the range of time for which you want to see intent path
         *        metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);

        /**
         * <p>
         * The intent path for which you want to retrieve metrics. Use a forward slash to separate intents in the path.
         * For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * /BookCar
         * </p>
         * </li>
         * <li>
         * <p>
         * /BookCar/BookHotel
         * </p>
         * </li>
         * <li>
         * <p>
         * /BookHotel/BookCar
         * </p>
         * </li>
         * </ul>
         * 
         * @param intentPath
         *        The intent path for which you want to retrieve metrics. Use a forward slash to separate intents in the
         *        path. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        /BookCar
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        /BookCar/BookHotel
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        /BookHotel/BookCar
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentPath(String intentPath);

        /**
         * <p>
         * A list of objects, each describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AnalyticsPathFilter> filters);

        /**
         * <p>
         * A list of objects, each describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AnalyticsPathFilter... filters);

        /**
         * <p>
         * A list of objects, each describes a condition by which you want to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<AnalyticsPathFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<AnalyticsPathFilter>)
         */
        Builder filters(Consumer<AnalyticsPathFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private Instant startDateTime;

        private Instant endDateTime;

        private String intentPath;

        private List<AnalyticsPathFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentPathsRequest model) {
            super(model);
            botId(model.botId);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
            intentPath(model.intentPath);
            filters(model.filters);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getIntentPath() {
            return intentPath;
        }

        public final void setIntentPath(String intentPath) {
            this.intentPath = intentPath;
        }

        @Override
        public final Builder intentPath(String intentPath) {
            this.intentPath = intentPath;
            return this;
        }

        public final List<AnalyticsPathFilter.Builder> getFilters() {
            List<AnalyticsPathFilter.Builder> result = AnalyticsPathFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsPathFilter.BuilderImpl> filters) {
            this.filters = AnalyticsPathFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsPathFilter> filters) {
            this.filters = AnalyticsPathFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsPathFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsPathFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AnalyticsPathFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentPathsRequest build() {
            return new ListIntentPathsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
