/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntentPathsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListIntentPathsResponse.Builder, ListIntentPathsResponse> {
    private static final SdkField<List<AnalyticsIntentNodeSummary>> NODE_SUMMARIES_FIELD = SdkField
            .<List<AnalyticsIntentNodeSummary>> builder(MarshallingType.LIST)
            .memberName("nodeSummaries")
            .getter(getter(ListIntentPathsResponse::nodeSummaries))
            .setter(setter(Builder::nodeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentNodeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentNodeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_SUMMARIES_FIELD));

    private final List<AnalyticsIntentNodeSummary> nodeSummaries;

    private ListIntentPathsResponse(BuilderImpl builder) {
        super(builder);
        this.nodeSummaries = builder.nodeSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeSummaries() {
        return nodeSummaries != null && !(nodeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about a node in the intent path for which you requested
     * metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeSummaries} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about a node in the intent path for which you
     *         requested metrics.
     */
    public final List<AnalyticsIntentNodeSummary> nodeSummaries() {
        return nodeSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeSummaries() ? nodeSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentPathsResponse)) {
            return false;
        }
        ListIntentPathsResponse other = (ListIntentPathsResponse) obj;
        return hasNodeSummaries() == other.hasNodeSummaries() && Objects.equals(nodeSummaries(), other.nodeSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntentPathsResponse").add("NodeSummaries", hasNodeSummaries() ? nodeSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeSummaries":
            return Optional.ofNullable(clazz.cast(nodeSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentPathsResponse, T> g) {
        return obj -> g.apply((ListIntentPathsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListIntentPathsResponse> {
        /**
         * <p>
         * A list of objects, each of which contains information about a node in the intent path for which you requested
         * metrics.
         * </p>
         * 
         * @param nodeSummaries
         *        A list of objects, each of which contains information about a node in the intent path for which you
         *        requested metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeSummaries(Collection<AnalyticsIntentNodeSummary> nodeSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about a node in the intent path for which you requested
         * metrics.
         * </p>
         * 
         * @param nodeSummaries
         *        A list of objects, each of which contains information about a node in the intent path for which you
         *        requested metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeSummaries(AnalyticsIntentNodeSummary... nodeSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about a node in the intent path for which you requested
         * metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #nodeSummaries(List<AnalyticsIntentNodeSummary>)}.
         * 
         * @param nodeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeSummaries(java.util.Collection<AnalyticsIntentNodeSummary>)
         */
        Builder nodeSummaries(Consumer<AnalyticsIntentNodeSummary.Builder>... nodeSummaries);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<AnalyticsIntentNodeSummary> nodeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentPathsResponse model) {
            super(model);
            nodeSummaries(model.nodeSummaries);
        }

        public final List<AnalyticsIntentNodeSummary.Builder> getNodeSummaries() {
            List<AnalyticsIntentNodeSummary.Builder> result = AnalyticsIntentNodeSummariesCopier
                    .copyToBuilder(this.nodeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeSummaries(Collection<AnalyticsIntentNodeSummary.BuilderImpl> nodeSummaries) {
            this.nodeSummaries = AnalyticsIntentNodeSummariesCopier.copyFromBuilder(nodeSummaries);
        }

        @Override
        public final Builder nodeSummaries(Collection<AnalyticsIntentNodeSummary> nodeSummaries) {
            this.nodeSummaries = AnalyticsIntentNodeSummariesCopier.copy(nodeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSummaries(AnalyticsIntentNodeSummary... nodeSummaries) {
            nodeSummaries(Arrays.asList(nodeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSummaries(Consumer<AnalyticsIntentNodeSummary.Builder>... nodeSummaries) {
            nodeSummaries(Stream.of(nodeSummaries).map(c -> AnalyticsIntentNodeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIntentPathsResponse build() {
            return new ListIntentPathsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
