/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SlotResolutionStrategy {
    ENHANCED_FALLBACK("EnhancedFallback"),
    DEFAULT("Default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SlotResolutionStrategy> VALUE_MAP;
    private final String value;

    private SlotResolutionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlotResolutionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlotResolutionStrategy> knownValues() {
        EnumSet<SlotResolutionStrategy> knownValues = EnumSet.allOf(SlotResolutionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SlotResolutionStrategy.class, SlotResolutionStrategy::toString);
    }
}

