/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;

public class ListRecommendedIntentsPublisher
implements SdkPublisher<ListRecommendedIntentsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListRecommendedIntentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendedIntentsPublisher(LexModelsV2AsyncClient client, ListRecommendedIntentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendedIntentsPublisher(LexModelsV2AsyncClient client, ListRecommendedIntentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendedIntentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendedIntentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecommendedIntentsResponseFetcher
    implements AsyncPageFetcher<ListRecommendedIntentsResponse> {
        private ListRecommendedIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendedIntentsResponse> nextPage(ListRecommendedIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedIntentsPublisher.this.client.listRecommendedIntents(ListRecommendedIntentsPublisher.this.firstRequest);
            }
            return ListRecommendedIntentsPublisher.this.client.listRecommendedIntents((ListRecommendedIntentsRequest)((Object)ListRecommendedIntentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

