/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSlotTypeRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateSlotTypeRequest.Builder, CreateSlotTypeRequest> {
    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeName").getter(getter(CreateSlotTypeRequest::slotTypeName)).setter(setter(Builder::slotTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSlotTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SlotTypeValue>> SLOT_TYPE_VALUES_FIELD = SdkField
            .<List<SlotTypeValue>> builder(MarshallingType.LIST)
            .memberName("slotTypeValues")
            .getter(getter(CreateSlotTypeRequest::slotTypeValues))
            .setter(setter(Builder::slotTypeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SlotValueSelectionSetting> VALUE_SELECTION_SETTING_FIELD = SdkField
            .<SlotValueSelectionSetting> builder(MarshallingType.SDK_POJO).memberName("valueSelectionSetting")
            .getter(getter(CreateSlotTypeRequest::valueSelectionSetting)).setter(setter(Builder::valueSelectionSetting))
            .constructor(SlotValueSelectionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionSetting").build())
            .build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(CreateSlotTypeRequest::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateSlotTypeRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateSlotTypeRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateSlotTypeRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<ExternalSourceSetting> EXTERNAL_SOURCE_SETTING_FIELD = SdkField
            .<ExternalSourceSetting> builder(MarshallingType.SDK_POJO).memberName("externalSourceSetting")
            .getter(getter(CreateSlotTypeRequest::externalSourceSetting)).setter(setter(Builder::externalSourceSetting))
            .constructor(ExternalSourceSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceSetting").build())
            .build();

    private static final SdkField<CompositeSlotTypeSetting> COMPOSITE_SLOT_TYPE_SETTING_FIELD = SdkField
            .<CompositeSlotTypeSetting> builder(MarshallingType.SDK_POJO).memberName("compositeSlotTypeSetting")
            .getter(getter(CreateSlotTypeRequest::compositeSlotTypeSetting)).setter(setter(Builder::compositeSlotTypeSetting))
            .constructor(CompositeSlotTypeSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeSlotTypeSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_NAME_FIELD,
            DESCRIPTION_FIELD, SLOT_TYPE_VALUES_FIELD, VALUE_SELECTION_SETTING_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD,
            BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, EXTERNAL_SOURCE_SETTING_FIELD, COMPOSITE_SLOT_TYPE_SETTING_FIELD));

    private final String slotTypeName;

    private final String description;

    private final List<SlotTypeValue> slotTypeValues;

    private final SlotValueSelectionSetting valueSelectionSetting;

    private final String parentSlotTypeSignature;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final ExternalSourceSetting externalSourceSetting;

    private final CompositeSlotTypeSetting compositeSlotTypeSetting;

    private CreateSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.slotTypeValues = builder.slotTypeValues;
        this.valueSelectionSetting = builder.valueSelectionSetting;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.externalSourceSetting = builder.externalSourceSetting;
        this.compositeSlotTypeSetting = builder.compositeSlotTypeSetting;
    }

    /**
     * <p>
     * The name for the slot. A slot type name must be unique within the intent.
     * </p>
     * 
     * @return The name for the slot. A slot type name must be unique within the intent.
     */
    public final String slotTypeName() {
        return slotTypeName;
    }

    /**
     * <p>
     * A description of the slot type. Use the description to help identify the slot type in lists.
     * </p>
     * 
     * @return A description of the slot type. Use the description to help identify the slot type in lists.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotTypeValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlotTypeValues() {
        return slotTypeValues != null && !(slotTypeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can
     * have a list of synonyms, additional values that help train the machine learning model about the values that it
     * resolves for a slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotTypeValues} method.
     * </p>
     * 
     * @return A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each
     *         value can have a list of synonyms, additional values that help train the machine learning model about the
     *         values that it resolves for a slot.
     */
    public final List<SlotTypeValue> slotTypeValues() {
        return slotTypeValues;
    }

    /**
     * <p>
     * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be
     * set to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list. If there is no resolution list, return null.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>ORIGINAL_VALUE</code>
     * .
     * </p>
     * 
     * @return Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The
     *         field can be set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list. If there is no resolution list, return null.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionSetting</code> parameter, the default is
     *         <code>ORIGINAL_VALUE</code>.
     */
    public final SlotValueSelectionSetting valueSelectionSetting() {
        return valueSelectionSetting;
    }

    /**
     * <p>
     * The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type
     * has the configuration of the parent slot type.
     * </p>
     * <p>
     * Only <code>AMAZON.AlphaNumeric</code> is supported.
     * </p>
     * 
     * @return The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new
     *         slot type has the configuration of the parent slot type.</p>
     *         <p>
     *         Only <code>AMAZON.AlphaNumeric</code> is supported.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * <p>
     * The identifier of the bot associated with this slot type.
     * </p>
     * 
     * @return The identifier of the bot associated with this slot type.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the bot version associated with this slot type.
     * </p>
     * 
     * @return The identifier of the bot version associated with this slot type.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that the slot type will be used in. The string must match one of the
     * supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more
     * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
     * languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale that the slot type will be used in. The string must match one
     *         of the supported locales. All of the bots, intents, and slots used by the slot type must have the same
     *         locale. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * Sets the type of external information used to create the slot type.
     * </p>
     * 
     * @return Sets the type of external information used to create the slot type.
     */
    public final ExternalSourceSetting externalSourceSetting() {
        return externalSourceSetting;
    }

    /**
     * <p>
     * Specifications for a composite slot type.
     * </p>
     * 
     * @return Specifications for a composite slot type.
     */
    public final CompositeSlotTypeSetting compositeSlotTypeSetting() {
        return compositeSlotTypeSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeValues() ? slotTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(externalSourceSetting());
        hashCode = 31 * hashCode + Objects.hashCode(compositeSlotTypeSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlotTypeRequest)) {
            return false;
        }
        CreateSlotTypeRequest other = (CreateSlotTypeRequest) obj;
        return Objects.equals(slotTypeName(), other.slotTypeName()) && Objects.equals(description(), other.description())
                && hasSlotTypeValues() == other.hasSlotTypeValues() && Objects.equals(slotTypeValues(), other.slotTypeValues())
                && Objects.equals(valueSelectionSetting(), other.valueSelectionSetting())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(externalSourceSetting(), other.externalSourceSetting())
                && Objects.equals(compositeSlotTypeSetting(), other.compositeSlotTypeSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSlotTypeRequest").add("SlotTypeName", slotTypeName()).add("Description", description())
                .add("SlotTypeValues", hasSlotTypeValues() ? slotTypeValues() : null)
                .add("ValueSelectionSetting", valueSelectionSetting()).add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId())
                .add("ExternalSourceSetting", externalSourceSetting())
                .add("CompositeSlotTypeSetting", compositeSlotTypeSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeName":
            return Optional.ofNullable(clazz.cast(slotTypeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeValues":
            return Optional.ofNullable(clazz.cast(slotTypeValues()));
        case "valueSelectionSetting":
            return Optional.ofNullable(clazz.cast(valueSelectionSetting()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "externalSourceSetting":
            return Optional.ofNullable(clazz.cast(externalSourceSetting()));
        case "compositeSlotTypeSetting":
            return Optional.ofNullable(clazz.cast(compositeSlotTypeSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSlotTypeRequest, T> g) {
        return obj -> g.apply((CreateSlotTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSlotTypeRequest> {
        /**
         * <p>
         * The name for the slot. A slot type name must be unique within the intent.
         * </p>
         * 
         * @param slotTypeName
         *        The name for the slot. A slot type name must be unique within the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeName(String slotTypeName);

        /**
         * <p>
         * A description of the slot type. Use the description to help identify the slot type in lists.
         * </p>
         * 
         * @param description
         *        A description of the slot type. Use the description to help identify the slot type in lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value
         * can have a list of synonyms, additional values that help train the machine learning model about the values
         * that it resolves for a slot.
         * </p>
         * 
         * @param slotTypeValues
         *        A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each
         *        value can have a list of synonyms, additional values that help train the machine learning model about
         *        the values that it resolves for a slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues);

        /**
         * <p>
         * A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value
         * can have a list of synonyms, additional values that help train the machine learning model about the values
         * that it resolves for a slot.
         * </p>
         * 
         * @param slotTypeValues
         *        A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each
         *        value can have a list of synonyms, additional values that help train the machine learning model about
         *        the values that it resolves for a slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(SlotTypeValue... slotTypeValues);

        /**
         * <p>
         * A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value
         * can have a list of synonyms, additional values that help train the machine learning model about the values
         * that it resolves for a slot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue.Builder#build()} is called immediately
         * and its result is passed to {@link #slotTypeValues(List<SlotTypeValue>)}.
         * 
         * @param slotTypeValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeValues(java.util.Collection<SlotTypeValue>)
         */
        Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues);

        /**
         * <p>
         * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field
         * can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list. If there is no resolution list, return null.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionSetting</code> parameter, the default is
         * <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param valueSelectionSetting
         *        Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The
         *        field can be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list. If there is no resolution list, return null.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionSetting</code> parameter, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting);

        /**
         * <p>
         * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field
         * can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list. If there is no resolution list, return null.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionSetting</code> parameter, the default is
         * <code>ORIGINAL_VALUE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotValueSelectionSetting.Builder}
         * avoiding the need to create one manually via {@link SlotValueSelectionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotValueSelectionSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #valueSelectionSetting(SlotValueSelectionSetting)}.
         * 
         * @param valueSelectionSetting
         *        a consumer that will call methods on {@link SlotValueSelectionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueSelectionSetting(SlotValueSelectionSetting)
         */
        default Builder valueSelectionSetting(Consumer<SlotValueSelectionSetting.Builder> valueSelectionSetting) {
            return valueSelectionSetting(SlotValueSelectionSetting.builder().applyMutation(valueSelectionSetting).build());
        }

        /**
         * <p>
         * The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot
         * type has the configuration of the parent slot type.
         * </p>
         * <p>
         * Only <code>AMAZON.AlphaNumeric</code> is supported.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new
         *        slot type has the configuration of the parent slot type.</p>
         *        <p>
         *        Only <code>AMAZON.AlphaNumeric</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * The identifier of the bot associated with this slot type.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with this slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the bot version associated with this slot type.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the bot version associated with this slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that the slot type will be used in. The string must match one of
         * the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale.
         * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
         * languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that the slot type will be used in. The string must match
         *        one of the supported locales. All of the bots, intents, and slots used by the slot type must have the
         *        same locale. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Sets the type of external information used to create the slot type.
         * </p>
         * 
         * @param externalSourceSetting
         *        Sets the type of external information used to create the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSourceSetting(ExternalSourceSetting externalSourceSetting);

        /**
         * <p>
         * Sets the type of external information used to create the slot type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalSourceSetting.Builder} avoiding
         * the need to create one manually via {@link ExternalSourceSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalSourceSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #externalSourceSetting(ExternalSourceSetting)}.
         * 
         * @param externalSourceSetting
         *        a consumer that will call methods on {@link ExternalSourceSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalSourceSetting(ExternalSourceSetting)
         */
        default Builder externalSourceSetting(Consumer<ExternalSourceSetting.Builder> externalSourceSetting) {
            return externalSourceSetting(ExternalSourceSetting.builder().applyMutation(externalSourceSetting).build());
        }

        /**
         * <p>
         * Specifications for a composite slot type.
         * </p>
         * 
         * @param compositeSlotTypeSetting
         *        Specifications for a composite slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeSlotTypeSetting(CompositeSlotTypeSetting compositeSlotTypeSetting);

        /**
         * <p>
         * Specifications for a composite slot type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompositeSlotTypeSetting.Builder}
         * avoiding the need to create one manually via {@link CompositeSlotTypeSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositeSlotTypeSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #compositeSlotTypeSetting(CompositeSlotTypeSetting)}.
         * 
         * @param compositeSlotTypeSetting
         *        a consumer that will call methods on {@link CompositeSlotTypeSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositeSlotTypeSetting(CompositeSlotTypeSetting)
         */
        default Builder compositeSlotTypeSetting(Consumer<CompositeSlotTypeSetting.Builder> compositeSlotTypeSetting) {
            return compositeSlotTypeSetting(CompositeSlotTypeSetting.builder().applyMutation(compositeSlotTypeSetting).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String slotTypeName;

        private String description;

        private List<SlotTypeValue> slotTypeValues = DefaultSdkAutoConstructList.getInstance();

        private SlotValueSelectionSetting valueSelectionSetting;

        private String parentSlotTypeSignature;

        private String botId;

        private String botVersion;

        private String localeId;

        private ExternalSourceSetting externalSourceSetting;

        private CompositeSlotTypeSetting compositeSlotTypeSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlotTypeRequest model) {
            super(model);
            slotTypeName(model.slotTypeName);
            description(model.description);
            slotTypeValues(model.slotTypeValues);
            valueSelectionSetting(model.valueSelectionSetting);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            externalSourceSetting(model.externalSourceSetting);
            compositeSlotTypeSetting(model.compositeSlotTypeSetting);
        }

        public final String getSlotTypeName() {
            return slotTypeName;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SlotTypeValue.Builder> getSlotTypeValues() {
            List<SlotTypeValue.Builder> result = SlotTypeValuesCopier.copyToBuilder(this.slotTypeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypeValues(Collection<SlotTypeValue.BuilderImpl> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copyFromBuilder(slotTypeValues);
        }

        @Override
        public final Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copy(slotTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(SlotTypeValue... slotTypeValues) {
            slotTypeValues(Arrays.asList(slotTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues) {
            slotTypeValues(Stream.of(slotTypeValues).map(c -> SlotTypeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SlotValueSelectionSetting.Builder getValueSelectionSetting() {
            return valueSelectionSetting != null ? valueSelectionSetting.toBuilder() : null;
        }

        public final void setValueSelectionSetting(SlotValueSelectionSetting.BuilderImpl valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting != null ? valueSelectionSetting.build() : null;
        }

        @Override
        public final Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final ExternalSourceSetting.Builder getExternalSourceSetting() {
            return externalSourceSetting != null ? externalSourceSetting.toBuilder() : null;
        }

        public final void setExternalSourceSetting(ExternalSourceSetting.BuilderImpl externalSourceSetting) {
            this.externalSourceSetting = externalSourceSetting != null ? externalSourceSetting.build() : null;
        }

        @Override
        public final Builder externalSourceSetting(ExternalSourceSetting externalSourceSetting) {
            this.externalSourceSetting = externalSourceSetting;
            return this;
        }

        public final CompositeSlotTypeSetting.Builder getCompositeSlotTypeSetting() {
            return compositeSlotTypeSetting != null ? compositeSlotTypeSetting.toBuilder() : null;
        }

        public final void setCompositeSlotTypeSetting(CompositeSlotTypeSetting.BuilderImpl compositeSlotTypeSetting) {
            this.compositeSlotTypeSetting = compositeSlotTypeSetting != null ? compositeSlotTypeSetting.build() : null;
        }

        @Override
        public final Builder compositeSlotTypeSetting(CompositeSlotTypeSetting compositeSlotTypeSetting) {
            this.compositeSlotTypeSetting = compositeSlotTypeSetting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSlotTypeRequest build() {
            return new CreateSlotTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
