/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIntentResponse extends LexModelsV2Response implements
        ToCopyableBuilder<UpdateIntentResponse.Builder, UpdateIntentResponse> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(UpdateIntentResponse::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(UpdateIntentResponse::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateIntentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(UpdateIntentResponse::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(UpdateIntentResponse::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("dialogCodeHook")
            .getter(getter(UpdateIntentResponse::dialogCodeHook)).setter(setter(Builder::dialogCodeHook))
            .constructor(DialogCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField
            .<FulfillmentCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook")
            .getter(getter(UpdateIntentResponse::fulfillmentCodeHook)).setter(setter(Builder::fulfillmentCodeHook))
            .constructor(FulfillmentCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build())
            .build();

    private static final SdkField<List<SlotPriority>> SLOT_PRIORITIES_FIELD = SdkField
            .<List<SlotPriority>> builder(MarshallingType.LIST)
            .memberName("slotPriorities")
            .getter(getter(UpdateIntentResponse::slotPriorities))
            .setter(setter(Builder::slotPriorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotPriorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotPriority> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotPriority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField
            .<IntentConfirmationSetting> builder(MarshallingType.SDK_POJO).memberName("intentConfirmationSetting")
            .getter(getter(UpdateIntentResponse::intentConfirmationSetting)).setter(setter(Builder::intentConfirmationSetting))
            .constructor(IntentConfirmationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build())
            .build();

    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField
            .<IntentClosingSetting> builder(MarshallingType.SDK_POJO).memberName("intentClosingSetting")
            .getter(getter(UpdateIntentResponse::intentClosingSetting)).setter(setter(Builder::intentClosingSetting))
            .constructor(IntentClosingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(UpdateIntentResponse::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(UpdateIntentResponse::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(UpdateIntentResponse::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateIntentResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateIntentResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateIntentResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(UpdateIntentResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(UpdateIntentResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<InitialResponseSetting> INITIAL_RESPONSE_SETTING_FIELD = SdkField
            .<InitialResponseSetting> builder(MarshallingType.SDK_POJO).memberName("initialResponseSetting")
            .getter(getter(UpdateIntentResponse::initialResponseSetting)).setter(setter(Builder::initialResponseSetting))
            .constructor(InitialResponseSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialResponseSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD,
            INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD,
            FULFILLMENT_CODE_HOOK_FIELD, SLOT_PRIORITIES_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD,
            INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD,
            LOCALE_ID_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, INITIAL_RESPONSE_SETTING_FIELD));

    private final String intentId;

    private final String intentName;

    private final String description;

    private final String parentIntentSignature;

    private final List<SampleUtterance> sampleUtterances;

    private final DialogCodeHookSettings dialogCodeHook;

    private final FulfillmentCodeHookSettings fulfillmentCodeHook;

    private final List<SlotPriority> slotPriorities;

    private final IntentConfirmationSetting intentConfirmationSetting;

    private final IntentClosingSetting intentClosingSetting;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private final KendraConfiguration kendraConfiguration;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final InitialResponseSetting initialResponseSetting;

    private UpdateIntentResponse(BuilderImpl builder) {
        super(builder);
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.slotPriorities = builder.slotPriorities;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.initialResponseSetting = builder.initialResponseSetting;
    }

    /**
     * <p>
     * The identifier of the intent that was updated.
     * </p>
     * 
     * @return The identifier of the intent that was updated.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The updated name of the intent.
     * </p>
     * 
     * @return The updated name of the intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The updated description of the intent.
     * </p>
     * 
     * @return The updated description of the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated built-in intent that is the parent of this intent.
     * </p>
     * 
     * @return The updated built-in intent that is the parent of this intent.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of sample utterances for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return The updated list of sample utterances for the intent.
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * The updated Lambda function called during each turn of the conversation with the user.
     * </p>
     * 
     * @return The updated Lambda function called during each turn of the conversation with the user.
     */
    public final DialogCodeHookSettings dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * The updated Lambda function called when the intent is ready for fulfillment.
     * </p>
     * 
     * @return The updated Lambda function called when the intent is ready for fulfillment.
     */
    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return fulfillmentCodeHook;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotPriorities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlotPriorities() {
        return slotPriorities != null && !(slotPriorities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of slots and their priorities that are elicited from the user for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotPriorities} method.
     * </p>
     * 
     * @return The updated list of slots and their priorities that are elicited from the user for the intent.
     */
    public final List<SlotPriority> slotPriorities() {
        return slotPriorities;
    }

    /**
     * <p>
     * The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.
     * </p>
     * 
     * @return The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.
     */
    public final IntentConfirmationSetting intentConfirmationSetting() {
        return intentConfirmationSetting;
    }

    /**
     * <p>
     * The updated response that Amazon Lex sends the user when the intent is closed.
     * </p>
     * 
     * @return The updated response that Amazon Lex sends the user when the intent is closed.
     */
    public final IntentClosingSetting intentClosingSetting() {
        return intentClosingSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputContexts} method.
     * </p>
     * 
     * @return The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputContexts} method.
     * </p>
     * 
     * @return The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    /**
     * <p>
     * The updated configuration for connecting to an Amazon Kendra index with the
     * <code>AMAZON.KendraSearchIntent</code> intent.
     * </p>
     * 
     * @return The updated configuration for connecting to an Amazon Kendra index with the
     *         <code>AMAZON.KendraSearchIntent</code> intent.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * <p>
     * The identifier of the bot that contains the intent.
     * </p>
     * 
     * @return The identifier of the bot that contains the intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the intent. Will always be <code>DRAFT</code>.
     * </p>
     * 
     * @return The version of the bot that contains the intent. Will always be <code>DRAFT</code>.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The updated language and locale of the intent.
     * </p>
     * 
     * @return The updated language and locale of the intent.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A timestamp of when the intent was created.
     * </p>
     * 
     * @return A timestamp of when the intent was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the last time that the intent was modified.
     * </p>
     * 
     * @return A timestamp of the last time that the intent was modified.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.
     * </p>
     * 
     * @return Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.
     */
    public final InitialResponseSetting initialResponseSetting() {
        return initialResponseSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotPriorities() ? slotPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(initialResponseSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntentResponse)) {
            return false;
        }
        UpdateIntentResponse other = (UpdateIntentResponse) obj;
        return Objects.equals(intentId(), other.intentId()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentCodeHook(), other.fulfillmentCodeHook())
                && hasSlotPriorities() == other.hasSlotPriorities() && Objects.equals(slotPriorities(), other.slotPriorities())
                && Objects.equals(intentConfirmationSetting(), other.intentConfirmationSetting())
                && Objects.equals(intentClosingSetting(), other.intentClosingSetting())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(initialResponseSetting(), other.initialResponseSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIntentResponse").add("IntentId", intentId()).add("IntentName", intentName())
                .add("Description", description()).add("ParentIntentSignature", parentIntentSignature())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentCodeHook", fulfillmentCodeHook())
                .add("SlotPriorities", hasSlotPriorities() ? slotPriorities() : null)
                .add("IntentConfirmationSetting", intentConfirmationSetting())
                .add("IntentClosingSetting", intentClosingSetting())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null)
                .add("KendraConfiguration", kendraConfiguration()).add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("InitialResponseSetting", initialResponseSetting())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentCodeHook":
            return Optional.ofNullable(clazz.cast(fulfillmentCodeHook()));
        case "slotPriorities":
            return Optional.ofNullable(clazz.cast(slotPriorities()));
        case "intentConfirmationSetting":
            return Optional.ofNullable(clazz.cast(intentConfirmationSetting()));
        case "intentClosingSetting":
            return Optional.ofNullable(clazz.cast(intentClosingSetting()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "initialResponseSetting":
            return Optional.ofNullable(clazz.cast(initialResponseSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntentResponse, T> g) {
        return obj -> g.apply((UpdateIntentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIntentResponse> {
        /**
         * <p>
         * The identifier of the intent that was updated.
         * </p>
         * 
         * @param intentId
         *        The identifier of the intent that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The updated name of the intent.
         * </p>
         * 
         * @param intentName
         *        The updated name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The updated description of the intent.
         * </p>
         * 
         * @param description
         *        The updated description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated built-in intent that is the parent of this intent.
         * </p>
         * 
         * @param parentIntentSignature
         *        The updated built-in intent that is the parent of this intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The updated list of sample utterances for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        The updated list of sample utterances for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * The updated list of sample utterances for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        The updated list of sample utterances for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * The updated list of sample utterances for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder#build()} is called
         * immediately and its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(java.util.Collection<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * <p>
         * The updated Lambda function called during each turn of the conversation with the user.
         * </p>
         * 
         * @param dialogCodeHook
         *        The updated Lambda function called during each turn of the conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook);

        /**
         * <p>
         * The updated Lambda function called during each turn of the conversation with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogCodeHookSettings.Builder} avoiding
         * the need to create one manually via {@link DialogCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogCodeHookSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dialogCodeHook(DialogCodeHookSettings)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link DialogCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(DialogCodeHookSettings)
         */
        default Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return dialogCodeHook(DialogCodeHookSettings.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * The updated Lambda function called when the intent is ready for fulfillment.
         * </p>
         * 
         * @param fulfillmentCodeHook
         *        The updated Lambda function called when the intent is ready for fulfillment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook);

        /**
         * <p>
         * The updated Lambda function called when the intent is ready for fulfillment.
         * </p>
         * This is a convenience method that creates an instance of the {@link FulfillmentCodeHookSettings.Builder}
         * avoiding the need to create one manually via {@link FulfillmentCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentCodeHookSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #fulfillmentCodeHook(FulfillmentCodeHookSettings)}.
         * 
         * @param fulfillmentCodeHook
         *        a consumer that will call methods on {@link FulfillmentCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentCodeHook(FulfillmentCodeHookSettings)
         */
        default Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return fulfillmentCodeHook(FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook).build());
        }

        /**
         * <p>
         * The updated list of slots and their priorities that are elicited from the user for the intent.
         * </p>
         * 
         * @param slotPriorities
         *        The updated list of slots and their priorities that are elicited from the user for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotPriorities(Collection<SlotPriority> slotPriorities);

        /**
         * <p>
         * The updated list of slots and their priorities that are elicited from the user for the intent.
         * </p>
         * 
         * @param slotPriorities
         *        The updated list of slots and their priorities that are elicited from the user for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotPriorities(SlotPriority... slotPriorities);

        /**
         * <p>
         * The updated list of slots and their priorities that are elicited from the user for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority.Builder#build()} is called immediately
         * and its result is passed to {@link #slotPriorities(List<SlotPriority>)}.
         * 
         * @param slotPriorities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotPriorities(java.util.Collection<SlotPriority>)
         */
        Builder slotPriorities(Consumer<SlotPriority.Builder>... slotPriorities);

        /**
         * <p>
         * The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.
         * </p>
         * 
         * @param intentConfirmationSetting
         *        The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting);

        /**
         * <p>
         * The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentConfirmationSetting.Builder}
         * avoiding the need to create one manually via {@link IntentConfirmationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentConfirmationSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #intentConfirmationSetting(IntentConfirmationSetting)}.
         * 
         * @param intentConfirmationSetting
         *        a consumer that will call methods on {@link IntentConfirmationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentConfirmationSetting(IntentConfirmationSetting)
         */
        default Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return intentConfirmationSetting(IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting).build());
        }

        /**
         * <p>
         * The updated response that Amazon Lex sends the user when the intent is closed.
         * </p>
         * 
         * @param intentClosingSetting
         *        The updated response that Amazon Lex sends the user when the intent is closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClosingSetting(IntentClosingSetting intentClosingSetting);

        /**
         * <p>
         * The updated response that Amazon Lex sends the user when the intent is closed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentClosingSetting.Builder} avoiding
         * the need to create one manually via {@link IntentClosingSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentClosingSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #intentClosingSetting(IntentClosingSetting)}.
         * 
         * @param intentClosingSetting
         *        a consumer that will call methods on {@link IntentClosingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClosingSetting(IntentClosingSetting)
         */
        default Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return intentClosingSetting(IntentClosingSetting.builder().applyMutation(intentClosingSetting).build());
        }

        /**
         * <p>
         * The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
         * </p>
         * 
         * @param inputContexts
         *        The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
         * </p>
         * 
         * @param inputContexts
         *        The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * The updated list of contexts that must be active for the intent to be considered by Amazon Lex.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(java.util.Collection<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * The updated list of contexts that Amazon Lex activates when the intent is fulfilled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(java.util.Collection<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        /**
         * <p>
         * The updated configuration for connecting to an Amazon Kendra index with the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * 
         * @param kendraConfiguration
         *        The updated configuration for connecting to an Amazon Kendra index with the
         *        <code>AMAZON.KendraSearchIntent</code> intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * The updated configuration for connecting to an Amazon Kendra index with the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraConfiguration.Builder} avoiding the
         * need to create one manually via {@link KendraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the bot that contains the intent.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the intent. Will always be <code>DRAFT</code>.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the intent. Will always be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The updated language and locale of the intent.
         * </p>
         * 
         * @param localeId
         *        The updated language and locale of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A timestamp of when the intent was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of when the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the last time that the intent was modified.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the last time that the intent was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.
         * </p>
         * 
         * @param initialResponseSetting
         *        Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialResponseSetting(InitialResponseSetting initialResponseSetting);

        /**
         * <p>
         * Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialResponseSetting.Builder} avoiding
         * the need to create one manually via {@link InitialResponseSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialResponseSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #initialResponseSetting(InitialResponseSetting)}.
         * 
         * @param initialResponseSetting
         *        a consumer that will call methods on {@link InitialResponseSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialResponseSetting(InitialResponseSetting)
         */
        default Builder initialResponseSetting(Consumer<InitialResponseSetting.Builder> initialResponseSetting) {
            return initialResponseSetting(InitialResponseSetting.builder().applyMutation(initialResponseSetting).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String intentId;

        private String intentName;

        private String description;

        private String parentIntentSignature;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private DialogCodeHookSettings dialogCodeHook;

        private FulfillmentCodeHookSettings fulfillmentCodeHook;

        private List<SlotPriority> slotPriorities = DefaultSdkAutoConstructList.getInstance();

        private IntentConfirmationSetting intentConfirmationSetting;

        private IntentClosingSetting intentClosingSetting;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private KendraConfiguration kendraConfiguration;

        private String botId;

        private String botVersion;

        private String localeId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private InitialResponseSetting initialResponseSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntentResponse model) {
            super(model);
            intentId(model.intentId);
            intentName(model.intentName);
            description(model.description);
            parentIntentSignature(model.parentIntentSignature);
            sampleUtterances(model.sampleUtterances);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentCodeHook(model.fulfillmentCodeHook);
            slotPriorities(model.slotPriorities);
            intentConfirmationSetting(model.intentConfirmationSetting);
            intentClosingSetting(model.intentClosingSetting);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
            kendraConfiguration(model.kendraConfiguration);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            initialResponseSetting(model.initialResponseSetting);
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return fulfillmentCodeHook != null ? fulfillmentCodeHook.toBuilder() : null;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        @Override
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final List<SlotPriority.Builder> getSlotPriorities() {
            List<SlotPriority.Builder> result = SlotPrioritiesListCopier.copyToBuilder(this.slotPriorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotPriorities(Collection<SlotPriority.BuilderImpl> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copyFromBuilder(slotPriorities);
        }

        @Override
        public final Builder slotPriorities(Collection<SlotPriority> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copy(slotPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotPriorities(SlotPriority... slotPriorities) {
            slotPriorities(Arrays.asList(slotPriorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotPriorities(Consumer<SlotPriority.Builder>... slotPriorities) {
            slotPriorities(Stream.of(slotPriorities).map(c -> SlotPriority.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return intentConfirmationSetting != null ? intentConfirmationSetting.toBuilder() : null;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        @Override
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return intentClosingSetting != null ? intentClosingSetting.toBuilder() : null;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        @Override
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final InitialResponseSetting.Builder getInitialResponseSetting() {
            return initialResponseSetting != null ? initialResponseSetting.toBuilder() : null;
        }

        public final void setInitialResponseSetting(InitialResponseSetting.BuilderImpl initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting != null ? initialResponseSetting.build() : null;
        }

        @Override
        public final Builder initialResponseSetting(InitialResponseSetting initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting;
            return this;
        }

        @Override
        public UpdateIntentResponse build() {
            return new UpdateIntentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
