/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FulfillmentStartResponseSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<FulfillmentStartResponseSpecification.Builder, FulfillmentStartResponseSpecification> {
    private static final SdkField<Integer> DELAY_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("delayInSeconds").getter(getter(FulfillmentStartResponseSpecification::delayInSeconds))
            .setter(setter(Builder::delayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delayInSeconds").build()).build();

    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField
            .<List<MessageGroup>> builder(MarshallingType.LIST)
            .memberName("messageGroups")
            .getter(getter(FulfillmentStartResponseSpecification::messageGroups))
            .setter(setter(Builder::messageGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowInterrupt").getter(getter(FulfillmentStartResponseSpecification::allowInterrupt))
            .setter(setter(Builder::allowInterrupt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELAY_IN_SECONDS_FIELD,
            MESSAGE_GROUPS_FIELD, ALLOW_INTERRUPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer delayInSeconds;

    private final List<MessageGroup> messageGroups;

    private final Boolean allowInterrupt;

    private FulfillmentStartResponseSpecification(BuilderImpl builder) {
        this.delayInSeconds = builder.delayInSeconds;
        this.messageGroups = builder.messageGroups;
        this.allowInterrupt = builder.allowInterrupt;
    }

    /**
     * <p>
     * The delay between when the Lambda fulfillment function starts running and the start message is played. If the
     * Lambda function returns before the delay is over, the start message isn't played.
     * </p>
     * 
     * @return The delay between when the Lambda fulfillment function starts running and the start message is played. If
     *         the Lambda function returns before the delay is over, the start message isn't played.
     */
    public final Integer delayInSeconds() {
        return delayInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageGroups() {
        return messageGroups != null && !(messageGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageGroups} method.
     * </p>
     * 
     * @return 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the
     *         user.
     */
    public final List<MessageGroup> messageGroups() {
        return messageGroups;
    }

    /**
     * <p>
     * Determines whether the user can interrupt the start message while it is playing.
     * </p>
     * 
     * @return Determines whether the user can interrupt the start message while it is playing.
     */
    public final Boolean allowInterrupt() {
        return allowInterrupt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageGroups() ? messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowInterrupt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentStartResponseSpecification)) {
            return false;
        }
        FulfillmentStartResponseSpecification other = (FulfillmentStartResponseSpecification) obj;
        return Objects.equals(delayInSeconds(), other.delayInSeconds()) && hasMessageGroups() == other.hasMessageGroups()
                && Objects.equals(messageGroups(), other.messageGroups())
                && Objects.equals(allowInterrupt(), other.allowInterrupt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FulfillmentStartResponseSpecification").add("DelayInSeconds", delayInSeconds())
                .add("MessageGroups", hasMessageGroups() ? messageGroups() : null).add("AllowInterrupt", allowInterrupt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delayInSeconds":
            return Optional.ofNullable(clazz.cast(delayInSeconds()));
        case "messageGroups":
            return Optional.ofNullable(clazz.cast(messageGroups()));
        case "allowInterrupt":
            return Optional.ofNullable(clazz.cast(allowInterrupt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentStartResponseSpecification, T> g) {
        return obj -> g.apply((FulfillmentStartResponseSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FulfillmentStartResponseSpecification> {
        /**
         * <p>
         * The delay between when the Lambda fulfillment function starts running and the start message is played. If the
         * Lambda function returns before the delay is over, the start message isn't played.
         * </p>
         * 
         * @param delayInSeconds
         *        The delay between when the Lambda fulfillment function starts running and the start message is played.
         *        If the Lambda function returns before the delay is over, the start message isn't played.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delayInSeconds(Integer delayInSeconds);

        /**
         * <p>
         * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
         * </p>
         * 
         * @param messageGroups
         *        1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to
         *        the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(Collection<MessageGroup> messageGroups);

        /**
         * <p>
         * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
         * </p>
         * 
         * @param messageGroups
         *        1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to
         *        the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(MessageGroup... messageGroups);

        /**
         * <p>
         * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #messageGroups(List<MessageGroup>)}.
         * 
         * @param messageGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageGroups(java.util.Collection<MessageGroup>)
         */
        Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups);

        /**
         * <p>
         * Determines whether the user can interrupt the start message while it is playing.
         * </p>
         * 
         * @param allowInterrupt
         *        Determines whether the user can interrupt the start message while it is playing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowInterrupt(Boolean allowInterrupt);
    }

    static final class BuilderImpl implements Builder {
        private Integer delayInSeconds;

        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowInterrupt;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentStartResponseSpecification model) {
            delayInSeconds(model.delayInSeconds);
            messageGroups(model.messageGroups);
            allowInterrupt(model.allowInterrupt);
        }

        public final Integer getDelayInSeconds() {
            return delayInSeconds;
        }

        public final void setDelayInSeconds(Integer delayInSeconds) {
            this.delayInSeconds = delayInSeconds;
        }

        @Override
        public final Builder delayInSeconds(Integer delayInSeconds) {
            this.delayInSeconds = delayInSeconds;
            return this;
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup... messageGroups) {
            messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups) {
            messageGroups(Stream.of(messageGroups).map(c -> MessageGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowInterrupt() {
            return allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        @Override
        public FulfillmentStartResponseSpecification build() {
            return new FulfillmentStartResponseSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
