/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The test result evaluation item at the conversation level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLevelTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLevelTestResultItem.Builder, ConversationLevelTestResultItem> {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(ConversationLevelTestResultItem::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endToEndResult").getter(getter(ConversationLevelTestResultItem::endToEndResultAsString))
            .setter(setter(Builder::endToEndResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()).build();

    private static final SdkField<String> SPEECH_TRANSCRIPTION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("speechTranscriptionResult")
            .getter(getter(ConversationLevelTestResultItem::speechTranscriptionResultAsString))
            .setter(setter(Builder::speechTranscriptionResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResult").build())
            .build();

    private static final SdkField<List<ConversationLevelIntentClassificationResultItem>> INTENT_CLASSIFICATION_RESULTS_FIELD = SdkField
            .<List<ConversationLevelIntentClassificationResultItem>> builder(MarshallingType.LIST)
            .memberName("intentClassificationResults")
            .getter(getter(ConversationLevelTestResultItem::intentClassificationResults))
            .setter(setter(Builder::intentClassificationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClassificationResults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConversationLevelIntentClassificationResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConversationLevelIntentClassificationResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConversationLevelSlotResolutionResultItem>> SLOT_RESOLUTION_RESULTS_FIELD = SdkField
            .<List<ConversationLevelSlotResolutionResultItem>> builder(MarshallingType.LIST)
            .memberName("slotResolutionResults")
            .getter(getter(ConversationLevelTestResultItem::slotResolutionResults))
            .setter(setter(Builder::slotResolutionResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConversationLevelSlotResolutionResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConversationLevelSlotResolutionResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD,
            END_TO_END_RESULT_FIELD, SPEECH_TRANSCRIPTION_RESULT_FIELD, INTENT_CLASSIFICATION_RESULTS_FIELD,
            SLOT_RESOLUTION_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conversationId;

    private final String endToEndResult;

    private final String speechTranscriptionResult;

    private final List<ConversationLevelIntentClassificationResultItem> intentClassificationResults;

    private final List<ConversationLevelSlotResolutionResultItem> slotResolutionResults;

    private ConversationLevelTestResultItem(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.endToEndResult = builder.endToEndResult;
        this.speechTranscriptionResult = builder.speechTranscriptionResult;
        this.intentClassificationResults = builder.intentClassificationResults;
        this.slotResolutionResults = builder.slotResolutionResults;
    }

    /**
     * <p>
     * The conversation Id of the test result evaluation item.
     * </p>
     * 
     * @return The conversation Id of the test result evaluation item.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The end-to-end success or failure of the test result evaluation item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The end-to-end success or failure of the test result evaluation item.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(endToEndResult);
    }

    /**
     * <p>
     * The end-to-end success or failure of the test result evaluation item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The end-to-end success or failure of the test result evaluation item.
     * @see TestResultMatchStatus
     */
    public final String endToEndResultAsString() {
        return endToEndResult;
    }

    /**
     * <p>
     * The speech transcription success or failure of the test result evaluation item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return The speech transcription success or failure of the test result evaluation item.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus speechTranscriptionResult() {
        return TestResultMatchStatus.fromValue(speechTranscriptionResult);
    }

    /**
     * <p>
     * The speech transcription success or failure of the test result evaluation item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return The speech transcription success or failure of the test result evaluation item.
     * @see TestResultMatchStatus
     */
    public final String speechTranscriptionResultAsString() {
        return speechTranscriptionResult;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntentClassificationResults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIntentClassificationResults() {
        return intentClassificationResults != null && !(intentClassificationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The intent classification of the test result evaluation item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntentClassificationResults} method.
     * </p>
     * 
     * @return The intent classification of the test result evaluation item.
     */
    public final List<ConversationLevelIntentClassificationResultItem> intentClassificationResults() {
        return intentClassificationResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotResolutionResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSlotResolutionResults() {
        return slotResolutionResults != null && !(slotResolutionResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The slot success or failure of the test result evaluation item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotResolutionResults} method.
     * </p>
     * 
     * @return The slot success or failure of the test result evaluation item.
     */
    public final List<ConversationLevelSlotResolutionResultItem> slotResolutionResults() {
        return slotResolutionResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(endToEndResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speechTranscriptionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntentClassificationResults() ? intentClassificationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotResolutionResults() ? slotResolutionResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelTestResultItem)) {
            return false;
        }
        ConversationLevelTestResultItem other = (ConversationLevelTestResultItem) obj;
        return Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(endToEndResultAsString(), other.endToEndResultAsString())
                && Objects.equals(speechTranscriptionResultAsString(), other.speechTranscriptionResultAsString())
                && hasIntentClassificationResults() == other.hasIntentClassificationResults()
                && Objects.equals(intentClassificationResults(), other.intentClassificationResults())
                && hasSlotResolutionResults() == other.hasSlotResolutionResults()
                && Objects.equals(slotResolutionResults(), other.slotResolutionResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLevelTestResultItem").add("ConversationId", conversationId())
                .add("EndToEndResult", endToEndResultAsString())
                .add("SpeechTranscriptionResult", speechTranscriptionResultAsString())
                .add("IntentClassificationResults", hasIntentClassificationResults() ? intentClassificationResults() : null)
                .add("SlotResolutionResults", hasSlotResolutionResults() ? slotResolutionResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "endToEndResult":
            return Optional.ofNullable(clazz.cast(endToEndResultAsString()));
        case "speechTranscriptionResult":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultAsString()));
        case "intentClassificationResults":
            return Optional.ofNullable(clazz.cast(intentClassificationResults()));
        case "slotResolutionResults":
            return Optional.ofNullable(clazz.cast(slotResolutionResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelTestResultItem, T> g) {
        return obj -> g.apply((ConversationLevelTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLevelTestResultItem> {
        /**
         * <p>
         * The conversation Id of the test result evaluation item.
         * </p>
         * 
         * @param conversationId
         *        The conversation Id of the test result evaluation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The end-to-end success or failure of the test result evaluation item.
         * </p>
         * 
         * @param endToEndResult
         *        The end-to-end success or failure of the test result evaluation item.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(String endToEndResult);

        /**
         * <p>
         * The end-to-end success or failure of the test result evaluation item.
         * </p>
         * 
         * @param endToEndResult
         *        The end-to-end success or failure of the test result evaluation item.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(TestResultMatchStatus endToEndResult);

        /**
         * <p>
         * The speech transcription success or failure of the test result evaluation item.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        The speech transcription success or failure of the test result evaluation item.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(String speechTranscriptionResult);

        /**
         * <p>
         * The speech transcription success or failure of the test result evaluation item.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        The speech transcription success or failure of the test result evaluation item.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult);

        /**
         * <p>
         * The intent classification of the test result evaluation item.
         * </p>
         * 
         * @param intentClassificationResults
         *        The intent classification of the test result evaluation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClassificationResults(
                Collection<ConversationLevelIntentClassificationResultItem> intentClassificationResults);

        /**
         * <p>
         * The intent classification of the test result evaluation item.
         * </p>
         * 
         * @param intentClassificationResults
         *        The intent classification of the test result evaluation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClassificationResults(ConversationLevelIntentClassificationResultItem... intentClassificationResults);

        /**
         * <p>
         * The intent classification of the test result evaluation item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #intentClassificationResults(List<ConversationLevelIntentClassificationResultItem>)}.
         * 
         * @param intentClassificationResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClassificationResults(java.util.Collection<ConversationLevelIntentClassificationResultItem>)
         */
        Builder intentClassificationResults(
                Consumer<ConversationLevelIntentClassificationResultItem.Builder>... intentClassificationResults);

        /**
         * <p>
         * The slot success or failure of the test result evaluation item.
         * </p>
         * 
         * @param slotResolutionResults
         *        The slot success or failure of the test result evaluation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotResolutionResults(Collection<ConversationLevelSlotResolutionResultItem> slotResolutionResults);

        /**
         * <p>
         * The slot success or failure of the test result evaluation item.
         * </p>
         * 
         * @param slotResolutionResults
         *        The slot success or failure of the test result evaluation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotResolutionResults(ConversationLevelSlotResolutionResultItem... slotResolutionResults);

        /**
         * <p>
         * The slot success or failure of the test result evaluation item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #slotResolutionResults(List<ConversationLevelSlotResolutionResultItem>)}.
         * 
         * @param slotResolutionResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotResolutionResults(java.util.Collection<ConversationLevelSlotResolutionResultItem>)
         */
        Builder slotResolutionResults(Consumer<ConversationLevelSlotResolutionResultItem.Builder>... slotResolutionResults);
    }

    static final class BuilderImpl implements Builder {
        private String conversationId;

        private String endToEndResult;

        private String speechTranscriptionResult;

        private List<ConversationLevelIntentClassificationResultItem> intentClassificationResults = DefaultSdkAutoConstructList
                .getInstance();

        private List<ConversationLevelSlotResolutionResultItem> slotResolutionResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelTestResultItem model) {
            conversationId(model.conversationId);
            endToEndResult(model.endToEndResult);
            speechTranscriptionResult(model.speechTranscriptionResult);
            intentClassificationResults(model.intentClassificationResults);
            slotResolutionResults(model.slotResolutionResults);
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getEndToEndResult() {
            return endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        public final String getSpeechTranscriptionResult() {
            return speechTranscriptionResult;
        }

        public final void setSpeechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
        }

        @Override
        public final Builder speechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
            return this;
        }

        @Override
        public final Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult) {
            this.speechTranscriptionResult(speechTranscriptionResult == null ? null : speechTranscriptionResult.toString());
            return this;
        }

        public final List<ConversationLevelIntentClassificationResultItem.Builder> getIntentClassificationResults() {
            List<ConversationLevelIntentClassificationResultItem.Builder> result = ConversationLevelIntentClassificationResultsCopier
                    .copyToBuilder(this.intentClassificationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntentClassificationResults(
                Collection<ConversationLevelIntentClassificationResultItem.BuilderImpl> intentClassificationResults) {
            this.intentClassificationResults = ConversationLevelIntentClassificationResultsCopier
                    .copyFromBuilder(intentClassificationResults);
        }

        @Override
        public final Builder intentClassificationResults(
                Collection<ConversationLevelIntentClassificationResultItem> intentClassificationResults) {
            this.intentClassificationResults = ConversationLevelIntentClassificationResultsCopier
                    .copy(intentClassificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentClassificationResults(
                ConversationLevelIntentClassificationResultItem... intentClassificationResults) {
            intentClassificationResults(Arrays.asList(intentClassificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentClassificationResults(
                Consumer<ConversationLevelIntentClassificationResultItem.Builder>... intentClassificationResults) {
            intentClassificationResults(Stream.of(intentClassificationResults)
                    .map(c -> ConversationLevelIntentClassificationResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConversationLevelSlotResolutionResultItem.Builder> getSlotResolutionResults() {
            List<ConversationLevelSlotResolutionResultItem.Builder> result = ConversationLevelSlotResolutionResultsCopier
                    .copyToBuilder(this.slotResolutionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotResolutionResults(
                Collection<ConversationLevelSlotResolutionResultItem.BuilderImpl> slotResolutionResults) {
            this.slotResolutionResults = ConversationLevelSlotResolutionResultsCopier.copyFromBuilder(slotResolutionResults);
        }

        @Override
        public final Builder slotResolutionResults(Collection<ConversationLevelSlotResolutionResultItem> slotResolutionResults) {
            this.slotResolutionResults = ConversationLevelSlotResolutionResultsCopier.copy(slotResolutionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(ConversationLevelSlotResolutionResultItem... slotResolutionResults) {
            slotResolutionResults(Arrays.asList(slotResolutionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(
                Consumer<ConversationLevelSlotResolutionResultItem.Builder>... slotResolutionResults) {
            slotResolutionResults(Stream.of(slotResolutionResults)
                    .map(c -> ConversationLevelSlotResolutionResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConversationLevelTestResultItem build() {
            return new ConversationLevelTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
