/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTestSetDiscrepancyReportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateTestSetDiscrepancyReportResponse.Builder, CreateTestSetDiscrepancyReportResponse> {
    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("testSetDiscrepancyReportId")
            .getter(getter(CreateTestSetDiscrepancyReportResponse::testSetDiscrepancyReportId))
            .setter(setter(Builder::testSetDiscrepancyReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyReportId").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateTestSetDiscrepancyReportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(CreateTestSetDiscrepancyReportResponse::testSetId))
            .setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<TestSetDiscrepancyReportResourceTarget> TARGET_FIELD = SdkField
            .<TestSetDiscrepancyReportResourceTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(CreateTestSetDiscrepancyReportResponse::target)).setter(setter(Builder::target))
            .constructor(TestSetDiscrepancyReportResourceTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TEST_SET_DISCREPANCY_REPORT_ID_FIELD, CREATION_DATE_TIME_FIELD, TEST_SET_ID_FIELD, TARGET_FIELD));

    private final String testSetDiscrepancyReportId;

    private final Instant creationDateTime;

    private final String testSetId;

    private final TestSetDiscrepancyReportResourceTarget target;

    private CreateTestSetDiscrepancyReportResponse(BuilderImpl builder) {
        super(builder);
        this.testSetDiscrepancyReportId = builder.testSetDiscrepancyReportId;
        this.creationDateTime = builder.creationDateTime;
        this.testSetId = builder.testSetId;
        this.target = builder.target;
    }

    /**
     * <p>
     * The unique identifier of the test set discrepancy report to describe.
     * </p>
     * 
     * @return The unique identifier of the test set discrepancy report to describe.
     */
    public final String testSetDiscrepancyReportId() {
        return testSetDiscrepancyReportId;
    }

    /**
     * <p>
     * The creation date and time for the test set discrepancy report.
     * </p>
     * 
     * @return The creation date and time for the test set discrepancy report.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The test set Id for the test set discrepancy report.
     * </p>
     * 
     * @return The test set Id for the test set discrepancy report.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The target bot for the test set discrepancy report.
     * </p>
     * 
     * @return The target bot for the test set discrepancy report.
     */
    public final TestSetDiscrepancyReportResourceTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyReportId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestSetDiscrepancyReportResponse)) {
            return false;
        }
        CreateTestSetDiscrepancyReportResponse other = (CreateTestSetDiscrepancyReportResponse) obj;
        return Objects.equals(testSetDiscrepancyReportId(), other.testSetDiscrepancyReportId())
                && Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(testSetId(), other.testSetId())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTestSetDiscrepancyReportResponse")
                .add("TestSetDiscrepancyReportId", testSetDiscrepancyReportId()).add("CreationDateTime", creationDateTime())
                .add("TestSetId", testSetId()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetDiscrepancyReportId":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyReportId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTestSetDiscrepancyReportResponse, T> g) {
        return obj -> g.apply((CreateTestSetDiscrepancyReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTestSetDiscrepancyReportResponse> {
        /**
         * <p>
         * The unique identifier of the test set discrepancy report to describe.
         * </p>
         * 
         * @param testSetDiscrepancyReportId
         *        The unique identifier of the test set discrepancy report to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId);

        /**
         * <p>
         * The creation date and time for the test set discrepancy report.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The test set Id for the test set discrepancy report.
         * </p>
         * 
         * @param testSetId
         *        The test set Id for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The target bot for the test set discrepancy report.
         * </p>
         * 
         * @param target
         *        The target bot for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TestSetDiscrepancyReportResourceTarget target);

        /**
         * <p>
         * The target bot for the test set discrepancy report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TestSetDiscrepancyReportResourceTarget.Builder} avoiding the need to create one manually via
         * {@link TestSetDiscrepancyReportResourceTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetDiscrepancyReportResourceTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(TestSetDiscrepancyReportResourceTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TestSetDiscrepancyReportResourceTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TestSetDiscrepancyReportResourceTarget)
         */
        default Builder target(Consumer<TestSetDiscrepancyReportResourceTarget.Builder> target) {
            return target(TestSetDiscrepancyReportResourceTarget.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testSetDiscrepancyReportId;

        private Instant creationDateTime;

        private String testSetId;

        private TestSetDiscrepancyReportResourceTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestSetDiscrepancyReportResponse model) {
            super(model);
            testSetDiscrepancyReportId(model.testSetDiscrepancyReportId);
            creationDateTime(model.creationDateTime);
            testSetId(model.testSetId);
            target(model.target);
        }

        public final String getTestSetDiscrepancyReportId() {
            return testSetDiscrepancyReportId;
        }

        public final void setTestSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
        }

        @Override
        public final Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final TestSetDiscrepancyReportResourceTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TestSetDiscrepancyReportResourceTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestSetDiscrepancyReportResourceTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public CreateTestSetDiscrepancyReportResponse build() {
            return new CreateTestSetDiscrepancyReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
