/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionReplicasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionReplicasResponse;

public class ListBotVersionReplicasIterable
implements SdkIterable<ListBotVersionReplicasResponse> {
    private final LexModelsV2Client client;
    private final ListBotVersionReplicasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotVersionReplicasIterable(LexModelsV2Client client, ListBotVersionReplicasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBotVersionReplicasResponseFetcher();
    }

    public Iterator<ListBotVersionReplicasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotVersionReplicasResponseFetcher
    implements SyncPageFetcher<ListBotVersionReplicasResponse> {
        private ListBotVersionReplicasResponseFetcher() {
        }

        public boolean hasNextPage(ListBotVersionReplicasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotVersionReplicasResponse nextPage(ListBotVersionReplicasResponse previousPage) {
            if (previousPage == null) {
                return ListBotVersionReplicasIterable.this.client.listBotVersionReplicas(ListBotVersionReplicasIterable.this.firstRequest);
            }
            return ListBotVersionReplicasIterable.this.client.listBotVersionReplicas((ListBotVersionReplicasRequest)((Object)ListBotVersionReplicasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

