/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2Waiter;
import software.amazon.awssdk.services.lexmodelsv2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultLexModelsV2Waiter
implements LexModelsV2Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final LexModelsV2Client client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeBotResponse> botAvailableWaiter;
    private final Waiter<DescribeBotAliasResponse> botAliasAvailableWaiter;
    private final Waiter<DescribeExportResponse> botExportCompletedWaiter;
    private final Waiter<DescribeImportResponse> botImportCompletedWaiter;
    private final Waiter<DescribeBotLocaleResponse> botLocaleBuiltWaiter;
    private final Waiter<DescribeBotLocaleResponse> botLocaleExpressTestingAvailableWaiter;
    private final Waiter<DescribeBotVersionResponse> botVersionAvailableWaiter;
    private final Waiter<DescribeBotLocaleResponse> botLocaleCreatedWaiter;

    private DefaultLexModelsV2Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (LexModelsV2Client)LexModelsV2Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.botAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotResponse.class).acceptors(DefaultLexModelsV2Waiter.botAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.botAliasAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotAliasResponse.class).acceptors(DefaultLexModelsV2Waiter.botAliasAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botAliasAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.botExportCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeExportResponse.class).acceptors(DefaultLexModelsV2Waiter.botExportCompletedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botExportCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.botImportCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImportResponse.class).acceptors(DefaultLexModelsV2Waiter.botImportCompletedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botImportCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.botLocaleBuiltWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2Waiter.botLocaleBuiltWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botLocaleBuiltWaiterConfig(builder.overrideConfiguration))).build();
        this.botLocaleExpressTestingAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2Waiter.botLocaleExpressTestingAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botLocaleExpressTestingAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.botVersionAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotVersionResponse.class).acceptors(DefaultLexModelsV2Waiter.botVersionAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botVersionAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.botLocaleCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2Waiter.botLocaleCreatedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2Waiter.botLocaleCreatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeBotAliasResponse> waitUntilBotAliasAvailable(DescribeBotAliasRequest describeBotAliasRequest) {
        return this.botAliasAvailableWaiter.run(() -> this.client.describeBotAlias(this.applyWaitersUserAgent(describeBotAliasRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotAliasResponse> waitUntilBotAliasAvailable(DescribeBotAliasRequest describeBotAliasRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botAliasAvailableWaiter.run(() -> this.client.describeBotAlias(this.applyWaitersUserAgent(describeBotAliasRequest)), DefaultLexModelsV2Waiter.botAliasAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeBotResponse> waitUntilBotAvailable(DescribeBotRequest describeBotRequest) {
        return this.botAvailableWaiter.run(() -> this.client.describeBot(this.applyWaitersUserAgent(describeBotRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotResponse> waitUntilBotAvailable(DescribeBotRequest describeBotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botAvailableWaiter.run(() -> this.client.describeBot(this.applyWaitersUserAgent(describeBotRequest)), DefaultLexModelsV2Waiter.botAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportResponse> waitUntilBotExportCompleted(DescribeExportRequest describeExportRequest) {
        return this.botExportCompletedWaiter.run(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportResponse> waitUntilBotExportCompleted(DescribeExportRequest describeExportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botExportCompletedWaiter.run(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)), DefaultLexModelsV2Waiter.botExportCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImportResponse> waitUntilBotImportCompleted(DescribeImportRequest describeImportRequest) {
        return this.botImportCompletedWaiter.run(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)));
    }

    @Override
    public WaiterResponse<DescribeImportResponse> waitUntilBotImportCompleted(DescribeImportRequest describeImportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botImportCompletedWaiter.run(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)), DefaultLexModelsV2Waiter.botImportCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleBuilt(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleBuiltWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleBuilt(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleBuiltWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2Waiter.botLocaleBuiltWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleCreated(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleCreatedWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleCreated(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleCreatedWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2Waiter.botLocaleCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleExpressTestingAvailableWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotLocaleResponse> waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleExpressTestingAvailableWaiter.run(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2Waiter.botLocaleExpressTestingAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeBotVersionResponse> waitUntilBotVersionAvailable(DescribeBotVersionRequest describeBotVersionRequest) {
        return this.botVersionAvailableWaiter.run(() -> this.client.describeBotVersion(this.applyWaitersUserAgent(describeBotVersionRequest)));
    }

    @Override
    public WaiterResponse<DescribeBotVersionResponse> waitUntilBotVersionAvailable(DescribeBotVersionRequest describeBotVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botVersionAvailableWaiter.run(() -> this.client.describeBotVersion(this.applyWaitersUserAgent(describeBotVersionRequest)), DefaultLexModelsV2Waiter.botVersionAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeBotResponse>> botAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Inactive");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Inactive) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotAliasResponse>> botAliasAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotAliasResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotAliasResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botAliasStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botAliasStatus=Deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportResponse>> botExportCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (exportStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (exportStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportResponse>> botImportCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (importStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (importStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleBuiltWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=NotBuilt) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleExpressTestingAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "ReadyExpressTesting");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=NotBuilt) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotVersionResponse>> botVersionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Failed) and transitioned the waiter to failure state"));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "ReadyExpressTesting");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration botAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botAliasAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botExportCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botImportCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleBuiltWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleExpressTestingAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botVersionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static LexModelsV2Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends LexModelsV2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LexModelsV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements LexModelsV2Waiter.Builder {
        private LexModelsV2Client client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public LexModelsV2Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public LexModelsV2Waiter.Builder client(LexModelsV2Client client) {
            this.client = client;
            return this;
        }

        @Override
        public LexModelsV2Waiter build() {
            return new DefaultLexModelsV2Waiter(this);
        }
    }
}

