/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the configuration of a Amazon Bedrock knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockKnowledgeStoreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockKnowledgeStoreConfiguration.Builder, BedrockKnowledgeStoreConfiguration> {
    private static final SdkField<String> BEDROCK_KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bedrockKnowledgeBaseArn").getter(getter(BedrockKnowledgeStoreConfiguration::bedrockKnowledgeBaseArn))
            .setter(setter(Builder::bedrockKnowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BEDROCK_KNOWLEDGE_BASE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bedrockKnowledgeBaseArn;

    private BedrockKnowledgeStoreConfiguration(BuilderImpl builder) {
        this.bedrockKnowledgeBaseArn = builder.bedrockKnowledgeBaseArn;
    }

    /**
     * <p>
     * The ARN of the knowledge base used.
     * </p>
     * 
     * @return The ARN of the knowledge base used.
     */
    public final String bedrockKnowledgeBaseArn() {
        return bedrockKnowledgeBaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockKnowledgeBaseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockKnowledgeStoreConfiguration)) {
            return false;
        }
        BedrockKnowledgeStoreConfiguration other = (BedrockKnowledgeStoreConfiguration) obj;
        return Objects.equals(bedrockKnowledgeBaseArn(), other.bedrockKnowledgeBaseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockKnowledgeStoreConfiguration").add("BedrockKnowledgeBaseArn", bedrockKnowledgeBaseArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockKnowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(bedrockKnowledgeBaseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BedrockKnowledgeStoreConfiguration, T> g) {
        return obj -> g.apply((BedrockKnowledgeStoreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockKnowledgeStoreConfiguration> {
        /**
         * <p>
         * The ARN of the knowledge base used.
         * </p>
         * 
         * @param bedrockKnowledgeBaseArn
         *        The ARN of the knowledge base used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn);
    }

    static final class BuilderImpl implements Builder {
        private String bedrockKnowledgeBaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockKnowledgeStoreConfiguration model) {
            bedrockKnowledgeBaseArn(model.bedrockKnowledgeBaseArn);
        }

        public final String getBedrockKnowledgeBaseArn() {
            return bedrockKnowledgeBaseArn;
        }

        public final void setBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
        }

        @Override
        public final Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
            return this;
        }

        @Override
        public BedrockKnowledgeStoreConfiguration build() {
            return new BedrockKnowledgeStoreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
