/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSortBy;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotVersionReplicasRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListBotVersionReplicasRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotVersionReplicasRequest.getter(ListBotVersionReplicasRequest::botId)).setter(ListBotVersionReplicasRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicaRegion").getter(ListBotVersionReplicasRequest.getter(ListBotVersionReplicasRequest::replicaRegion)).setter(ListBotVersionReplicasRequest.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicaRegion").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBotVersionReplicasRequest.getter(ListBotVersionReplicasRequest::maxResults)).setter(ListBotVersionReplicasRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotVersionReplicasRequest.getter(ListBotVersionReplicasRequest::nextToken)).setter(ListBotVersionReplicasRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<BotVersionReplicaSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListBotVersionReplicasRequest.getter(ListBotVersionReplicasRequest::sortBy)).setter(ListBotVersionReplicasRequest.setter(Builder::sortBy)).constructor(BotVersionReplicaSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, REPLICA_REGION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD));
    private final String botId;
    private final String replicaRegion;
    private final Integer maxResults;
    private final String nextToken;
    private final BotVersionReplicaSortBy sortBy;

    private ListBotVersionReplicasRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.replicaRegion = builder.replicaRegion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    public final String botId() {
        return this.botId;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final BotVersionReplicaSortBy sortBy() {
        return this.sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionReplicasRequest)) {
            return false;
        }
        ListBotVersionReplicasRequest other = (ListBotVersionReplicasRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortBy(), other.sortBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotVersionReplicasRequest").add("BotId", (Object)this.botId()).add("ReplicaRegion", (Object)this.replicaRegion()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "replicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionReplicasRequest, T> g) {
        return obj -> g.apply((ListBotVersionReplicasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String replicaRegion;
        private Integer maxResults;
        private String nextToken;
        private BotVersionReplicaSortBy sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionReplicasRequest model) {
            super(model);
            this.botId(model.botId);
            this.replicaRegion(model.replicaRegion);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final BotVersionReplicaSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(BotVersionReplicaSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(BotVersionReplicaSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBotVersionReplicasRequest build() {
            return new ListBotVersionReplicasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotVersionReplicasRequest> {
        public Builder botId(String var1);

        public Builder replicaRegion(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(BotVersionReplicaSortBy var1);

        default public Builder sortBy(Consumer<BotVersionReplicaSortBy.Builder> sortBy) {
            return this.sortBy((BotVersionReplicaSortBy)((BotVersionReplicaSortBy.Builder)BotVersionReplicaSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

