/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SlotValueResolutionStrategy {
    ORIGINAL_VALUE("OriginalValue"),
    TOP_RESOLUTION("TopResolution"),
    CONCATENATION("Concatenation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SlotValueResolutionStrategy> VALUE_MAP;
    private final String value;

    private SlotValueResolutionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlotValueResolutionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlotValueResolutionStrategy> knownValues() {
        EnumSet<SlotValueResolutionStrategy> knownValues = EnumSet.allOf(SlotValueResolutionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SlotValueResolutionStrategy.class, SlotValueResolutionStrategy::toString);
    }
}

