/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionApiMode;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionModality;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestExecutionSummary> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testExecutionId").getter(TestExecutionSummary.getter(TestExecutionSummary::testExecutionId)).setter(TestExecutionSummary.setter(Builder::testExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(TestExecutionSummary.getter(TestExecutionSummary::creationDateTime)).setter(TestExecutionSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(TestExecutionSummary.getter(TestExecutionSummary::lastUpdatedDateTime)).setter(TestExecutionSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> TEST_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testExecutionStatus").getter(TestExecutionSummary.getter(TestExecutionSummary::testExecutionStatusAsString)).setter(TestExecutionSummary.setter(Builder::testExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionStatus").build()}).build();
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetId").getter(TestExecutionSummary.getter(TestExecutionSummary::testSetId)).setter(TestExecutionSummary.setter(Builder::testSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()}).build();
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetName").getter(TestExecutionSummary.getter(TestExecutionSummary::testSetName)).setter(TestExecutionSummary.setter(Builder::testSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()}).build();
    private static final SdkField<TestExecutionTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(TestExecutionSummary.getter(TestExecutionSummary::target)).setter(TestExecutionSummary.setter(Builder::target)).constructor(TestExecutionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> API_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiMode").getter(TestExecutionSummary.getter(TestExecutionSummary::apiModeAsString)).setter(TestExecutionSummary.setter(Builder::apiMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMode").build()}).build();
    private static final SdkField<String> TEST_EXECUTION_MODALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testExecutionModality").getter(TestExecutionSummary.getter(TestExecutionSummary::testExecutionModalityAsString)).setter(TestExecutionSummary.setter(Builder::testExecutionModality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionModality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, TEST_EXECUTION_STATUS_FIELD, TEST_SET_ID_FIELD, TEST_SET_NAME_FIELD, TARGET_FIELD, API_MODE_FIELD, TEST_EXECUTION_MODALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String testExecutionId;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String testExecutionStatus;
    private final String testSetId;
    private final String testSetName;
    private final TestExecutionTarget target;
    private final String apiMode;
    private final String testExecutionModality;

    private TestExecutionSummary(BuilderImpl builder) {
        this.testExecutionId = builder.testExecutionId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.testExecutionStatus = builder.testExecutionStatus;
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.target = builder.target;
        this.apiMode = builder.apiMode;
        this.testExecutionModality = builder.testExecutionModality;
    }

    public final String testExecutionId() {
        return this.testExecutionId;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final TestExecutionStatus testExecutionStatus() {
        return TestExecutionStatus.fromValue(this.testExecutionStatus);
    }

    public final String testExecutionStatusAsString() {
        return this.testExecutionStatus;
    }

    public final String testSetId() {
        return this.testSetId;
    }

    public final String testSetName() {
        return this.testSetName;
    }

    public final TestExecutionTarget target() {
        return this.target;
    }

    public final TestExecutionApiMode apiMode() {
        return TestExecutionApiMode.fromValue(this.apiMode);
    }

    public final String apiModeAsString() {
        return this.apiMode;
    }

    public final TestExecutionModality testExecutionModality() {
        return TestExecutionModality.fromValue(this.testExecutionModality);
    }

    public final String testExecutionModalityAsString() {
        return this.testExecutionModality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.testExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.testExecutionModalityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestExecutionSummary)) {
            return false;
        }
        TestExecutionSummary other = (TestExecutionSummary)obj;
        return Objects.equals(this.testExecutionId(), other.testExecutionId()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.testExecutionStatusAsString(), other.testExecutionStatusAsString()) && Objects.equals(this.testSetId(), other.testSetId()) && Objects.equals(this.testSetName(), other.testSetName()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.apiModeAsString(), other.apiModeAsString()) && Objects.equals(this.testExecutionModalityAsString(), other.testExecutionModalityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TestExecutionSummary").add("TestExecutionId", (Object)this.testExecutionId()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("TestExecutionStatus", (Object)this.testExecutionStatusAsString()).add("TestSetId", (Object)this.testSetId()).add("TestSetName", (Object)this.testSetName()).add("Target", (Object)this.target()).add("ApiMode", (Object)this.apiModeAsString()).add("TestExecutionModality", (Object)this.testExecutionModalityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testExecutionId": {
                return Optional.ofNullable(clazz.cast(this.testExecutionId()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "testExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.testExecutionStatusAsString()));
            }
            case "testSetId": {
                return Optional.ofNullable(clazz.cast(this.testSetId()));
            }
            case "testSetName": {
                return Optional.ofNullable(clazz.cast(this.testSetName()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "apiMode": {
                return Optional.ofNullable(clazz.cast(this.apiModeAsString()));
            }
            case "testExecutionModality": {
                return Optional.ofNullable(clazz.cast(this.testExecutionModalityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestExecutionSummary, T> g) {
        return obj -> g.apply((TestExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testExecutionId;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String testExecutionStatus;
        private String testSetId;
        private String testSetName;
        private TestExecutionTarget target;
        private String apiMode;
        private String testExecutionModality;

        private BuilderImpl() {
        }

        private BuilderImpl(TestExecutionSummary model) {
            this.testExecutionId(model.testExecutionId);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.testExecutionStatus(model.testExecutionStatus);
            this.testSetId(model.testSetId);
            this.testSetName(model.testSetName);
            this.target(model.target);
            this.apiMode(model.apiMode);
            this.testExecutionModality(model.testExecutionModality);
        }

        public final String getTestExecutionId() {
            return this.testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getTestExecutionStatus() {
            return this.testExecutionStatus;
        }

        public final void setTestExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
        }

        @Override
        public final Builder testExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
            return this;
        }

        @Override
        public final Builder testExecutionStatus(TestExecutionStatus testExecutionStatus) {
            this.testExecutionStatus(testExecutionStatus == null ? null : testExecutionStatus.toString());
            return this;
        }

        public final String getTestSetId() {
            return this.testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return this.testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final TestExecutionTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(TestExecutionTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestExecutionTarget target) {
            this.target = target;
            return this;
        }

        public final String getApiMode() {
            return this.apiMode;
        }

        public final void setApiMode(String apiMode) {
            this.apiMode = apiMode;
        }

        @Override
        public final Builder apiMode(String apiMode) {
            this.apiMode = apiMode;
            return this;
        }

        @Override
        public final Builder apiMode(TestExecutionApiMode apiMode) {
            this.apiMode(apiMode == null ? null : apiMode.toString());
            return this;
        }

        public final String getTestExecutionModality() {
            return this.testExecutionModality;
        }

        public final void setTestExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
        }

        @Override
        public final Builder testExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
            return this;
        }

        @Override
        public final Builder testExecutionModality(TestExecutionModality testExecutionModality) {
            this.testExecutionModality(testExecutionModality == null ? null : testExecutionModality.toString());
            return this;
        }

        public TestExecutionSummary build() {
            return new TestExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestExecutionSummary> {
        public Builder testExecutionId(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder testExecutionStatus(String var1);

        public Builder testExecutionStatus(TestExecutionStatus var1);

        public Builder testSetId(String var1);

        public Builder testSetName(String var1);

        public Builder target(TestExecutionTarget var1);

        default public Builder target(Consumer<TestExecutionTarget.Builder> target) {
            return this.target((TestExecutionTarget)((TestExecutionTarget.Builder)TestExecutionTarget.builder().applyMutation(target)).build());
        }

        public Builder apiMode(String var1);

        public Builder apiMode(TestExecutionApiMode var1);

        public Builder testExecutionModality(String var1);

        public Builder testExecutionModality(TestExecutionModality var1);
    }
}

