/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotAliasReplicasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotAliasReplicasResponse.Builder, ListBotAliasReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotAliasReplicasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(ListBotAliasReplicasResponse::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicaRegion").getter(getter(ListBotAliasReplicasResponse::replicaRegion))
            .setter(setter(Builder::replicaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()).build();

    private static final SdkField<List<BotAliasReplicaSummary>> BOT_ALIAS_REPLICA_SUMMARIES_FIELD = SdkField
            .<List<BotAliasReplicaSummary>> builder(MarshallingType.LIST)
            .memberName("botAliasReplicaSummaries")
            .getter(getter(ListBotAliasReplicasResponse::botAliasReplicaSummaries))
            .setter(setter(Builder::botAliasReplicaSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasReplicaSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotAliasReplicaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasReplicaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotAliasReplicasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            SOURCE_REGION_FIELD, REPLICA_REGION_FIELD, BOT_ALIAS_REPLICA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String sourceRegion;

    private final String replicaRegion;

    private final List<BotAliasReplicaSummary> botAliasReplicaSummaries;

    private final String nextToken;

    private ListBotAliasReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.replicaRegion = builder.replicaRegion;
        this.botAliasReplicaSummaries = builder.botAliasReplicaSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique bot ID of the replicated bot created from the source bot alias.
     * </p>
     * 
     * @return The unique bot ID of the replicated bot created from the source bot alias.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The source region of the replicated bot created from the source bot alias.
     * </p>
     * 
     * @return The source region of the replicated bot created from the source bot alias.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The secondary region of the replicated bot created from the source bot alias.
     * </p>
     * 
     * @return The secondary region of the replicated bot created from the source bot alias.
     */
    public final String replicaRegion() {
        return replicaRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotAliasReplicaSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotAliasReplicaSummaries() {
        return botAliasReplicaSummaries != null && !(botAliasReplicaSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary information of the replicated bot created from the source bot alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotAliasReplicaSummaries} method.
     * </p>
     * 
     * @return The summary information of the replicated bot created from the source bot alias.
     */
    public final List<BotAliasReplicaSummary> botAliasReplicaSummaries() {
        return botAliasReplicaSummaries;
    }

    /**
     * <p>
     * The next token for the replicated bots created from the source bot alias.
     * </p>
     * 
     * @return The next token for the replicated bots created from the source bot alias.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasReplicaSummaries() ? botAliasReplicaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotAliasReplicasResponse)) {
            return false;
        }
        ListBotAliasReplicasResponse other = (ListBotAliasReplicasResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(replicaRegion(), other.replicaRegion())
                && hasBotAliasReplicaSummaries() == other.hasBotAliasReplicaSummaries()
                && Objects.equals(botAliasReplicaSummaries(), other.botAliasReplicaSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotAliasReplicasResponse").add("BotId", botId()).add("SourceRegion", sourceRegion())
                .add("ReplicaRegion", replicaRegion())
                .add("BotAliasReplicaSummaries", hasBotAliasReplicaSummaries() ? botAliasReplicaSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "replicaRegion":
            return Optional.ofNullable(clazz.cast(replicaRegion()));
        case "botAliasReplicaSummaries":
            return Optional.ofNullable(clazz.cast(botAliasReplicaSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotAliasReplicasResponse, T> g) {
        return obj -> g.apply((ListBotAliasReplicasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotAliasReplicasResponse> {
        /**
         * <p>
         * The unique bot ID of the replicated bot created from the source bot alias.
         * </p>
         * 
         * @param botId
         *        The unique bot ID of the replicated bot created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The source region of the replicated bot created from the source bot alias.
         * </p>
         * 
         * @param sourceRegion
         *        The source region of the replicated bot created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The secondary region of the replicated bot created from the source bot alias.
         * </p>
         * 
         * @param replicaRegion
         *        The secondary region of the replicated bot created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaRegion(String replicaRegion);

        /**
         * <p>
         * The summary information of the replicated bot created from the source bot alias.
         * </p>
         * 
         * @param botAliasReplicaSummaries
         *        The summary information of the replicated bot created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasReplicaSummaries(Collection<BotAliasReplicaSummary> botAliasReplicaSummaries);

        /**
         * <p>
         * The summary information of the replicated bot created from the source bot alias.
         * </p>
         * 
         * @param botAliasReplicaSummaries
         *        The summary information of the replicated bot created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasReplicaSummaries(BotAliasReplicaSummary... botAliasReplicaSummaries);

        /**
         * <p>
         * The summary information of the replicated bot created from the source bot alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botAliasReplicaSummaries(List<BotAliasReplicaSummary>)}.
         * 
         * @param botAliasReplicaSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliasReplicaSummaries(java.util.Collection<BotAliasReplicaSummary>)
         */
        Builder botAliasReplicaSummaries(Consumer<BotAliasReplicaSummary.Builder>... botAliasReplicaSummaries);

        /**
         * <p>
         * The next token for the replicated bots created from the source bot alias.
         * </p>
         * 
         * @param nextToken
         *        The next token for the replicated bots created from the source bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String sourceRegion;

        private String replicaRegion;

        private List<BotAliasReplicaSummary> botAliasReplicaSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotAliasReplicasResponse model) {
            super(model);
            botId(model.botId);
            sourceRegion(model.sourceRegion);
            replicaRegion(model.replicaRegion);
            botAliasReplicaSummaries(model.botAliasReplicaSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getReplicaRegion() {
            return replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final List<BotAliasReplicaSummary.Builder> getBotAliasReplicaSummaries() {
            List<BotAliasReplicaSummary.Builder> result = BotAliasReplicaSummaryListCopier
                    .copyToBuilder(this.botAliasReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotAliasReplicaSummaries(Collection<BotAliasReplicaSummary.BuilderImpl> botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries = BotAliasReplicaSummaryListCopier.copyFromBuilder(botAliasReplicaSummaries);
        }

        @Override
        public final Builder botAliasReplicaSummaries(Collection<BotAliasReplicaSummary> botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries = BotAliasReplicaSummaryListCopier.copy(botAliasReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasReplicaSummaries(BotAliasReplicaSummary... botAliasReplicaSummaries) {
            botAliasReplicaSummaries(Arrays.asList(botAliasReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasReplicaSummaries(Consumer<BotAliasReplicaSummary.Builder>... botAliasReplicaSummaries) {
            botAliasReplicaSummaries(Stream.of(botAliasReplicaSummaries)
                    .map(c -> BotAliasReplicaSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotAliasReplicasResponse build() {
            return new ListBotAliasReplicasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
