/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotVersionReplicasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotVersionReplicasResponse.Builder, ListBotVersionReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotVersionReplicasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(ListBotVersionReplicasResponse::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicaRegion").getter(getter(ListBotVersionReplicasResponse::replicaRegion))
            .setter(setter(Builder::replicaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()).build();

    private static final SdkField<List<BotVersionReplicaSummary>> BOT_VERSION_REPLICA_SUMMARIES_FIELD = SdkField
            .<List<BotVersionReplicaSummary>> builder(MarshallingType.LIST)
            .memberName("botVersionReplicaSummaries")
            .getter(getter(ListBotVersionReplicasResponse::botVersionReplicaSummaries))
            .setter(setter(Builder::botVersionReplicaSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionReplicaSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotVersionReplicaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotVersionReplicaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotVersionReplicasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            SOURCE_REGION_FIELD, REPLICA_REGION_FIELD, BOT_VERSION_REPLICA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String sourceRegion;

    private final String replicaRegion;

    private final List<BotVersionReplicaSummary> botVersionReplicaSummaries;

    private final String nextToken;

    private ListBotVersionReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.replicaRegion = builder.replicaRegion;
        this.botVersionReplicaSummaries = builder.botVersionReplicaSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique ID of the bots in the list of replicated bots.
     * </p>
     * 
     * @return The unique ID of the bots in the list of replicated bots.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The source region used for the bots in the list of replicated bots.
     * </p>
     * 
     * @return The source region used for the bots in the list of replicated bots.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The region used for the replicated bots in the list of replicated bots.
     * </p>
     * 
     * @return The region used for the replicated bots in the list of replicated bots.
     */
    public final String replicaRegion() {
        return replicaRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotVersionReplicaSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotVersionReplicaSummaries() {
        return botVersionReplicaSummaries != null && !(botVersionReplicaSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information summary used for the replicated bots in the list of replicated bots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotVersionReplicaSummaries} method.
     * </p>
     * 
     * @return The information summary used for the replicated bots in the list of replicated bots.
     */
    public final List<BotVersionReplicaSummary> botVersionReplicaSummaries() {
        return botVersionReplicaSummaries;
    }

    /**
     * <p>
     * The next token used for the replicated bots in the list of replicated bots.
     * </p>
     * 
     * @return The next token used for the replicated bots in the list of replicated bots.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotVersionReplicaSummaries() ? botVersionReplicaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionReplicasResponse)) {
            return false;
        }
        ListBotVersionReplicasResponse other = (ListBotVersionReplicasResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(replicaRegion(), other.replicaRegion())
                && hasBotVersionReplicaSummaries() == other.hasBotVersionReplicaSummaries()
                && Objects.equals(botVersionReplicaSummaries(), other.botVersionReplicaSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotVersionReplicasResponse").add("BotId", botId()).add("SourceRegion", sourceRegion())
                .add("ReplicaRegion", replicaRegion())
                .add("BotVersionReplicaSummaries", hasBotVersionReplicaSummaries() ? botVersionReplicaSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "replicaRegion":
            return Optional.ofNullable(clazz.cast(replicaRegion()));
        case "botVersionReplicaSummaries":
            return Optional.ofNullable(clazz.cast(botVersionReplicaSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionReplicasResponse, T> g) {
        return obj -> g.apply((ListBotVersionReplicasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBotVersionReplicasResponse> {
        /**
         * <p>
         * The unique ID of the bots in the list of replicated bots.
         * </p>
         * 
         * @param botId
         *        The unique ID of the bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The source region used for the bots in the list of replicated bots.
         * </p>
         * 
         * @param sourceRegion
         *        The source region used for the bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The region used for the replicated bots in the list of replicated bots.
         * </p>
         * 
         * @param replicaRegion
         *        The region used for the replicated bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaRegion(String replicaRegion);

        /**
         * <p>
         * The information summary used for the replicated bots in the list of replicated bots.
         * </p>
         * 
         * @param botVersionReplicaSummaries
         *        The information summary used for the replicated bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionReplicaSummaries(Collection<BotVersionReplicaSummary> botVersionReplicaSummaries);

        /**
         * <p>
         * The information summary used for the replicated bots in the list of replicated bots.
         * </p>
         * 
         * @param botVersionReplicaSummaries
         *        The information summary used for the replicated bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionReplicaSummaries(BotVersionReplicaSummary... botVersionReplicaSummaries);

        /**
         * <p>
         * The information summary used for the replicated bots in the list of replicated bots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botVersionReplicaSummaries(List<BotVersionReplicaSummary>)}.
         * 
         * @param botVersionReplicaSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botVersionReplicaSummaries(java.util.Collection<BotVersionReplicaSummary>)
         */
        Builder botVersionReplicaSummaries(Consumer<BotVersionReplicaSummary.Builder>... botVersionReplicaSummaries);

        /**
         * <p>
         * The next token used for the replicated bots in the list of replicated bots.
         * </p>
         * 
         * @param nextToken
         *        The next token used for the replicated bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String sourceRegion;

        private String replicaRegion;

        private List<BotVersionReplicaSummary> botVersionReplicaSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionReplicasResponse model) {
            super(model);
            botId(model.botId);
            sourceRegion(model.sourceRegion);
            replicaRegion(model.replicaRegion);
            botVersionReplicaSummaries(model.botVersionReplicaSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getReplicaRegion() {
            return replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final List<BotVersionReplicaSummary.Builder> getBotVersionReplicaSummaries() {
            List<BotVersionReplicaSummary.Builder> result = BotVersionReplicaSummaryListCopier
                    .copyToBuilder(this.botVersionReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotVersionReplicaSummaries(
                Collection<BotVersionReplicaSummary.BuilderImpl> botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries = BotVersionReplicaSummaryListCopier.copyFromBuilder(botVersionReplicaSummaries);
        }

        @Override
        public final Builder botVersionReplicaSummaries(Collection<BotVersionReplicaSummary> botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries = BotVersionReplicaSummaryListCopier.copy(botVersionReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionReplicaSummaries(BotVersionReplicaSummary... botVersionReplicaSummaries) {
            botVersionReplicaSummaries(Arrays.asList(botVersionReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionReplicaSummaries(Consumer<BotVersionReplicaSummary.Builder>... botVersionReplicaSummaries) {
            botVersionReplicaSummaries(Stream.of(botVersionReplicaSummaries)
                    .map(c -> BotVersionReplicaSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotVersionReplicasResponse build() {
            return new ListBotVersionReplicasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
