/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsIntentStageResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsIntentStageResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binKeys").getter(AnalyticsIntentStageResult.getter(AnalyticsIntentStageResult::binKeys)).setter(AnalyticsIntentStageResult.setter(Builder::binKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentStageGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupByKeys").getter(AnalyticsIntentStageResult.getter(AnalyticsIntentStageResult::groupByKeys)).setter(AnalyticsIntentStageResult.setter(Builder::groupByKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentStageGroupByKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentStageMetricResult>> METRICS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricsResults").getter(AnalyticsIntentStageResult.getter(AnalyticsIntentStageResult::metricsResults)).setter(AnalyticsIntentStageResult.setter(Builder::metricsResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentStageMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD, GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AnalyticsBinKey> binKeys;
    private final List<AnalyticsIntentStageGroupByKey> groupByKeys;
    private final List<AnalyticsIntentStageMetricResult> metricsResults;

    private AnalyticsIntentStageResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
    }

    public final boolean hasBinKeys() {
        return this.binKeys != null && !(this.binKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinKey> binKeys() {
        return this.binKeys;
    }

    public final boolean hasGroupByKeys() {
        return this.groupByKeys != null && !(this.groupByKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentStageGroupByKey> groupByKeys() {
        return this.groupByKeys;
    }

    public final boolean hasMetricsResults() {
        return this.metricsResults != null && !(this.metricsResults instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentStageMetricResult> metricsResults() {
        return this.metricsResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinKeys() ? this.binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByKeys() ? this.groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsResults() ? this.metricsResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentStageResult)) {
            return false;
        }
        AnalyticsIntentStageResult other = (AnalyticsIntentStageResult)obj;
        return this.hasBinKeys() == other.hasBinKeys() && Objects.equals(this.binKeys(), other.binKeys()) && this.hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(this.groupByKeys(), other.groupByKeys()) && this.hasMetricsResults() == other.hasMetricsResults() && Objects.equals(this.metricsResults(), other.metricsResults());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsIntentStageResult").add("BinKeys", this.hasBinKeys() ? this.binKeys() : null).add("GroupByKeys", this.hasGroupByKeys() ? this.groupByKeys() : null).add("MetricsResults", this.hasMetricsResults() ? this.metricsResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "binKeys": {
                return Optional.ofNullable(clazz.cast(this.binKeys()));
            }
            case "groupByKeys": {
                return Optional.ofNullable(clazz.cast(this.groupByKeys()));
            }
            case "metricsResults": {
                return Optional.ofNullable(clazz.cast(this.metricsResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentStageResult, T> g) {
        return obj -> g.apply((AnalyticsIntentStageResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentStageGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentStageMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentStageResult model) {
            this.binKeys(model.binKeys);
            this.groupByKeys(model.groupByKeys);
            this.metricsResults(model.metricsResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey ... binKeys) {
            this.binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... binKeys) {
            this.binKeys(Stream.of(binKeys).map(c -> (AnalyticsBinKey)((AnalyticsBinKey.Builder)AnalyticsBinKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsIntentStageGroupByKey.Builder> result = AnalyticsIntentStageGroupByKeysCopier.copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsIntentStageGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsIntentStageGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsIntentStageGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsIntentStageGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsIntentStageGroupByKey ... groupByKeys) {
            this.groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsIntentStageGroupByKey.Builder> ... groupByKeys) {
            this.groupByKeys(Stream.of(groupByKeys).map(c -> (AnalyticsIntentStageGroupByKey)((AnalyticsIntentStageGroupByKey.Builder)AnalyticsIntentStageGroupByKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageMetricResult.Builder> getMetricsResults() {
            List<AnalyticsIntentStageMetricResult.Builder> result = AnalyticsIntentStageMetricResultsCopier.copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsIntentStageMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsIntentStageMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsIntentStageMetricResult> metricsResults) {
            this.metricsResults = AnalyticsIntentStageMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsIntentStageMetricResult ... metricsResults) {
            this.metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsIntentStageMetricResult.Builder> ... metricsResults) {
            this.metricsResults(Stream.of(metricsResults).map(c -> (AnalyticsIntentStageMetricResult)((AnalyticsIntentStageMetricResult.Builder)AnalyticsIntentStageMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalyticsIntentStageResult build() {
            return new AnalyticsIntentStageResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsIntentStageResult> {
        public Builder binKeys(Collection<AnalyticsBinKey> var1);

        public Builder binKeys(AnalyticsBinKey ... var1);

        public Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... var1);

        public Builder groupByKeys(Collection<AnalyticsIntentStageGroupByKey> var1);

        public Builder groupByKeys(AnalyticsIntentStageGroupByKey ... var1);

        public Builder groupByKeys(Consumer<AnalyticsIntentStageGroupByKey.Builder> ... var1);

        public Builder metricsResults(Collection<AnalyticsIntentStageMetricResult> var1);

        public Builder metricsResults(AnalyticsIntentStageMetricResult ... var1);

        public Builder metricsResults(Consumer<AnalyticsIntentStageMetricResult.Builder> ... var1);
    }
}

