/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportSummary> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(ImportSummary.getter(ImportSummary::importId)).setter(ImportSummary.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<String> IMPORTED_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedResourceId").getter(ImportSummary.getter(ImportSummary::importedResourceId)).setter(ImportSummary.setter(Builder::importedResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceId").build()}).build();
    private static final SdkField<String> IMPORTED_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedResourceName").getter(ImportSummary.getter(ImportSummary::importedResourceName)).setter(ImportSummary.setter(Builder::importedResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceName").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(ImportSummary.getter(ImportSummary::importStatusAsString)).setter(ImportSummary.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergeStrategy").getter(ImportSummary.getter(ImportSummary::mergeStrategyAsString)).setter(ImportSummary.setter(Builder::mergeStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(ImportSummary.getter(ImportSummary::creationDateTime)).setter(ImportSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(ImportSummary.getter(ImportSummary::lastUpdatedDateTime)).setter(ImportSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> IMPORTED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedResourceType").getter(ImportSummary.getter(ImportSummary::importedResourceTypeAsString)).setter(ImportSummary.setter(Builder::importedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORTED_RESOURCE_ID_FIELD, IMPORTED_RESOURCE_NAME_FIELD, IMPORT_STATUS_FIELD, MERGE_STRATEGY_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, IMPORTED_RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("importId", IMPORT_ID_FIELD);
            this.put("importedResourceId", IMPORTED_RESOURCE_ID_FIELD);
            this.put("importedResourceName", IMPORTED_RESOURCE_NAME_FIELD);
            this.put("importStatus", IMPORT_STATUS_FIELD);
            this.put("mergeStrategy", MERGE_STRATEGY_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
            this.put("importedResourceType", IMPORTED_RESOURCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String importId;
    private final String importedResourceId;
    private final String importedResourceName;
    private final String importStatus;
    private final String mergeStrategy;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String importedResourceType;

    private ImportSummary(BuilderImpl builder) {
        this.importId = builder.importId;
        this.importedResourceId = builder.importedResourceId;
        this.importedResourceName = builder.importedResourceName;
        this.importStatus = builder.importStatus;
        this.mergeStrategy = builder.mergeStrategy;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.importedResourceType = builder.importedResourceType;
    }

    public final String importId() {
        return this.importId;
    }

    public final String importedResourceId() {
        return this.importedResourceId;
    }

    public final String importedResourceName() {
        return this.importedResourceName;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public final String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final ImportResourceType importedResourceType() {
        return ImportResourceType.fromValue(this.importedResourceType);
    }

    public final String importedResourceTypeAsString() {
        return this.importedResourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedResourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSummary)) {
            return false;
        }
        ImportSummary other = (ImportSummary)obj;
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importedResourceId(), other.importedResourceId()) && Objects.equals(this.importedResourceName(), other.importedResourceName()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.importedResourceTypeAsString(), other.importedResourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSummary").add("ImportId", (Object)this.importId()).add("ImportedResourceId", (Object)this.importedResourceId()).add("ImportedResourceName", (Object)this.importedResourceName()).add("ImportStatus", (Object)this.importStatusAsString()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("ImportedResourceType", (Object)this.importedResourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importedResourceId": {
                return Optional.ofNullable(clazz.cast(this.importedResourceId()));
            }
            case "importedResourceName": {
                return Optional.ofNullable(clazz.cast(this.importedResourceName()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "importedResourceType": {
                return Optional.ofNullable(clazz.cast(this.importedResourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportSummary, T> g) {
        return obj -> g.apply((ImportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importId;
        private String importedResourceId;
        private String importedResourceName;
        private String importStatus;
        private String mergeStrategy;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String importedResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSummary model) {
            this.importId(model.importId);
            this.importedResourceId(model.importedResourceId);
            this.importedResourceName(model.importedResourceName);
            this.importStatus(model.importStatus);
            this.mergeStrategy(model.mergeStrategy);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.importedResourceType(model.importedResourceType);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportedResourceId() {
            return this.importedResourceId;
        }

        public final void setImportedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
        }

        @Override
        public final Builder importedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
            return this;
        }

        public final String getImportedResourceName() {
            return this.importedResourceName;
        }

        public final void setImportedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
        }

        @Override
        public final Builder importedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getImportedResourceType() {
            return this.importedResourceType;
        }

        public final void setImportedResourceType(String importedResourceType) {
            this.importedResourceType = importedResourceType;
        }

        @Override
        public final Builder importedResourceType(String importedResourceType) {
            this.importedResourceType = importedResourceType;
            return this;
        }

        @Override
        public final Builder importedResourceType(ImportResourceType importedResourceType) {
            this.importedResourceType(importedResourceType == null ? null : importedResourceType.toString());
            return this;
        }

        public ImportSummary build() {
            return new ImportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportSummary> {
        public Builder importId(String var1);

        public Builder importedResourceId(String var1);

        public Builder importedResourceName(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder importedResourceType(String var1);

        public Builder importedResourceType(ImportResourceType var1);
    }
}

