/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotLocaleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotLocaleSummary> {
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(BotLocaleSummary.getter(BotLocaleSummary::localeId)).setter(BotLocaleSummary.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeName").getter(BotLocaleSummary.getter(BotLocaleSummary::localeName)).setter(BotLocaleSummary.setter(Builder::localeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BotLocaleSummary.getter(BotLocaleSummary::description)).setter(BotLocaleSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botLocaleStatus").getter(BotLocaleSummary.getter(BotLocaleSummary::botLocaleStatusAsString)).setter(BotLocaleSummary.setter(Builder::botLocaleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(BotLocaleSummary.getter(BotLocaleSummary::lastUpdatedDateTime)).setter(BotLocaleSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<Instant> LAST_BUILD_SUBMITTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastBuildSubmittedDateTime").getter(BotLocaleSummary.getter(BotLocaleSummary::lastBuildSubmittedDateTime)).setter(BotLocaleSummary.setter(Builder::lastBuildSubmittedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastBuildSubmittedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_ID_FIELD, LOCALE_NAME_FIELD, DESCRIPTION_FIELD, BOT_LOCALE_STATUS_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LAST_BUILD_SUBMITTED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("localeName", LOCALE_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("botLocaleStatus", BOT_LOCALE_STATUS_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
            this.put("lastBuildSubmittedDateTime", LAST_BUILD_SUBMITTED_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String localeId;
    private final String localeName;
    private final String description;
    private final String botLocaleStatus;
    private final Instant lastUpdatedDateTime;
    private final Instant lastBuildSubmittedDateTime;

    private BotLocaleSummary(BuilderImpl builder) {
        this.localeId = builder.localeId;
        this.localeName = builder.localeName;
        this.description = builder.description;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.lastBuildSubmittedDateTime = builder.lastBuildSubmittedDateTime;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String localeName() {
        return this.localeName;
    }

    public final String description() {
        return this.description;
    }

    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(this.botLocaleStatus);
    }

    public final String botLocaleStatusAsString() {
        return this.botLocaleStatus;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final Instant lastBuildSubmittedDateTime() {
        return this.lastBuildSubmittedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBuildSubmittedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotLocaleSummary)) {
            return false;
        }
        BotLocaleSummary other = (BotLocaleSummary)obj;
        return Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.localeName(), other.localeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botLocaleStatusAsString(), other.botLocaleStatusAsString()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.lastBuildSubmittedDateTime(), other.lastBuildSubmittedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BotLocaleSummary").add("LocaleId", (Object)this.localeId()).add("LocaleName", (Object)this.localeName()).add("Description", (Object)this.description()).add("BotLocaleStatus", (Object)this.botLocaleStatusAsString()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("LastBuildSubmittedDateTime", (Object)this.lastBuildSubmittedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "localeName": {
                return Optional.ofNullable(clazz.cast(this.localeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botLocaleStatus": {
                return Optional.ofNullable(clazz.cast(this.botLocaleStatusAsString()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "lastBuildSubmittedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastBuildSubmittedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BotLocaleSummary, T> g) {
        return obj -> g.apply((BotLocaleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localeId;
        private String localeName;
        private String description;
        private String botLocaleStatus;
        private Instant lastUpdatedDateTime;
        private Instant lastBuildSubmittedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotLocaleSummary model) {
            this.localeId(model.localeId);
            this.localeName(model.localeName);
            this.description(model.description);
            this.botLocaleStatus(model.botLocaleStatus);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.lastBuildSubmittedDateTime(model.lastBuildSubmittedDateTime);
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getLocaleName() {
            return this.localeName;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        @Override
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotLocaleStatus() {
            return this.botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Instant getLastBuildSubmittedDateTime() {
            return this.lastBuildSubmittedDateTime;
        }

        public final void setLastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
        }

        @Override
        public final Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
            return this;
        }

        public BotLocaleSummary build() {
            return new BotLocaleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotLocaleSummary> {
        public Builder localeId(String var1);

        public Builder localeName(String var1);

        public Builder description(String var1);

        public Builder botLocaleStatus(String var1);

        public Builder botLocaleStatus(BotLocaleStatus var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder lastBuildSubmittedDateTime(Instant var1);
    }
}

